/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpamsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIpamsResponse.Builder, DescribeIpamsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeIpamsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<Ipam>> IPAMS_FIELD = SdkField
            .<List<Ipam>> builder(MarshallingType.LIST)
            .memberName("Ipams")
            .getter(getter(DescribeIpamsResponse::ipams))
            .setter(setter(Builder::ipams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamSet")
                    .unmarshallLocationName("ipamSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipam> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipam::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAMS_FIELD));

    private final String nextToken;

    private final List<Ipam> ipams;

    private DescribeIpamsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipams = builder.ipams;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipams property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIpams() {
        return ipams != null && !(ipams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPAMs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpams} method.
     * </p>
     * 
     * @return Information about the IPAMs.
     */
    public final List<Ipam> ipams() {
        return ipams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpams() ? ipams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamsResponse)) {
            return false;
        }
        DescribeIpamsResponse other = (DescribeIpamsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIpams() == other.hasIpams()
                && Objects.equals(ipams(), other.ipams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIpamsResponse").add("NextToken", nextToken()).add("Ipams", hasIpams() ? ipams() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Ipams":
            return Optional.ofNullable(clazz.cast(ipams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamsResponse, T> g) {
        return obj -> g.apply((DescribeIpamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIpamsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the IPAMs.
         * </p>
         * 
         * @param ipams
         *        Information about the IPAMs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipams(Collection<Ipam> ipams);

        /**
         * <p>
         * Information about the IPAMs.
         * </p>
         * 
         * @param ipams
         *        Information about the IPAMs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipams(Ipam... ipams);

        /**
         * <p>
         * Information about the IPAMs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipam>.Builder} avoiding the need to create
         * one manually via {@link List<Ipam>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipam>.Builder#build()} is called immediately and its result
         * is passed to {@link #ipams(List<Ipam>)}.
         * 
         * @param ipams
         *        a consumer that will call methods on {@link List<Ipam>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipams(List<Ipam>)
         */
        Builder ipams(Consumer<Ipam.Builder>... ipams);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<Ipam> ipams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamsResponse model) {
            super(model);
            nextToken(model.nextToken);
            ipams(model.ipams);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Ipam.Builder> getIpams() {
            List<Ipam.Builder> result = IpamSetCopier.copyToBuilder(this.ipams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpams(Collection<Ipam.BuilderImpl> ipams) {
            this.ipams = IpamSetCopier.copyFromBuilder(ipams);
        }

        @Override
        @Transient
        public final Builder ipams(Collection<Ipam> ipams) {
            this.ipams = IpamSetCopier.copy(ipams);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipams(Ipam... ipams) {
            ipams(Arrays.asList(ipams));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipams(Consumer<Ipam.Builder>... ipams) {
            ipams(Stream.of(ipams).map(c -> Ipam.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamsResponse build() {
            return new DescribeIpamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
