/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrunkInterfaceAssociationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeTrunkInterfaceAssociationsResponse.Builder, DescribeTrunkInterfaceAssociationsResponse> {
    private static final SdkField<List<TrunkInterfaceAssociation>> INTERFACE_ASSOCIATIONS_FIELD = SdkField
            .<List<TrunkInterfaceAssociation>> builder(MarshallingType.LIST)
            .memberName("InterfaceAssociations")
            .getter(getter(DescribeTrunkInterfaceAssociationsResponse::interfaceAssociations))
            .setter(setter(Builder::interfaceAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceAssociationSet")
                    .unmarshallLocationName("interfaceAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TrunkInterfaceAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrunkInterfaceAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeTrunkInterfaceAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TrunkInterfaceAssociation> interfaceAssociations;

    private final String nextToken;

    private DescribeTrunkInterfaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.interfaceAssociations = builder.interfaceAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterfaceAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInterfaceAssociations() {
        return interfaceAssociations != null && !(interfaceAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the trunk associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterfaceAssociations} method.
     * </p>
     * 
     * @return Information about the trunk associations.
     */
    public final List<TrunkInterfaceAssociation> interfaceAssociations() {
        return interfaceAssociations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInterfaceAssociations() ? interfaceAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrunkInterfaceAssociationsResponse)) {
            return false;
        }
        DescribeTrunkInterfaceAssociationsResponse other = (DescribeTrunkInterfaceAssociationsResponse) obj;
        return hasInterfaceAssociations() == other.hasInterfaceAssociations()
                && Objects.equals(interfaceAssociations(), other.interfaceAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrunkInterfaceAssociationsResponse")
                .add("InterfaceAssociations", hasInterfaceAssociations() ? interfaceAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterfaceAssociations":
            return Optional.ofNullable(clazz.cast(interfaceAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrunkInterfaceAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeTrunkInterfaceAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrunkInterfaceAssociationsResponse> {
        /**
         * <p>
         * Information about the trunk associations.
         * </p>
         * 
         * @param interfaceAssociations
         *        Information about the trunk associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssociations(Collection<TrunkInterfaceAssociation> interfaceAssociations);

        /**
         * <p>
         * Information about the trunk associations.
         * </p>
         * 
         * @param interfaceAssociations
         *        Information about the trunk associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssociations(TrunkInterfaceAssociation... interfaceAssociations);

        /**
         * <p>
         * Information about the trunk associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrunkInterfaceAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<TrunkInterfaceAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrunkInterfaceAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #interfaceAssociations(List<TrunkInterfaceAssociation>)}.
         * 
         * @param interfaceAssociations
         *        a consumer that will call methods on {@link List<TrunkInterfaceAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceAssociations(List<TrunkInterfaceAssociation>)
         */
        Builder interfaceAssociations(Consumer<TrunkInterfaceAssociation.Builder>... interfaceAssociations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TrunkInterfaceAssociation> interfaceAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrunkInterfaceAssociationsResponse model) {
            super(model);
            interfaceAssociations(model.interfaceAssociations);
            nextToken(model.nextToken);
        }

        public final List<TrunkInterfaceAssociation.Builder> getInterfaceAssociations() {
            List<TrunkInterfaceAssociation.Builder> result = TrunkInterfaceAssociationListCopier
                    .copyToBuilder(this.interfaceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceAssociations(Collection<TrunkInterfaceAssociation.BuilderImpl> interfaceAssociations) {
            this.interfaceAssociations = TrunkInterfaceAssociationListCopier.copyFromBuilder(interfaceAssociations);
        }

        @Override
        @Transient
        public final Builder interfaceAssociations(Collection<TrunkInterfaceAssociation> interfaceAssociations) {
            this.interfaceAssociations = TrunkInterfaceAssociationListCopier.copy(interfaceAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interfaceAssociations(TrunkInterfaceAssociation... interfaceAssociations) {
            interfaceAssociations(Arrays.asList(interfaceAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interfaceAssociations(Consumer<TrunkInterfaceAssociation.Builder>... interfaceAssociations) {
            interfaceAssociations(Stream.of(interfaceAssociations)
                    .map(c -> TrunkInterfaceAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTrunkInterfaceAssociationsResponse build() {
            return new DescribeTrunkInterfaceAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
