/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AttachNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachNetworkInterfaceResponse extends Ec2Response implements
        ToCopyableBuilder<AttachNetworkInterfaceResponse.Builder, AttachNetworkInterfaceResponse> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId")
            .getter(getter(AttachNetworkInterfaceResponse::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId")
                    .unmarshallLocationName("attachmentId").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(AttachNetworkInterfaceResponse::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("networkCardIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            NETWORK_CARD_INDEX_FIELD));

    private final String attachmentId;

    private final Integer networkCardIndex;

    private AttachNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.networkCardIndex = builder.networkCardIndex;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The index of the network card.
     * </p>
     * 
     * @return The index of the network card.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceResponse)) {
            return false;
        }
        AttachNetworkInterfaceResponse other = (AttachNetworkInterfaceResponse) obj;
        return Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(networkCardIndex(), other.networkCardIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachNetworkInterfaceResponse").add("AttachmentId", attachmentId())
                .add("NetworkCardIndex", networkCardIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((AttachNetworkInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AttachNetworkInterfaceResponse> {
        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The index of the network card.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String attachmentId;

        private Integer networkCardIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceResponse model) {
            super(model);
            attachmentId(model.attachmentId);
            networkCardIndex(model.networkCardIndex);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        @Transient
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        @Transient
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        @Override
        public AttachNetworkInterfaceResponse build() {
            return new AttachNetworkInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
