/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network insights analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInsightsAnalysis implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInsightsAnalysis.Builder, NetworkInsightsAnalysis> {
    private static final SdkField<String> NETWORK_INSIGHTS_ANALYSIS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAnalysisId")
            .getter(getter(NetworkInsightsAnalysis::networkInsightsAnalysisId))
            .setter(setter(Builder::networkInsightsAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisId")
                    .unmarshallLocationName("networkInsightsAnalysisId").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_ANALYSIS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAnalysisArn")
            .getter(getter(NetworkInsightsAnalysis::networkInsightsAnalysisArn))
            .setter(setter(Builder::networkInsightsAnalysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisArn")
                    .unmarshallLocationName("networkInsightsAnalysisArn").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathId")
            .getter(getter(NetworkInsightsAnalysis::networkInsightsPathId))
            .setter(setter(Builder::networkInsightsPathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId")
                    .unmarshallLocationName("networkInsightsPathId").build()).build();

    private static final SdkField<List<String>> FILTER_IN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterInArns")
            .getter(getter(NetworkInsightsAnalysis::filterInArns))
            .setter(setter(Builder::filterInArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterInArnSet")
                    .unmarshallLocationName("filterInArnSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(NetworkInsightsAnalysis::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("startDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(NetworkInsightsAnalysis::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(NetworkInsightsAnalysis::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<Boolean> NETWORK_PATH_FOUND_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NetworkPathFound")
            .getter(getter(NetworkInsightsAnalysis::networkPathFound))
            .setter(setter(Builder::networkPathFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPathFound")
                    .unmarshallLocationName("networkPathFound").build()).build();

    private static final SdkField<List<PathComponent>> FORWARD_PATH_COMPONENTS_FIELD = SdkField
            .<List<PathComponent>> builder(MarshallingType.LIST)
            .memberName("ForwardPathComponents")
            .getter(getter(NetworkInsightsAnalysis::forwardPathComponents))
            .setter(setter(Builder::forwardPathComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardPathComponentSet")
                    .unmarshallLocationName("forwardPathComponentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PathComponent>> RETURN_PATH_COMPONENTS_FIELD = SdkField
            .<List<PathComponent>> builder(MarshallingType.LIST)
            .memberName("ReturnPathComponents")
            .getter(getter(NetworkInsightsAnalysis::returnPathComponents))
            .setter(setter(Builder::returnPathComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPathComponentSet")
                    .unmarshallLocationName("returnPathComponentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Explanation>> EXPLANATIONS_FIELD = SdkField
            .<List<Explanation>> builder(MarshallingType.LIST)
            .memberName("Explanations")
            .getter(getter(NetworkInsightsAnalysis::explanations))
            .setter(setter(Builder::explanations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplanationSet")
                    .unmarshallLocationName("explanationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Explanation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Explanation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<AlternatePathHint>> ALTERNATE_PATH_HINTS_FIELD = SdkField
            .<List<AlternatePathHint>> builder(MarshallingType.LIST)
            .memberName("AlternatePathHints")
            .getter(getter(NetworkInsightsAnalysis::alternatePathHints))
            .setter(setter(Builder::alternatePathHints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternatePathHintSet")
                    .unmarshallLocationName("alternatePathHintSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AlternatePathHint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlternatePathHint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NetworkInsightsAnalysis::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ANALYSIS_ARN_FIELD, NETWORK_INSIGHTS_PATH_ID_FIELD,
            FILTER_IN_ARNS_FIELD, START_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, NETWORK_PATH_FOUND_FIELD,
            FORWARD_PATH_COMPONENTS_FIELD, RETURN_PATH_COMPONENTS_FIELD, EXPLANATIONS_FIELD, ALTERNATE_PATH_HINTS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInsightsAnalysisId;

    private final String networkInsightsAnalysisArn;

    private final String networkInsightsPathId;

    private final List<String> filterInArns;

    private final Instant startDate;

    private final String status;

    private final String statusMessage;

    private final Boolean networkPathFound;

    private final List<PathComponent> forwardPathComponents;

    private final List<PathComponent> returnPathComponents;

    private final List<Explanation> explanations;

    private final List<AlternatePathHint> alternatePathHints;

    private final List<Tag> tags;

    private NetworkInsightsAnalysis(BuilderImpl builder) {
        this.networkInsightsAnalysisId = builder.networkInsightsAnalysisId;
        this.networkInsightsAnalysisArn = builder.networkInsightsAnalysisArn;
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.filterInArns = builder.filterInArns;
        this.startDate = builder.startDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.networkPathFound = builder.networkPathFound;
        this.forwardPathComponents = builder.forwardPathComponents;
        this.returnPathComponents = builder.returnPathComponents;
        this.explanations = builder.explanations;
        this.alternatePathHints = builder.alternatePathHints;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the network insights analysis.
     * </p>
     * 
     * @return The ID of the network insights analysis.
     */
    public final String networkInsightsAnalysisId() {
        return networkInsightsAnalysisId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network insights analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network insights analysis.
     */
    public final String networkInsightsAnalysisArn() {
        return networkInsightsAnalysisArn;
    }

    /**
     * <p>
     * The ID of the path.
     * </p>
     * 
     * @return The ID of the path.
     */
    public final String networkInsightsPathId() {
        return networkInsightsPathId;
    }

    /**
     * Returns true if the FilterInArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilterInArns() {
        return filterInArns != null && !(filterInArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterInArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
     */
    public final List<String> filterInArns() {
        return filterInArns;
    }

    /**
     * <p>
     * The time the analysis started.
     * </p>
     * 
     * @return The time the analysis started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The status of the network insights analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network insights analysis.
     * @see AnalysisStatus
     */
    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network insights analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network insights analysis.
     * @see AnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message, if the status is <code>failed</code>.
     * </p>
     * 
     * @return The status message, if the status is <code>failed</code>.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Indicates whether the destination is reachable from the source.
     * </p>
     * 
     * @return Indicates whether the destination is reachable from the source.
     */
    public final Boolean networkPathFound() {
        return networkPathFound;
    }

    /**
     * Returns true if the ForwardPathComponents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasForwardPathComponents() {
        return forwardPathComponents != null && !(forwardPathComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components in the path from source to destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasForwardPathComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components in the path from source to destination.
     */
    public final List<PathComponent> forwardPathComponents() {
        return forwardPathComponents;
    }

    /**
     * Returns true if the ReturnPathComponents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReturnPathComponents() {
        return returnPathComponents != null && !(returnPathComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components in the path from destination to source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReturnPathComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components in the path from destination to source.
     */
    public final List<PathComponent> returnPathComponents() {
        return returnPathComponents;
    }

    /**
     * Returns true if the Explanations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExplanations() {
        return explanations != null && !(explanations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The explanations. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer
     * explanation codes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExplanations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The explanations. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer
     *         explanation codes</a>.
     */
    public final List<Explanation> explanations() {
        return explanations;
    }

    /**
     * Returns true if the AlternatePathHints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAlternatePathHints() {
        return alternatePathHints != null && !(alternatePathHints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Potential intermediate components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlternatePathHints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Potential intermediate components.
     */
    public final List<AlternatePathHint> alternatePathHints() {
        return alternatePathHints;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterInArns() ? filterInArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(networkPathFound());
        hashCode = 31 * hashCode + Objects.hashCode(hasForwardPathComponents() ? forwardPathComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReturnPathComponents() ? returnPathComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExplanations() ? explanations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternatePathHints() ? alternatePathHints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAnalysis)) {
            return false;
        }
        NetworkInsightsAnalysis other = (NetworkInsightsAnalysis) obj;
        return Objects.equals(networkInsightsAnalysisId(), other.networkInsightsAnalysisId())
                && Objects.equals(networkInsightsAnalysisArn(), other.networkInsightsAnalysisArn())
                && Objects.equals(networkInsightsPathId(), other.networkInsightsPathId())
                && hasFilterInArns() == other.hasFilterInArns() && Objects.equals(filterInArns(), other.filterInArns())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(networkPathFound(), other.networkPathFound())
                && hasForwardPathComponents() == other.hasForwardPathComponents()
                && Objects.equals(forwardPathComponents(), other.forwardPathComponents())
                && hasReturnPathComponents() == other.hasReturnPathComponents()
                && Objects.equals(returnPathComponents(), other.returnPathComponents())
                && hasExplanations() == other.hasExplanations() && Objects.equals(explanations(), other.explanations())
                && hasAlternatePathHints() == other.hasAlternatePathHints()
                && Objects.equals(alternatePathHints(), other.alternatePathHints()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInsightsAnalysis").add("NetworkInsightsAnalysisId", networkInsightsAnalysisId())
                .add("NetworkInsightsAnalysisArn", networkInsightsAnalysisArn())
                .add("NetworkInsightsPathId", networkInsightsPathId())
                .add("FilterInArns", hasFilterInArns() ? filterInArns() : null).add("StartDate", startDate())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("NetworkPathFound", networkPathFound())
                .add("ForwardPathComponents", hasForwardPathComponents() ? forwardPathComponents() : null)
                .add("ReturnPathComponents", hasReturnPathComponents() ? returnPathComponents() : null)
                .add("Explanations", hasExplanations() ? explanations() : null)
                .add("AlternatePathHints", hasAlternatePathHints() ? alternatePathHints() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAnalysisId":
            return Optional.ofNullable(clazz.cast(networkInsightsAnalysisId()));
        case "NetworkInsightsAnalysisArn":
            return Optional.ofNullable(clazz.cast(networkInsightsAnalysisArn()));
        case "NetworkInsightsPathId":
            return Optional.ofNullable(clazz.cast(networkInsightsPathId()));
        case "FilterInArns":
            return Optional.ofNullable(clazz.cast(filterInArns()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "NetworkPathFound":
            return Optional.ofNullable(clazz.cast(networkPathFound()));
        case "ForwardPathComponents":
            return Optional.ofNullable(clazz.cast(forwardPathComponents()));
        case "ReturnPathComponents":
            return Optional.ofNullable(clazz.cast(returnPathComponents()));
        case "Explanations":
            return Optional.ofNullable(clazz.cast(explanations()));
        case "AlternatePathHints":
            return Optional.ofNullable(clazz.cast(alternatePathHints()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAnalysis, T> g) {
        return obj -> g.apply((NetworkInsightsAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInsightsAnalysis> {
        /**
         * <p>
         * The ID of the network insights analysis.
         * </p>
         * 
         * @param networkInsightsAnalysisId
         *        The ID of the network insights analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAnalysisId(String networkInsightsAnalysisId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network insights analysis.
         * </p>
         * 
         * @param networkInsightsAnalysisArn
         *        The Amazon Resource Name (ARN) of the network insights analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAnalysisArn(String networkInsightsAnalysisArn);

        /**
         * <p>
         * The ID of the path.
         * </p>
         * 
         * @param networkInsightsPathId
         *        The ID of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathId(String networkInsightsPathId);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(Collection<String> filterInArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(String... filterInArns);

        /**
         * <p>
         * The time the analysis started.
         * </p>
         * 
         * @param startDate
         *        The time the analysis started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The status of the network insights analysis.
         * </p>
         * 
         * @param status
         *        The status of the network insights analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network insights analysis.
         * </p>
         * 
         * @param status
         *        The status of the network insights analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(AnalysisStatus status);

        /**
         * <p>
         * The status message, if the status is <code>failed</code>.
         * </p>
         * 
         * @param statusMessage
         *        The status message, if the status is <code>failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Indicates whether the destination is reachable from the source.
         * </p>
         * 
         * @param networkPathFound
         *        Indicates whether the destination is reachable from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPathFound(Boolean networkPathFound);

        /**
         * <p>
         * The components in the path from source to destination.
         * </p>
         * 
         * @param forwardPathComponents
         *        The components in the path from source to destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardPathComponents(Collection<PathComponent> forwardPathComponents);

        /**
         * <p>
         * The components in the path from source to destination.
         * </p>
         * 
         * @param forwardPathComponents
         *        The components in the path from source to destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardPathComponents(PathComponent... forwardPathComponents);

        /**
         * <p>
         * The components in the path from source to destination.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PathComponent>.Builder} avoiding the need
         * to create one manually via {@link List<PathComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PathComponent>.Builder#build()} is called immediately and
         * its result is passed to {@link #forwardPathComponents(List<PathComponent>)}.
         * 
         * @param forwardPathComponents
         *        a consumer that will call methods on {@link List<PathComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardPathComponents(List<PathComponent>)
         */
        Builder forwardPathComponents(Consumer<PathComponent.Builder>... forwardPathComponents);

        /**
         * <p>
         * The components in the path from destination to source.
         * </p>
         * 
         * @param returnPathComponents
         *        The components in the path from destination to source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnPathComponents(Collection<PathComponent> returnPathComponents);

        /**
         * <p>
         * The components in the path from destination to source.
         * </p>
         * 
         * @param returnPathComponents
         *        The components in the path from destination to source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnPathComponents(PathComponent... returnPathComponents);

        /**
         * <p>
         * The components in the path from destination to source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PathComponent>.Builder} avoiding the need
         * to create one manually via {@link List<PathComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PathComponent>.Builder#build()} is called immediately and
         * its result is passed to {@link #returnPathComponents(List<PathComponent>)}.
         * 
         * @param returnPathComponents
         *        a consumer that will call methods on {@link List<PathComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnPathComponents(List<PathComponent>)
         */
        Builder returnPathComponents(Consumer<PathComponent.Builder>... returnPathComponents);

        /**
         * <p>
         * The explanations. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer
         * explanation codes</a>.
         * </p>
         * 
         * @param explanations
         *        The explanations. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability
         *        Analyzer explanation codes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explanations(Collection<Explanation> explanations);

        /**
         * <p>
         * The explanations. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer
         * explanation codes</a>.
         * </p>
         * 
         * @param explanations
         *        The explanations. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability
         *        Analyzer explanation codes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explanations(Explanation... explanations);

        /**
         * <p>
         * The explanations. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer
         * explanation codes</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Explanation>.Builder} avoiding the need to
         * create one manually via {@link List<Explanation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Explanation>.Builder#build()} is called immediately and its
         * result is passed to {@link #explanations(List<Explanation>)}.
         * 
         * @param explanations
         *        a consumer that will call methods on {@link List<Explanation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explanations(List<Explanation>)
         */
        Builder explanations(Consumer<Explanation.Builder>... explanations);

        /**
         * <p>
         * Potential intermediate components.
         * </p>
         * 
         * @param alternatePathHints
         *        Potential intermediate components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternatePathHints(Collection<AlternatePathHint> alternatePathHints);

        /**
         * <p>
         * Potential intermediate components.
         * </p>
         * 
         * @param alternatePathHints
         *        Potential intermediate components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternatePathHints(AlternatePathHint... alternatePathHints);

        /**
         * <p>
         * Potential intermediate components.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AlternatePathHint>.Builder} avoiding the
         * need to create one manually via {@link List<AlternatePathHint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlternatePathHint>.Builder#build()} is called immediately
         * and its result is passed to {@link #alternatePathHints(List<AlternatePathHint>)}.
         * 
         * @param alternatePathHints
         *        a consumer that will call methods on {@link List<AlternatePathHint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternatePathHints(List<AlternatePathHint>)
         */
        Builder alternatePathHints(Consumer<AlternatePathHint.Builder>... alternatePathHints);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String networkInsightsAnalysisId;

        private String networkInsightsAnalysisArn;

        private String networkInsightsPathId;

        private List<String> filterInArns = DefaultSdkAutoConstructList.getInstance();

        private Instant startDate;

        private String status;

        private String statusMessage;

        private Boolean networkPathFound;

        private List<PathComponent> forwardPathComponents = DefaultSdkAutoConstructList.getInstance();

        private List<PathComponent> returnPathComponents = DefaultSdkAutoConstructList.getInstance();

        private List<Explanation> explanations = DefaultSdkAutoConstructList.getInstance();

        private List<AlternatePathHint> alternatePathHints = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAnalysis model) {
            networkInsightsAnalysisId(model.networkInsightsAnalysisId);
            networkInsightsAnalysisArn(model.networkInsightsAnalysisArn);
            networkInsightsPathId(model.networkInsightsPathId);
            filterInArns(model.filterInArns);
            startDate(model.startDate);
            status(model.status);
            statusMessage(model.statusMessage);
            networkPathFound(model.networkPathFound);
            forwardPathComponents(model.forwardPathComponents);
            returnPathComponents(model.returnPathComponents);
            explanations(model.explanations);
            alternatePathHints(model.alternatePathHints);
            tags(model.tags);
        }

        public final String getNetworkInsightsAnalysisId() {
            return networkInsightsAnalysisId;
        }

        public final void setNetworkInsightsAnalysisId(String networkInsightsAnalysisId) {
            this.networkInsightsAnalysisId = networkInsightsAnalysisId;
        }

        @Override
        @Transient
        public final Builder networkInsightsAnalysisId(String networkInsightsAnalysisId) {
            this.networkInsightsAnalysisId = networkInsightsAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAnalysisArn() {
            return networkInsightsAnalysisArn;
        }

        public final void setNetworkInsightsAnalysisArn(String networkInsightsAnalysisArn) {
            this.networkInsightsAnalysisArn = networkInsightsAnalysisArn;
        }

        @Override
        @Transient
        public final Builder networkInsightsAnalysisArn(String networkInsightsAnalysisArn) {
            this.networkInsightsAnalysisArn = networkInsightsAnalysisArn;
            return this;
        }

        public final String getNetworkInsightsPathId() {
            return networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        @Transient
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final Collection<String> getFilterInArns() {
            if (filterInArns instanceof SdkAutoConstructList) {
                return null;
            }
            return filterInArns;
        }

        public final void setFilterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
        }

        @Override
        @Transient
        public final Builder filterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filterInArns(String... filterInArns) {
            filterInArns(Arrays.asList(filterInArns));
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Boolean getNetworkPathFound() {
            return networkPathFound;
        }

        public final void setNetworkPathFound(Boolean networkPathFound) {
            this.networkPathFound = networkPathFound;
        }

        @Override
        @Transient
        public final Builder networkPathFound(Boolean networkPathFound) {
            this.networkPathFound = networkPathFound;
            return this;
        }

        public final List<PathComponent.Builder> getForwardPathComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.forwardPathComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForwardPathComponents(Collection<PathComponent.BuilderImpl> forwardPathComponents) {
            this.forwardPathComponents = PathComponentListCopier.copyFromBuilder(forwardPathComponents);
        }

        @Override
        @Transient
        public final Builder forwardPathComponents(Collection<PathComponent> forwardPathComponents) {
            this.forwardPathComponents = PathComponentListCopier.copy(forwardPathComponents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forwardPathComponents(PathComponent... forwardPathComponents) {
            forwardPathComponents(Arrays.asList(forwardPathComponents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forwardPathComponents(Consumer<PathComponent.Builder>... forwardPathComponents) {
            forwardPathComponents(Stream.of(forwardPathComponents).map(c -> PathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PathComponent.Builder> getReturnPathComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.returnPathComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnPathComponents(Collection<PathComponent.BuilderImpl> returnPathComponents) {
            this.returnPathComponents = PathComponentListCopier.copyFromBuilder(returnPathComponents);
        }

        @Override
        @Transient
        public final Builder returnPathComponents(Collection<PathComponent> returnPathComponents) {
            this.returnPathComponents = PathComponentListCopier.copy(returnPathComponents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder returnPathComponents(PathComponent... returnPathComponents) {
            returnPathComponents(Arrays.asList(returnPathComponents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder returnPathComponents(Consumer<PathComponent.Builder>... returnPathComponents) {
            returnPathComponents(Stream.of(returnPathComponents).map(c -> PathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Explanation.Builder> getExplanations() {
            List<Explanation.Builder> result = ExplanationListCopier.copyToBuilder(this.explanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplanations(Collection<Explanation.BuilderImpl> explanations) {
            this.explanations = ExplanationListCopier.copyFromBuilder(explanations);
        }

        @Override
        @Transient
        public final Builder explanations(Collection<Explanation> explanations) {
            this.explanations = ExplanationListCopier.copy(explanations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder explanations(Explanation... explanations) {
            explanations(Arrays.asList(explanations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder explanations(Consumer<Explanation.Builder>... explanations) {
            explanations(Stream.of(explanations).map(c -> Explanation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AlternatePathHint.Builder> getAlternatePathHints() {
            List<AlternatePathHint.Builder> result = AlternatePathHintListCopier.copyToBuilder(this.alternatePathHints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternatePathHints(Collection<AlternatePathHint.BuilderImpl> alternatePathHints) {
            this.alternatePathHints = AlternatePathHintListCopier.copyFromBuilder(alternatePathHints);
        }

        @Override
        @Transient
        public final Builder alternatePathHints(Collection<AlternatePathHint> alternatePathHints) {
            this.alternatePathHints = AlternatePathHintListCopier.copy(alternatePathHints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alternatePathHints(AlternatePathHint... alternatePathHints) {
            alternatePathHints(Arrays.asList(alternatePathHints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alternatePathHints(Consumer<AlternatePathHint.Builder>... alternatePathHints) {
            alternatePathHints(Stream.of(alternatePathHints).map(c -> AlternatePathHint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkInsightsAnalysis build() {
            return new NetworkInsightsAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
