/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC in a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcPeeringConnectionVpcInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcPeeringConnectionVpcInfo.Builder, VpcPeeringConnectionVpcInfo> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(VpcPeeringConnectionVpcInfo::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<List<Ipv6CidrBlock>> IPV6_CIDR_BLOCK_SET_FIELD = SdkField
            .<List<Ipv6CidrBlock>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockSet")
            .getter(getter(VpcPeeringConnectionVpcInfo::ipv6CidrBlockSet))
            .setter(setter(Builder::ipv6CidrBlockSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockSet")
                    .unmarshallLocationName("ipv6CidrBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6CidrBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6CidrBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<CidrBlock>> CIDR_BLOCK_SET_FIELD = SdkField
            .<List<CidrBlock>> builder(MarshallingType.LIST)
            .memberName("CidrBlockSet")
            .getter(getter(VpcPeeringConnectionVpcInfo::cidrBlockSet))
            .setter(setter(Builder::cidrBlockSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockSet")
                    .unmarshallLocationName("cidrBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CidrBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(CidrBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(VpcPeeringConnectionVpcInfo::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<VpcPeeringConnectionOptionsDescription> PEERING_OPTIONS_FIELD = SdkField
            .<VpcPeeringConnectionOptionsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("PeeringOptions")
            .getter(getter(VpcPeeringConnectionVpcInfo::peeringOptions))
            .setter(setter(Builder::peeringOptions))
            .constructor(VpcPeeringConnectionOptionsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringOptions")
                    .unmarshallLocationName("peeringOptions").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(VpcPeeringConnectionVpcInfo::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Region")
            .getter(getter(VpcPeeringConnectionVpcInfo::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            IPV6_CIDR_BLOCK_SET_FIELD, CIDR_BLOCK_SET_FIELD, OWNER_ID_FIELD, PEERING_OPTIONS_FIELD, VPC_ID_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidrBlock;

    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;

    private final List<CidrBlock> cidrBlockSet;

    private final String ownerId;

    private final VpcPeeringConnectionOptionsDescription peeringOptions;

    private final String vpcId;

    private final String region;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
        this.region = builder.region;
    }

    /**
     * <p>
     * The IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv4 CIDR block for the VPC.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * Returns true if the Ipv6CidrBlockSet property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIpv6CidrBlockSet() {
        return ipv6CidrBlockSet != null && !(ipv6CidrBlockSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 CIDR block for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6CidrBlockSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 CIDR block for the VPC.
     */
    public final List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return ipv6CidrBlockSet;
    }

    /**
     * Returns true if the CidrBlockSet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCidrBlockSet() {
        return cidrBlockSet != null && !(cidrBlockSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCidrBlockSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks for the VPC.
     */
    public final List<CidrBlock> cidrBlockSet() {
        return cidrBlockSet;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the VPC.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the VPC.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter or requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter or requester VPC.
     */
    public final VpcPeeringConnectionOptionsDescription peeringOptions() {
        return peeringOptions;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The Region in which the VPC is located.
     * </p>
     * 
     * @return The Region in which the VPC is located.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6CidrBlockSet() ? ipv6CidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlockSet() ? cidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && hasIpv6CidrBlockSet() == other.hasIpv6CidrBlockSet()
                && Objects.equals(ipv6CidrBlockSet(), other.ipv6CidrBlockSet()) && hasCidrBlockSet() == other.hasCidrBlockSet()
                && Objects.equals(cidrBlockSet(), other.cidrBlockSet()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(peeringOptions(), other.peeringOptions()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcPeeringConnectionVpcInfo").add("CidrBlock", cidrBlock())
                .add("Ipv6CidrBlockSet", hasIpv6CidrBlockSet() ? ipv6CidrBlockSet() : null)
                .add("CidrBlockSet", hasCidrBlockSet() ? cidrBlockSet() : null).add("OwnerId", ownerId())
                .add("PeeringOptions", peeringOptions()).add("VpcId", vpcId()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Ipv6CidrBlockSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockSet()));
        case "CidrBlockSet":
            return Optional.ofNullable(clazz.cast(cidrBlockSet()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PeeringOptions":
            return Optional.ofNullable(clazz.cast(peeringOptions()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnectionVpcInfo, T> g) {
        return obj -> g.apply((VpcPeeringConnectionVpcInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        /**
         * <p>
         * The IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6CidrBlock>.Builder} avoiding the need
         * to create one manually via {@link List<Ipv6CidrBlock>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6CidrBlock>.Builder#build()} is called immediately and
         * its result is passed to {@link #ipv6CidrBlockSet(List<Ipv6CidrBlock>)}.
         * 
         * @param ipv6CidrBlockSet
         *        a consumer that will call methods on {@link List<Ipv6CidrBlock>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockSet(List<Ipv6CidrBlock>)
         */
        Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder>... ipv6CidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(CidrBlock... cidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CidrBlock>.Builder} avoiding the need to
         * create one manually via {@link List<CidrBlock>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CidrBlock>.Builder#build()} is called immediately and its
         * result is passed to {@link #cidrBlockSet(List<CidrBlock>)}.
         * 
         * @param cidrBlockSet
         *        a consumer that will call methods on {@link List<CidrBlock>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockSet(List<CidrBlock>)
         */
        Builder cidrBlockSet(Consumer<CidrBlock.Builder>... cidrBlockSet);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the VPC.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * 
         * @param peeringOptions
         *        Information about the VPC peering connection options for the accepter or requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionOptionsDescription.Builder}
         * avoiding the need to create one manually via {@link VpcPeeringConnectionOptionsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionOptionsDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #peeringOptions(VpcPeeringConnectionOptionsDescription)}.
         * 
         * @param peeringOptions
         *        a consumer that will call methods on {@link VpcPeeringConnectionOptionsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peeringOptions(VpcPeeringConnectionOptionsDescription)
         */
        default Builder peeringOptions(Consumer<VpcPeeringConnectionOptionsDescription.Builder> peeringOptions) {
            return peeringOptions(VpcPeeringConnectionOptionsDescription.builder().applyMutation(peeringOptions).build());
        }

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The Region in which the VPC is located.
         * </p>
         * 
         * @param region
         *        The Region in which the VPC is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private List<Ipv6CidrBlock> ipv6CidrBlockSet = DefaultSdkAutoConstructList.getInstance();

        private List<CidrBlock> cidrBlockSet = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private VpcPeeringConnectionOptionsDescription peeringOptions;

        private String vpcId;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            cidrBlock(model.cidrBlock);
            ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            cidrBlockSet(model.cidrBlockSet);
            ownerId(model.ownerId);
            peeringOptions(model.peeringOptions);
            vpcId(model.vpcId);
            region(model.region);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        @Transient
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final List<Ipv6CidrBlock.Builder> getIpv6CidrBlockSet() {
            List<Ipv6CidrBlock.Builder> result = Ipv6CidrBlockSetCopier.copyToBuilder(this.ipv6CidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        @Override
        @Transient
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder>... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Stream.of(ipv6CidrBlockSet).map(c -> Ipv6CidrBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CidrBlock.Builder> getCidrBlockSet() {
            List<CidrBlock.Builder> result = CidrBlockSetCopier.copyToBuilder(this.cidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockSet(Collection<CidrBlock.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copyFromBuilder(cidrBlockSet);
        }

        @Override
        @Transient
        public final Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cidrBlockSet(CidrBlock... cidrBlockSet) {
            cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cidrBlockSet(Consumer<CidrBlock.Builder>... cidrBlockSet) {
            cidrBlockSet(Stream.of(cidrBlockSet).map(c -> CidrBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final VpcPeeringConnectionOptionsDescription.Builder getPeeringOptions() {
            return peeringOptions != null ? peeringOptions.toBuilder() : null;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
