/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Network Access Scope content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInsightsAccessScopeContent implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInsightsAccessScopeContent.Builder, NetworkInsightsAccessScopeContent> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeId")
            .getter(getter(NetworkInsightsAccessScopeContent::networkInsightsAccessScopeId))
            .setter(setter(Builder::networkInsightsAccessScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId")
                    .unmarshallLocationName("networkInsightsAccessScopeId").build()).build();

    private static final SdkField<List<AccessScopePath>> MATCH_PATHS_FIELD = SdkField
            .<List<AccessScopePath>> builder(MarshallingType.LIST)
            .memberName("MatchPaths")
            .getter(getter(NetworkInsightsAccessScopeContent::matchPaths))
            .setter(setter(Builder::matchPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPathSet")
                    .unmarshallLocationName("matchPathSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AccessScopePath> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessScopePath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<AccessScopePath>> EXCLUDE_PATHS_FIELD = SdkField
            .<List<AccessScopePath>> builder(MarshallingType.LIST)
            .memberName("ExcludePaths")
            .getter(getter(NetworkInsightsAccessScopeContent::excludePaths))
            .setter(setter(Builder::excludePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePathSet")
                    .unmarshallLocationName("excludePathSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AccessScopePath> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessScopePath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, MATCH_PATHS_FIELD, EXCLUDE_PATHS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInsightsAccessScopeId;

    private final List<AccessScopePath> matchPaths;

    private final List<AccessScopePath> excludePaths;

    private NetworkInsightsAccessScopeContent(BuilderImpl builder) {
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.matchPaths = builder.matchPaths;
        this.excludePaths = builder.excludePaths;
    }

    /**
     * <p>
     * The ID of the Network Access Scope.
     * </p>
     * 
     * @return The ID of the Network Access Scope.
     */
    public final String networkInsightsAccessScopeId() {
        return networkInsightsAccessScopeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMatchPaths() {
        return matchPaths != null && !(matchPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The paths to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchPaths} method.
     * </p>
     * 
     * @return The paths to match.
     */
    public final List<AccessScopePath> matchPaths() {
        return matchPaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludePaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludePaths() {
        return excludePaths != null && !(excludePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The paths to exclude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludePaths} method.
     * </p>
     * 
     * @return The paths to exclude.
     */
    public final List<AccessScopePath> excludePaths() {
        return excludePaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchPaths() ? matchPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludePaths() ? excludePaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAccessScopeContent)) {
            return false;
        }
        NetworkInsightsAccessScopeContent other = (NetworkInsightsAccessScopeContent) obj;
        return Objects.equals(networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId())
                && hasMatchPaths() == other.hasMatchPaths() && Objects.equals(matchPaths(), other.matchPaths())
                && hasExcludePaths() == other.hasExcludePaths() && Objects.equals(excludePaths(), other.excludePaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInsightsAccessScopeContent")
                .add("NetworkInsightsAccessScopeId", networkInsightsAccessScopeId())
                .add("MatchPaths", hasMatchPaths() ? matchPaths() : null)
                .add("ExcludePaths", hasExcludePaths() ? excludePaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeId()));
        case "MatchPaths":
            return Optional.ofNullable(clazz.cast(matchPaths()));
        case "ExcludePaths":
            return Optional.ofNullable(clazz.cast(excludePaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAccessScopeContent, T> g) {
        return obj -> g.apply((NetworkInsightsAccessScopeContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInsightsAccessScopeContent> {
        /**
         * <p>
         * The ID of the Network Access Scope.
         * </p>
         * 
         * @param networkInsightsAccessScopeId
         *        The ID of the Network Access Scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId);

        /**
         * <p>
         * The paths to match.
         * </p>
         * 
         * @param matchPaths
         *        The paths to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPaths(Collection<AccessScopePath> matchPaths);

        /**
         * <p>
         * The paths to match.
         * </p>
         * 
         * @param matchPaths
         *        The paths to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPaths(AccessScopePath... matchPaths);

        /**
         * <p>
         * The paths to match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessScopePath>.Builder} avoiding the need
         * to create one manually via {@link List<AccessScopePath>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessScopePath>.Builder#build()} is called immediately and
         * its result is passed to {@link #matchPaths(List<AccessScopePath>)}.
         * 
         * @param matchPaths
         *        a consumer that will call methods on {@link List<AccessScopePath>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchPaths(List<AccessScopePath>)
         */
        Builder matchPaths(Consumer<AccessScopePath.Builder>... matchPaths);

        /**
         * <p>
         * The paths to exclude.
         * </p>
         * 
         * @param excludePaths
         *        The paths to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePaths(Collection<AccessScopePath> excludePaths);

        /**
         * <p>
         * The paths to exclude.
         * </p>
         * 
         * @param excludePaths
         *        The paths to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePaths(AccessScopePath... excludePaths);

        /**
         * <p>
         * The paths to exclude.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessScopePath>.Builder} avoiding the need
         * to create one manually via {@link List<AccessScopePath>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessScopePath>.Builder#build()} is called immediately and
         * its result is passed to {@link #excludePaths(List<AccessScopePath>)}.
         * 
         * @param excludePaths
         *        a consumer that will call methods on {@link List<AccessScopePath>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludePaths(List<AccessScopePath>)
         */
        Builder excludePaths(Consumer<AccessScopePath.Builder>... excludePaths);
    }

    static final class BuilderImpl implements Builder {
        private String networkInsightsAccessScopeId;

        private List<AccessScopePath> matchPaths = DefaultSdkAutoConstructList.getInstance();

        private List<AccessScopePath> excludePaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAccessScopeContent model) {
            networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            matchPaths(model.matchPaths);
            excludePaths(model.excludePaths);
        }

        public final String getNetworkInsightsAccessScopeId() {
            return networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        @Transient
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final List<AccessScopePath.Builder> getMatchPaths() {
            List<AccessScopePath.Builder> result = AccessScopePathListCopier.copyToBuilder(this.matchPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchPaths(Collection<AccessScopePath.BuilderImpl> matchPaths) {
            this.matchPaths = AccessScopePathListCopier.copyFromBuilder(matchPaths);
        }

        @Override
        @Transient
        public final Builder matchPaths(Collection<AccessScopePath> matchPaths) {
            this.matchPaths = AccessScopePathListCopier.copy(matchPaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder matchPaths(AccessScopePath... matchPaths) {
            matchPaths(Arrays.asList(matchPaths));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder matchPaths(Consumer<AccessScopePath.Builder>... matchPaths) {
            matchPaths(Stream.of(matchPaths).map(c -> AccessScopePath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AccessScopePath.Builder> getExcludePaths() {
            List<AccessScopePath.Builder> result = AccessScopePathListCopier.copyToBuilder(this.excludePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludePaths(Collection<AccessScopePath.BuilderImpl> excludePaths) {
            this.excludePaths = AccessScopePathListCopier.copyFromBuilder(excludePaths);
        }

        @Override
        @Transient
        public final Builder excludePaths(Collection<AccessScopePath> excludePaths) {
            this.excludePaths = AccessScopePathListCopier.copy(excludePaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludePaths(AccessScopePath... excludePaths) {
            excludePaths(Arrays.asList(excludePaths));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludePaths(Consumer<AccessScopePath.Builder>... excludePaths) {
            excludePaths(Stream.of(excludePaths).map(c -> AccessScopePath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkInsightsAccessScopeContent build() {
            return new NetworkInsightsAccessScopeContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
