/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImagesResponse.Builder, DescribeImagesResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField
            .<List<Image>> builder(MarshallingType.LIST)
            .memberName("Images")
            .getter(getter(DescribeImagesResponse::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagesSet")
                    .unmarshallLocationName("imagesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Image> builder(MarshallingType.SDK_POJO)
                                            .constructor(Image::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD));

    private final List<Image> images;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
    }

    /**
     * Returns true if the Images property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the images.
     */
    public final List<Image> images() {
        return images;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse) obj;
        return hasImages() == other.hasImages() && Objects.equals(images(), other.images());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagesResponse").add("Images", hasImages() ? images() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesResponse, T> g) {
        return obj -> g.apply((DescribeImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagesResponse> {
        /**
         * <p>
         * Information about the images.
         * </p>
         * 
         * @param images
         *        Information about the images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<Image> images);

        /**
         * <p>
         * Information about the images.
         * </p>
         * 
         * @param images
         *        Information about the images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Image... images);

        /**
         * <p>
         * Information about the images.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Image>.Builder} avoiding the need to create
         * one manually via {@link List<Image>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Image>.Builder#build()} is called immediately and its result
         * is passed to {@link #images(List<Image>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<Image>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<Image>)
         */
        Builder images(Consumer<Image.Builder>... images);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            images(model.images);
        }

        public final List<Image.Builder> getImages() {
            List<Image.Builder> result = ImageListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        @Override
        @Transient
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder images(Image... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder>... images) {
            images(Stream.of(images).map(c -> Image.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
