/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcClassicLinkResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcClassicLinkResponse.Builder, DescribeVpcClassicLinkResponse> {
    private static final SdkField<List<VpcClassicLink>> VPCS_FIELD = SdkField
            .<List<VpcClassicLink>> builder(MarshallingType.LIST)
            .memberName("Vpcs")
            .getter(getter(DescribeVpcClassicLinkResponse::vpcs))
            .setter(setter(Builder::vpcs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSet")
                    .unmarshallLocationName("vpcSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcClassicLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcClassicLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCS_FIELD));

    private final List<VpcClassicLink> vpcs;

    private DescribeVpcClassicLinkResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
    }

    /**
     * Returns true if the Vpcs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVpcs() {
        return vpcs != null && !(vpcs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ClassicLink status of one or more VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ClassicLink status of one or more VPCs.
     */
    public final List<VpcClassicLink> vpcs() {
        return vpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcs() ? vpcs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkResponse)) {
            return false;
        }
        DescribeVpcClassicLinkResponse other = (DescribeVpcClassicLinkResponse) obj;
        return hasVpcs() == other.hasVpcs() && Objects.equals(vpcs(), other.vpcs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcClassicLinkResponse").add("Vpcs", hasVpcs() ? vpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpcs":
            return Optional.ofNullable(clazz.cast(vpcs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkResponse, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
        /**
         * <p>
         * The ClassicLink status of one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        The ClassicLink status of one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<VpcClassicLink> vpcs);

        /**
         * <p>
         * The ClassicLink status of one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        The ClassicLink status of one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(VpcClassicLink... vpcs);

        /**
         * <p>
         * The ClassicLink status of one or more VPCs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcClassicLink>.Builder} avoiding the need
         * to create one manually via {@link List<VpcClassicLink>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcClassicLink>.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcs(List<VpcClassicLink>)}.
         * 
         * @param vpcs
         *        a consumer that will call methods on {@link List<VpcClassicLink>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcs(List<VpcClassicLink>)
         */
        Builder vpcs(Consumer<VpcClassicLink.Builder>... vpcs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpcClassicLink> vpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkResponse model) {
            super(model);
            vpcs(model.vpcs);
        }

        public final List<VpcClassicLink.Builder> getVpcs() {
            List<VpcClassicLink.Builder> result = VpcClassicLinkListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<VpcClassicLink.BuilderImpl> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copyFromBuilder(vpcs);
        }

        @Override
        @Transient
        public final Builder vpcs(Collection<VpcClassicLink> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copy(vpcs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(VpcClassicLink... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(Consumer<VpcClassicLink.Builder>... vpcs) {
            vpcs(Stream.of(vpcs).map(c -> VpcClassicLink.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpcClassicLinkResponse build() {
            return new DescribeVpcClassicLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
