/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the DNS server to be used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsServersOptionsModifyStructure implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsServersOptionsModifyStructure.Builder, DnsServersOptionsModifyStructure> {
    private static final SdkField<List<String>> CUSTOM_DNS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomDnsServers")
            .getter(getter(DnsServersOptionsModifyStructure::customDnsServers))
            .setter(setter(Builder::customDnsServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDnsServers")
                    .unmarshallLocationName("CustomDnsServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(DnsServersOptionsModifyStructure::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DNS_SERVERS_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> customDnsServers;

    private final Boolean enabled;

    private DnsServersOptionsModifyStructure(BuilderImpl builder) {
        this.customDnsServers = builder.customDnsServers;
        this.enabled = builder.enabled;
    }

    /**
     * Returns true if the CustomDnsServers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCustomDnsServers() {
        return customDnsServers != null && !(customDnsServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS servers.
     * Ensure that the DNS servers can be reached by the clients. The specified values overwrite the existing values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomDnsServers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS
     *         servers. Ensure that the DNS servers can be reached by the clients. The specified values overwrite the
     *         existing values.
     */
    public final List<String> customDnsServers() {
        return customDnsServers;
    }

    /**
     * <p>
     * Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS servers.
     * </p>
     * 
     * @return Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS
     *         servers.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDnsServers() ? customDnsServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServersOptionsModifyStructure)) {
            return false;
        }
        DnsServersOptionsModifyStructure other = (DnsServersOptionsModifyStructure) obj;
        return hasCustomDnsServers() == other.hasCustomDnsServers()
                && Objects.equals(customDnsServers(), other.customDnsServers()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsServersOptionsModifyStructure")
                .add("CustomDnsServers", hasCustomDnsServers() ? customDnsServers() : null).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomDnsServers":
            return Optional.ofNullable(clazz.cast(customDnsServers()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsServersOptionsModifyStructure, T> g) {
        return obj -> g.apply((DnsServersOptionsModifyStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsServersOptionsModifyStructure> {
        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS
         * servers. Ensure that the DNS servers can be reached by the clients. The specified values overwrite the
         * existing values.
         * </p>
         * 
         * @param customDnsServers
         *        The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS
         *        servers. Ensure that the DNS servers can be reached by the clients. The specified values overwrite the
         *        existing values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDnsServers(Collection<String> customDnsServers);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS
         * servers. Ensure that the DNS servers can be reached by the clients. The specified values overwrite the
         * existing values.
         * </p>
         * 
         * @param customDnsServers
         *        The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to two DNS
         *        servers. Ensure that the DNS servers can be reached by the clients. The specified values overwrite the
         *        existing values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDnsServers(String... customDnsServers);

        /**
         * <p>
         * Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS servers.
         * </p>
         * 
         * @param enabled
         *        Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS
         *        servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private List<String> customDnsServers = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsServersOptionsModifyStructure model) {
            customDnsServers(model.customDnsServers);
            enabled(model.enabled);
        }

        public final Collection<String> getCustomDnsServers() {
            if (customDnsServers instanceof SdkAutoConstructList) {
                return null;
            }
            return customDnsServers;
        }

        public final void setCustomDnsServers(Collection<String> customDnsServers) {
            this.customDnsServers = ValueStringListCopier.copy(customDnsServers);
        }

        @Override
        @Transient
        public final Builder customDnsServers(Collection<String> customDnsServers) {
            this.customDnsServers = ValueStringListCopier.copy(customDnsServers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDnsServers(String... customDnsServers) {
            customDnsServers(Arrays.asList(customDnsServers));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public DnsServersOptionsModifyStructure build() {
            return new DnsServersOptionsModifyStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
