/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyNetworkInterfaceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyNetworkInterfaceAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyNetworkInterfaceAttributeRequest.Builder, ModifyNetworkInterfaceAttributeRequest> {
    private static final SdkField<NetworkInterfaceAttachmentChanges> ATTACHMENT_FIELD = SdkField
            .<NetworkInterfaceAttachmentChanges> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::attachment))
            .setter(setter(Builder::attachment))
            .constructor(NetworkInterfaceAttachmentChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Description")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("SourceDestCheck")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            DESCRIPTION_FIELD, GROUPS_FIELD, NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD));

    private final NetworkInterfaceAttachmentChanges attachment;

    private final AttributeValue description;

    private final List<String> groups;

    private final String networkInterfaceId;

    private final AttributeBooleanValue sourceDestCheck;

    private ModifyNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    /**
     * <p>
     * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify
     * the ID of the interface attachment.
     * </p>
     * 
     * @return Information about the interface attachment. If modifying the 'delete on termination' attribute, you must
     *         specify the ID of the interface attachment.
     */
    public final NetworkInterfaceAttachmentChanges attachment() {
        return attachment;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final AttributeValue description() {
        return description;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Changes the security groups for the network interface. The new set of groups you specify replaces the current
     * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
     * specify the ID of the security group, not the name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Changes the security groups for the network interface. The new set of groups you specify replaces the
     *         current set. You must specify at least one group, even if it's just the default security group in the
     *         VPC. You must specify the ID of the security group, not the name.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the
     * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
     * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     * source/destination checks if the instance runs services such as network address translation, routing, or
     * firewalls.
     * </p>
     * 
     * @return Enable or disable source/destination checks, which ensure that the instance is either the source or the
     *         destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks
     *         are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     *         source/destination checks if the instance runs services such as network address translation, routing, or
     *         firewalls.
     */
    public final AttributeBooleanValue sourceDestCheck() {
        return sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest) obj;
        return Objects.equals(attachment(), other.attachment()) && Objects.equals(description(), other.description())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyNetworkInterfaceAttributeRequest").add("Attachment", attachment())
                .add("Description", description()).add("Groups", hasGroups() ? groups() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("SourceDestCheck", sourceDestCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyNetworkInterfaceAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
        /**
         * <p>
         * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must
         * specify the ID of the interface attachment.
         * </p>
         * 
         * @param attachment
         *        Information about the interface attachment. If modifying the 'delete on termination' attribute, you
         *        must specify the ID of the interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachmentChanges attachment);

        /**
         * <p>
         * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must
         * specify the ID of the interface attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAttachmentChanges.Builder}
         * avoiding the need to create one manually via {@link NetworkInterfaceAttachmentChanges#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAttachmentChanges.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(NetworkInterfaceAttachmentChanges)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link NetworkInterfaceAttachmentChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(NetworkInterfaceAttachmentChanges)
         */
        default Builder attachment(Consumer<NetworkInterfaceAttachmentChanges.Builder> attachment) {
            return attachment(NetworkInterfaceAttachmentChanges.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current
         * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
         * specify the ID of the security group, not the name.
         * </p>
         * 
         * @param groups
         *        Changes the security groups for the network interface. The new set of groups you specify replaces the
         *        current set. You must specify at least one group, even if it's just the default security group in the
         *        VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current
         * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
         * specify the ID of the security group, not the name.
         * </p>
         * 
         * @param groups
         *        Changes the security groups for the network interface. The new set of groups you specify replaces the
         *        current set. You must specify at least one group, even if it's just the default security group in the
         *        VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * 
         * @param sourceDestCheck
         *        Enable or disable source/destination checks, which ensure that the instance is either the source or
         *        the destination of any traffic that it receives. If the value is <code>true</code>, source/destination
         *        checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must
         *        disable source/destination checks if the instance runs services such as network address translation,
         *        routing, or firewalls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding the need
         * to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDestCheck(AttributeBooleanValue)}.
         * 
         * @param sourceDestCheck
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDestCheck(AttributeBooleanValue)
         */
        default Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return sourceDestCheck(AttributeBooleanValue.builder().applyMutation(sourceDestCheck).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private NetworkInterfaceAttachmentChanges attachment;

        private AttributeValue description;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private AttributeBooleanValue sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyNetworkInterfaceAttributeRequest model) {
            super(model);
            attachment(model.attachment);
            description(model.description);
            groups(model.groups);
            networkInterfaceId(model.networkInterfaceId);
            sourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachmentChanges.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(NetworkInterfaceAttachmentChanges.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        @Transient
        public final Builder attachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
            return this;
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        @Transient
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return sourceDestCheck != null ? sourceDestCheck.toBuilder() : null;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyNetworkInterfaceAttributeRequest build() {
            return new ModifyNetworkInterfaceAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
