/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySecurityGroupRulesRequest extends Ec2Request implements
        ToCopyableBuilder<ModifySecurityGroupRulesRequest.Builder, ModifySecurityGroupRulesRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(ModifySecurityGroupRulesRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build()).build();

    private static final SdkField<List<SecurityGroupRuleUpdate>> SECURITY_GROUP_RULES_FIELD = SdkField
            .<List<SecurityGroupRuleUpdate>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRules")
            .getter(getter(ModifySecurityGroupRulesRequest::securityGroupRules))
            .setter(setter(Builder::securityGroupRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule")
                    .unmarshallLocationName("SecurityGroupRule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupRuleUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupRuleUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            SECURITY_GROUP_RULES_FIELD));

    private final String groupId;

    private final List<SecurityGroupRuleUpdate> securityGroupRules;

    private ModifySecurityGroupRulesRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.securityGroupRules = builder.securityGroupRules;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * Returns true if the SecurityGroupRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupRules() {
        return securityGroupRules != null && !(securityGroupRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the security group properties to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the security group properties to update.
     */
    public final List<SecurityGroupRuleUpdate> securityGroupRules() {
        return securityGroupRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRules() ? securityGroupRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySecurityGroupRulesRequest)) {
            return false;
        }
        ModifySecurityGroupRulesRequest other = (ModifySecurityGroupRulesRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && hasSecurityGroupRules() == other.hasSecurityGroupRules()
                && Objects.equals(securityGroupRules(), other.securityGroupRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySecurityGroupRulesRequest").add("GroupId", groupId())
                .add("SecurityGroupRules", hasSecurityGroupRules() ? securityGroupRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "SecurityGroupRules":
            return Optional.ofNullable(clazz.cast(securityGroupRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySecurityGroupRulesRequest, T> g) {
        return obj -> g.apply((ModifySecurityGroupRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifySecurityGroupRulesRequest> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Information about the security group properties to update.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about the security group properties to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(Collection<SecurityGroupRuleUpdate> securityGroupRules);

        /**
         * <p>
         * Information about the security group properties to update.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about the security group properties to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(SecurityGroupRuleUpdate... securityGroupRules);

        /**
         * <p>
         * Information about the security group properties to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroupRuleUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<SecurityGroupRuleUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroupRuleUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityGroupRules(List<SecurityGroupRuleUpdate>)}.
         * 
         * @param securityGroupRules
         *        a consumer that will call methods on {@link List<SecurityGroupRuleUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRules(List<SecurityGroupRuleUpdate>)
         */
        Builder securityGroupRules(Consumer<SecurityGroupRuleUpdate.Builder>... securityGroupRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupId;

        private List<SecurityGroupRuleUpdate> securityGroupRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySecurityGroupRulesRequest model) {
            super(model);
            groupId(model.groupId);
            securityGroupRules(model.securityGroupRules);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<SecurityGroupRuleUpdate.Builder> getSecurityGroupRules() {
            List<SecurityGroupRuleUpdate.Builder> result = SecurityGroupRuleUpdateListCopier
                    .copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRuleUpdate.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleUpdateListCopier.copyFromBuilder(securityGroupRules);
        }

        @Override
        @Transient
        public final Builder securityGroupRules(Collection<SecurityGroupRuleUpdate> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleUpdateListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRuleUpdate... securityGroupRules) {
            securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRuleUpdate.Builder>... securityGroupRules) {
            securityGroupRules(Stream.of(securityGroupRules).map(c -> SecurityGroupRuleUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySecurityGroupRulesRequest build() {
            return new ModifySecurityGroupRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
