/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for creating and managing pre-provisioned snapshots for a fast-launch enabled Windows AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FastLaunchSnapshotConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FastLaunchSnapshotConfigurationRequest.Builder, FastLaunchSnapshotConfigurationRequest> {
    private static final SdkField<Integer> TARGET_RESOURCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetResourceCount")
            .getter(getter(FastLaunchSnapshotConfigurationRequest::targetResourceCount))
            .setter(setter(Builder::targetResourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResourceCount")
                    .unmarshallLocationName("TargetResourceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer targetResourceCount;

    private FastLaunchSnapshotConfigurationRequest(BuilderImpl builder) {
        this.targetResourceCount = builder.targetResourceCount;
    }

    /**
     * <p>
     * The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
     * </p>
     * 
     * @return The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
     */
    public final Integer targetResourceCount() {
        return targetResourceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastLaunchSnapshotConfigurationRequest)) {
            return false;
        }
        FastLaunchSnapshotConfigurationRequest other = (FastLaunchSnapshotConfigurationRequest) obj;
        return Objects.equals(targetResourceCount(), other.targetResourceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FastLaunchSnapshotConfigurationRequest").add("TargetResourceCount", targetResourceCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetResourceCount":
            return Optional.ofNullable(clazz.cast(targetResourceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FastLaunchSnapshotConfigurationRequest, T> g) {
        return obj -> g.apply((FastLaunchSnapshotConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FastLaunchSnapshotConfigurationRequest> {
        /**
         * <p>
         * The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
         * </p>
         * 
         * @param targetResourceCount
         *        The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceCount(Integer targetResourceCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetResourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FastLaunchSnapshotConfigurationRequest model) {
            targetResourceCount(model.targetResourceCount);
        }

        public final Integer getTargetResourceCount() {
            return targetResourceCount;
        }

        public final void setTargetResourceCount(Integer targetResourceCount) {
            this.targetResourceCount = targetResourceCount;
        }

        @Override
        @Transient
        public final Builder targetResourceCount(Integer targetResourceCount) {
            this.targetResourceCount = targetResourceCount;
            return this;
        }

        @Override
        public FastLaunchSnapshotConfigurationRequest build() {
            return new FastLaunchSnapshotConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
