/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnect;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayConnectsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayConnectsResponse> {
    private static final SdkField<List<TransitGatewayConnect>> TRANSIT_GATEWAY_CONNECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayConnects").getter(DescribeTransitGatewayConnectsResponse.getter(DescribeTransitGatewayConnectsResponse::transitGatewayConnects)).setter(DescribeTransitGatewayConnectsResponse.setter(Builder::transitGatewayConnects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectSet").unmarshallLocationName("transitGatewayConnectSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayConnect::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayConnectsResponse.getter(DescribeTransitGatewayConnectsResponse::nextToken)).setter(DescribeTransitGatewayConnectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_CONNECTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayConnect> transitGatewayConnects;
    private final String nextToken;

    private DescribeTransitGatewayConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnects = builder.transitGatewayConnects;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayConnects() {
        return this.transitGatewayConnects != null && !(this.transitGatewayConnects instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayConnect> transitGatewayConnects() {
        return this.transitGatewayConnects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayConnects() ? this.transitGatewayConnects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayConnectsResponse)) {
            return false;
        }
        DescribeTransitGatewayConnectsResponse other = (DescribeTransitGatewayConnectsResponse)((Object)obj);
        return this.hasTransitGatewayConnects() == other.hasTransitGatewayConnects() && Objects.equals(this.transitGatewayConnects(), other.transitGatewayConnects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayConnectsResponse").add("TransitGatewayConnects", this.hasTransitGatewayConnects() ? this.transitGatewayConnects() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayConnects": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnects()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayConnectsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayConnectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayConnect> transitGatewayConnects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayConnectsResponse model) {
            super(model);
            this.transitGatewayConnects(model.transitGatewayConnects);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayConnect.Builder> getTransitGatewayConnects() {
            List<TransitGatewayConnect.Builder> result = TransitGatewayConnectListCopier.copyToBuilder(this.transitGatewayConnects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayConnects(Collection<TransitGatewayConnect.BuilderImpl> transitGatewayConnects) {
            this.transitGatewayConnects = TransitGatewayConnectListCopier.copyFromBuilder(transitGatewayConnects);
        }

        @Override
        @Transient
        public final Builder transitGatewayConnects(Collection<TransitGatewayConnect> transitGatewayConnects) {
            this.transitGatewayConnects = TransitGatewayConnectListCopier.copy(transitGatewayConnects);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayConnects(TransitGatewayConnect ... transitGatewayConnects) {
            this.transitGatewayConnects(Arrays.asList(transitGatewayConnects));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayConnects(Consumer<TransitGatewayConnect.Builder> ... transitGatewayConnects) {
            this.transitGatewayConnects(Stream.of(transitGatewayConnects).map(c -> (TransitGatewayConnect)((TransitGatewayConnect.Builder)TransitGatewayConnect.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayConnectsResponse build() {
            return new DescribeTransitGatewayConnectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayConnectsResponse> {
        public Builder transitGatewayConnects(Collection<TransitGatewayConnect> var1);

        public Builder transitGatewayConnects(TransitGatewayConnect ... var1);

        public Builder transitGatewayConnects(Consumer<TransitGatewayConnect.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

