/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes integration options for Amazon Athena.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AthenaIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<AthenaIntegration.Builder, AthenaIntegration> {
    private static final SdkField<String> INTEGRATION_RESULT_S3_DESTINATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IntegrationResultS3DestinationArn")
            .getter(getter(AthenaIntegration::integrationResultS3DestinationArn))
            .setter(setter(Builder::integrationResultS3DestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationResultS3DestinationArn")
                    .unmarshallLocationName("IntegrationResultS3DestinationArn").build()).build();

    private static final SdkField<String> PARTITION_LOAD_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartitionLoadFrequency")
            .getter(getter(AthenaIntegration::partitionLoadFrequencyAsString))
            .setter(setter(Builder::partitionLoadFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionLoadFrequency")
                    .unmarshallLocationName("PartitionLoadFrequency").build()).build();

    private static final SdkField<Instant> PARTITION_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PartitionStartDate")
            .getter(getter(AthenaIntegration::partitionStartDate))
            .setter(setter(Builder::partitionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionStartDate")
                    .unmarshallLocationName("PartitionStartDate").build()).build();

    private static final SdkField<Instant> PARTITION_END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PartitionEndDate")
            .getter(getter(AthenaIntegration::partitionEndDate))
            .setter(setter(Builder::partitionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionEndDate")
                    .unmarshallLocationName("PartitionEndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGRATION_RESULT_S3_DESTINATION_ARN_FIELD, PARTITION_LOAD_FREQUENCY_FIELD, PARTITION_START_DATE_FIELD,
            PARTITION_END_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String integrationResultS3DestinationArn;

    private final String partitionLoadFrequency;

    private final Instant partitionStartDate;

    private final Instant partitionEndDate;

    private AthenaIntegration(BuilderImpl builder) {
        this.integrationResultS3DestinationArn = builder.integrationResultS3DestinationArn;
        this.partitionLoadFrequency = builder.partitionLoadFrequency;
        this.partitionStartDate = builder.partitionStartDate;
        this.partitionEndDate = builder.partitionEndDate;
    }

    /**
     * <p>
     * The location in Amazon S3 to store the generated CloudFormation template.
     * </p>
     * 
     * @return The location in Amazon S3 to store the generated CloudFormation template.
     */
    public final String integrationResultS3DestinationArn() {
        return integrationResultS3DestinationArn;
    }

    /**
     * <p>
     * The schedule for adding new partitions to the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partitionLoadFrequency} will return {@link PartitionLoadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #partitionLoadFrequencyAsString}.
     * </p>
     * 
     * @return The schedule for adding new partitions to the table.
     * @see PartitionLoadFrequency
     */
    public final PartitionLoadFrequency partitionLoadFrequency() {
        return PartitionLoadFrequency.fromValue(partitionLoadFrequency);
    }

    /**
     * <p>
     * The schedule for adding new partitions to the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partitionLoadFrequency} will return {@link PartitionLoadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #partitionLoadFrequencyAsString}.
     * </p>
     * 
     * @return The schedule for adding new partitions to the table.
     * @see PartitionLoadFrequency
     */
    public final String partitionLoadFrequencyAsString() {
        return partitionLoadFrequency;
    }

    /**
     * <p>
     * The start date for the partition.
     * </p>
     * 
     * @return The start date for the partition.
     */
    public final Instant partitionStartDate() {
        return partitionStartDate;
    }

    /**
     * <p>
     * The end date for the partition.
     * </p>
     * 
     * @return The end date for the partition.
     */
    public final Instant partitionEndDate() {
        return partitionEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integrationResultS3DestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(partitionLoadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partitionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(partitionEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaIntegration)) {
            return false;
        }
        AthenaIntegration other = (AthenaIntegration) obj;
        return Objects.equals(integrationResultS3DestinationArn(), other.integrationResultS3DestinationArn())
                && Objects.equals(partitionLoadFrequencyAsString(), other.partitionLoadFrequencyAsString())
                && Objects.equals(partitionStartDate(), other.partitionStartDate())
                && Objects.equals(partitionEndDate(), other.partitionEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AthenaIntegration")
                .add("IntegrationResultS3DestinationArn", integrationResultS3DestinationArn())
                .add("PartitionLoadFrequency", partitionLoadFrequencyAsString()).add("PartitionStartDate", partitionStartDate())
                .add("PartitionEndDate", partitionEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationResultS3DestinationArn":
            return Optional.ofNullable(clazz.cast(integrationResultS3DestinationArn()));
        case "PartitionLoadFrequency":
            return Optional.ofNullable(clazz.cast(partitionLoadFrequencyAsString()));
        case "PartitionStartDate":
            return Optional.ofNullable(clazz.cast(partitionStartDate()));
        case "PartitionEndDate":
            return Optional.ofNullable(clazz.cast(partitionEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AthenaIntegration, T> g) {
        return obj -> g.apply((AthenaIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AthenaIntegration> {
        /**
         * <p>
         * The location in Amazon S3 to store the generated CloudFormation template.
         * </p>
         * 
         * @param integrationResultS3DestinationArn
         *        The location in Amazon S3 to store the generated CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationResultS3DestinationArn(String integrationResultS3DestinationArn);

        /**
         * <p>
         * The schedule for adding new partitions to the table.
         * </p>
         * 
         * @param partitionLoadFrequency
         *        The schedule for adding new partitions to the table.
         * @see PartitionLoadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionLoadFrequency
         */
        Builder partitionLoadFrequency(String partitionLoadFrequency);

        /**
         * <p>
         * The schedule for adding new partitions to the table.
         * </p>
         * 
         * @param partitionLoadFrequency
         *        The schedule for adding new partitions to the table.
         * @see PartitionLoadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionLoadFrequency
         */
        Builder partitionLoadFrequency(PartitionLoadFrequency partitionLoadFrequency);

        /**
         * <p>
         * The start date for the partition.
         * </p>
         * 
         * @param partitionStartDate
         *        The start date for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionStartDate(Instant partitionStartDate);

        /**
         * <p>
         * The end date for the partition.
         * </p>
         * 
         * @param partitionEndDate
         *        The end date for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionEndDate(Instant partitionEndDate);
    }

    static final class BuilderImpl implements Builder {
        private String integrationResultS3DestinationArn;

        private String partitionLoadFrequency;

        private Instant partitionStartDate;

        private Instant partitionEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaIntegration model) {
            integrationResultS3DestinationArn(model.integrationResultS3DestinationArn);
            partitionLoadFrequency(model.partitionLoadFrequency);
            partitionStartDate(model.partitionStartDate);
            partitionEndDate(model.partitionEndDate);
        }

        public final String getIntegrationResultS3DestinationArn() {
            return integrationResultS3DestinationArn;
        }

        public final void setIntegrationResultS3DestinationArn(String integrationResultS3DestinationArn) {
            this.integrationResultS3DestinationArn = integrationResultS3DestinationArn;
        }

        @Override
        @Transient
        public final Builder integrationResultS3DestinationArn(String integrationResultS3DestinationArn) {
            this.integrationResultS3DestinationArn = integrationResultS3DestinationArn;
            return this;
        }

        public final String getPartitionLoadFrequency() {
            return partitionLoadFrequency;
        }

        public final void setPartitionLoadFrequency(String partitionLoadFrequency) {
            this.partitionLoadFrequency = partitionLoadFrequency;
        }

        @Override
        @Transient
        public final Builder partitionLoadFrequency(String partitionLoadFrequency) {
            this.partitionLoadFrequency = partitionLoadFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder partitionLoadFrequency(PartitionLoadFrequency partitionLoadFrequency) {
            this.partitionLoadFrequency(partitionLoadFrequency == null ? null : partitionLoadFrequency.toString());
            return this;
        }

        public final Instant getPartitionStartDate() {
            return partitionStartDate;
        }

        public final void setPartitionStartDate(Instant partitionStartDate) {
            this.partitionStartDate = partitionStartDate;
        }

        @Override
        @Transient
        public final Builder partitionStartDate(Instant partitionStartDate) {
            this.partitionStartDate = partitionStartDate;
            return this;
        }

        public final Instant getPartitionEndDate() {
            return partitionEndDate;
        }

        public final void setPartitionEndDate(Instant partitionEndDate) {
            this.partitionEndDate = partitionEndDate;
        }

        @Override
        @Transient
        public final Builder partitionEndDate(Instant partitionEndDate) {
            this.partitionEndDate = partitionEndDate;
            return this;
        }

        @Override
        public AthenaIntegration build() {
            return new AthenaIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
