/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeClientVpnIngressRequest extends Ec2Request implements
        ToCopyableBuilder<AuthorizeClientVpnIngressRequest.Builder, AuthorizeClientVpnIngressRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(AuthorizeClientVpnIngressRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> TARGET_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetNetworkCidr")
            .getter(getter(AuthorizeClientVpnIngressRequest::targetNetworkCidr))
            .setter(setter(Builder::targetNetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNetworkCidr")
                    .unmarshallLocationName("TargetNetworkCidr").build()).build();

    private static final SdkField<String> ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGroupId")
            .getter(getter(AuthorizeClientVpnIngressRequest::accessGroupId))
            .setter(setter(Builder::accessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGroupId")
                    .unmarshallLocationName("AccessGroupId").build()).build();

    private static final SdkField<Boolean> AUTHORIZE_ALL_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuthorizeAllGroups")
            .getter(getter(AuthorizeClientVpnIngressRequest::authorizeAllGroups))
            .setter(setter(Builder::authorizeAllGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizeAllGroups")
                    .unmarshallLocationName("AuthorizeAllGroups").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(AuthorizeClientVpnIngressRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AuthorizeClientVpnIngressRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            TARGET_NETWORK_CIDR_FIELD, ACCESS_GROUP_ID_FIELD, AUTHORIZE_ALL_GROUPS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String clientVpnEndpointId;

    private final String targetNetworkCidr;

    private final String accessGroupId;

    private final Boolean authorizeAllGroups;

    private final String description;

    private final String clientToken;

    private AuthorizeClientVpnIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetNetworkCidr = builder.targetNetworkCidr;
        this.accessGroupId = builder.accessGroupId;
        this.authorizeAllGroups = builder.authorizeAllGroups;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     */
    public final String targetNetworkCidr() {
        return targetNetworkCidr;
    }

    /**
     * <p>
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
     * Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
     * </p>
     * 
     * @return The ID of the group to grant access to, for example, the Active Directory group or identity provider
     *         (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
     */
    public final String accessGroupId() {
        return accessGroupId;
    }

    /**
     * <p>
     * Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully
     * establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code>
     * is not specified.
     * </p>
     * 
     * @return Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who
     *         successfully establish a VPN connection access to the network. Must be set to <code>true</code> if
     *         <code>AccessGroupId</code> is not specified.
     */
    public final Boolean authorizeAllGroups() {
        return authorizeAllGroups;
    }

    /**
     * <p>
     * A brief description of the authorization rule.
     * </p>
     * 
     * @return A brief description of the authorization rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(targetNetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(accessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizeAllGroups());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeClientVpnIngressRequest)) {
            return false;
        }
        AuthorizeClientVpnIngressRequest other = (AuthorizeClientVpnIngressRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(targetNetworkCidr(), other.targetNetworkCidr())
                && Objects.equals(accessGroupId(), other.accessGroupId())
                && Objects.equals(authorizeAllGroups(), other.authorizeAllGroups())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeClientVpnIngressRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("TargetNetworkCidr", targetNetworkCidr()).add("AccessGroupId", accessGroupId())
                .add("AuthorizeAllGroups", authorizeAllGroups()).add("Description", description())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "TargetNetworkCidr":
            return Optional.ofNullable(clazz.cast(targetNetworkCidr()));
        case "AccessGroupId":
            return Optional.ofNullable(clazz.cast(accessGroupId()));
        case "AuthorizeAllGroups":
            return Optional.ofNullable(clazz.cast(authorizeAllGroups()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeClientVpnIngressRequest, T> g) {
        return obj -> g.apply((AuthorizeClientVpnIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AuthorizeClientVpnIngressRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
         * </p>
         * 
         * @param targetNetworkCidr
         *        The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNetworkCidr(String targetNetworkCidr);

        /**
         * <p>
         * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP)
         * group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
         * </p>
         * 
         * @param accessGroupId
         *        The ID of the group to grant access to, for example, the Active Directory group or identity provider
         *        (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGroupId(String accessGroupId);

        /**
         * <p>
         * Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who
         * successfully establish a VPN connection access to the network. Must be set to <code>true</code> if
         * <code>AccessGroupId</code> is not specified.
         * </p>
         * 
         * @param authorizeAllGroups
         *        Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who
         *        successfully establish a VPN connection access to the network. Must be set to <code>true</code> if
         *        <code>AccessGroupId</code> is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizeAllGroups(Boolean authorizeAllGroups);

        /**
         * <p>
         * A brief description of the authorization rule.
         * </p>
         * 
         * @param description
         *        A brief description of the authorization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        ensure idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String targetNetworkCidr;

        private String accessGroupId;

        private Boolean authorizeAllGroups;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeClientVpnIngressRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            targetNetworkCidr(model.targetNetworkCidr);
            accessGroupId(model.accessGroupId);
            authorizeAllGroups(model.authorizeAllGroups);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        @Transient
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getTargetNetworkCidr() {
            return targetNetworkCidr;
        }

        public final void setTargetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
        }

        @Override
        @Transient
        public final Builder targetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
            return this;
        }

        public final String getAccessGroupId() {
            return accessGroupId;
        }

        public final void setAccessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
        }

        @Override
        @Transient
        public final Builder accessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
            return this;
        }

        public final Boolean getAuthorizeAllGroups() {
            return authorizeAllGroups;
        }

        public final void setAuthorizeAllGroups(Boolean authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
        }

        @Override
        @Transient
        public final Builder authorizeAllGroups(Boolean authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeClientVpnIngressRequest build() {
            return new AuthorizeClientVpnIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
