/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeSecurityGroupIngressResponse extends Ec2Response implements
        ToCopyableBuilder<AuthorizeSecurityGroupIngressResponse.Builder, AuthorizeSecurityGroupIngressResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Return")
            .getter(getter(AuthorizeSecurityGroupIngressResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return")
                    .unmarshallLocationName("return").build()).build();

    private static final SdkField<List<SecurityGroupRule>> SECURITY_GROUP_RULES_FIELD = SdkField
            .<List<SecurityGroupRule>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRules")
            .getter(getter(AuthorizeSecurityGroupIngressResponse::securityGroupRules))
            .setter(setter(Builder::securityGroupRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleSet")
                    .unmarshallLocationName("securityGroupRuleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD,
            SECURITY_GROUP_RULES_FIELD));

    private final Boolean returnValue;

    private final List<SecurityGroupRule> securityGroupRules;

    private AuthorizeSecurityGroupIngressResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.securityGroupRules = builder.securityGroupRules;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, returns an error.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    /**
     * Returns true if the SecurityGroupRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupRules() {
        return securityGroupRules != null && !(securityGroupRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the inbound (ingress) security group rules that were added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the inbound (ingress) security group rules that were added.
     */
    public final List<SecurityGroupRule> securityGroupRules() {
        return securityGroupRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRules() ? securityGroupRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressResponse)) {
            return false;
        }
        AuthorizeSecurityGroupIngressResponse other = (AuthorizeSecurityGroupIngressResponse) obj;
        return Objects.equals(returnValue(), other.returnValue()) && hasSecurityGroupRules() == other.hasSecurityGroupRules()
                && Objects.equals(securityGroupRules(), other.securityGroupRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeSecurityGroupIngressResponse").add("Return", returnValue())
                .add("SecurityGroupRules", hasSecurityGroupRules() ? securityGroupRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Return":
            return Optional.ofNullable(clazz.cast(returnValue()));
        case "SecurityGroupRules":
            return Optional.ofNullable(clazz.cast(securityGroupRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSecurityGroupIngressResponse, T> g) {
        return obj -> g.apply((AuthorizeSecurityGroupIngressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AuthorizeSecurityGroupIngressResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);

        /**
         * <p>
         * Information about the inbound (ingress) security group rules that were added.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about the inbound (ingress) security group rules that were added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules);

        /**
         * <p>
         * Information about the inbound (ingress) security group rules that were added.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about the inbound (ingress) security group rules that were added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(SecurityGroupRule... securityGroupRules);

        /**
         * <p>
         * Information about the inbound (ingress) security group rules that were added.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroupRule>.Builder} avoiding the
         * need to create one manually via {@link List<SecurityGroupRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroupRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRules(List<SecurityGroupRule>)}.
         * 
         * @param securityGroupRules
         *        a consumer that will call methods on {@link List<SecurityGroupRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRules(List<SecurityGroupRule>)
         */
        Builder securityGroupRules(Consumer<SecurityGroupRule.Builder>... securityGroupRules);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean returnValue;

        private List<SecurityGroupRule> securityGroupRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupIngressResponse model) {
            super(model);
            returnValue(model.returnValue);
            securityGroupRules(model.securityGroupRules);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        @Transient
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<SecurityGroupRule.Builder> getSecurityGroupRules() {
            List<SecurityGroupRule.Builder> result = SecurityGroupRuleListCopier.copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRule.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copyFromBuilder(securityGroupRules);
        }

        @Override
        @Transient
        public final Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRule... securityGroupRules) {
            securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRule.Builder>... securityGroupRules) {
            securityGroupRules(Stream.of(securityGroupRules).map(c -> SecurityGroupRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AuthorizeSecurityGroupIngressResponse build() {
            return new AuthorizeSecurityGroupIngressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
