/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotPriceHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotPriceHistoryResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSpotPriceHistoryResponse.Builder, DescribeSpotPriceHistoryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSpotPriceHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<SpotPrice>> SPOT_PRICE_HISTORY_FIELD = SdkField
            .<List<SpotPrice>> builder(MarshallingType.LIST)
            .memberName("SpotPriceHistory")
            .getter(getter(DescribeSpotPriceHistoryResponse::spotPriceHistory))
            .setter(setter(Builder::spotPriceHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPriceHistorySet")
                    .unmarshallLocationName("spotPriceHistorySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotPrice> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotPrice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SPOT_PRICE_HISTORY_FIELD));

    private final String nextToken;

    private final List<SpotPrice> spotPriceHistory;

    private DescribeSpotPriceHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spotPriceHistory = builder.spotPriceHistory;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null or an empty string when there are no
     * more results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null or an empty string when there
     *         are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the SpotPriceHistory property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSpotPriceHistory() {
        return spotPriceHistory != null && !(spotPriceHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The historical Spot prices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpotPriceHistory()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The historical Spot prices.
     */
    public final List<SpotPrice> spotPriceHistory() {
        return spotPriceHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpotPriceHistory() ? spotPriceHistory() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryResponse)) {
            return false;
        }
        DescribeSpotPriceHistoryResponse other = (DescribeSpotPriceHistoryResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSpotPriceHistory() == other.hasSpotPriceHistory()
                && Objects.equals(spotPriceHistory(), other.spotPriceHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSpotPriceHistoryResponse").add("NextToken", nextToken())
                .add("SpotPriceHistory", hasSpotPriceHistory() ? spotPriceHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SpotPriceHistory":
            return Optional.ofNullable(clazz.cast(spotPriceHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotPriceHistoryResponse, T> g) {
        return obj -> g.apply((DescribeSpotPriceHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotPriceHistoryResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null or an empty string when there are
         * no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null or an empty string when
         *        there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The historical Spot prices.
         * </p>
         * 
         * @param spotPriceHistory
         *        The historical Spot prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPriceHistory(Collection<SpotPrice> spotPriceHistory);

        /**
         * <p>
         * The historical Spot prices.
         * </p>
         * 
         * @param spotPriceHistory
         *        The historical Spot prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPriceHistory(SpotPrice... spotPriceHistory);

        /**
         * <p>
         * The historical Spot prices.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SpotPrice>.Builder} avoiding the need to
         * create one manually via {@link List<SpotPrice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SpotPrice>.Builder#build()} is called immediately and its
         * result is passed to {@link #spotPriceHistory(List<SpotPrice>)}.
         * 
         * @param spotPriceHistory
         *        a consumer that will call methods on {@link List<SpotPrice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotPriceHistory(List<SpotPrice>)
         */
        Builder spotPriceHistory(Consumer<SpotPrice.Builder>... spotPriceHistory);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SpotPrice> spotPriceHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryResponse model) {
            super(model);
            nextToken(model.nextToken);
            spotPriceHistory(model.spotPriceHistory);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SpotPrice.Builder> getSpotPriceHistory() {
            List<SpotPrice.Builder> result = SpotPriceHistoryListCopier.copyToBuilder(this.spotPriceHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpotPriceHistory(Collection<SpotPrice.BuilderImpl> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copyFromBuilder(spotPriceHistory);
        }

        @Override
        @Transient
        public final Builder spotPriceHistory(Collection<SpotPrice> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copy(spotPriceHistory);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder spotPriceHistory(SpotPrice... spotPriceHistory) {
            spotPriceHistory(Arrays.asList(spotPriceHistory));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder spotPriceHistory(Consumer<SpotPrice.Builder>... spotPriceHistory) {
            spotPriceHistory(Stream.of(spotPriceHistory).map(c -> SpotPrice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSpotPriceHistoryResponse build() {
            return new DescribeSpotPriceHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
