/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConsoleScreenshotRequest extends Ec2Request implements
        ToCopyableBuilder<GetConsoleScreenshotRequest.Builder, GetConsoleScreenshotRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(GetConsoleScreenshotRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<Boolean> WAKE_UP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WakeUp")
            .getter(getter(GetConsoleScreenshotRequest::wakeUp))
            .setter(setter(Builder::wakeUp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeUp")
                    .unmarshallLocationName("WakeUp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            WAKE_UP_FIELD));

    private final String instanceId;

    private final Boolean wakeUp;

    private GetConsoleScreenshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.wakeUp = builder.wakeUp;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or "sleep"
     * mode.
     * </p>
     * 
     * @return When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or
     *         "sleep" mode.
     */
    public final Boolean wakeUp() {
        return wakeUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(wakeUp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotRequest)) {
            return false;
        }
        GetConsoleScreenshotRequest other = (GetConsoleScreenshotRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(wakeUp(), other.wakeUp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConsoleScreenshotRequest").add("InstanceId", instanceId()).add("WakeUp", wakeUp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "WakeUp":
            return Optional.ofNullable(clazz.cast(wakeUp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsoleScreenshotRequest, T> g) {
        return obj -> g.apply((GetConsoleScreenshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetConsoleScreenshotRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or "sleep"
         * mode.
         * </p>
         * 
         * @param wakeUp
         *        When set to <code>true</code>, acts as keystroke input and wakes up an instance that's in standby or
         *        "sleep" mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wakeUp(Boolean wakeUp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private Boolean wakeUp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotRequest model) {
            super(model);
            instanceId(model.instanceId);
            wakeUp(model.wakeUp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Boolean getWakeUp() {
            return wakeUp;
        }

        public final void setWakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
        }

        @Override
        @Transient
        public final Builder wakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConsoleScreenshotRequest build() {
            return new GetConsoleScreenshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
