/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateInstanceNetworkInterfaceSpecification
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder, LaunchTemplateInstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociateCarrierIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::associateCarrierIpAddress))
            .setter(setter(Builder::associateCarrierIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress")
                    .unmarshallLocationName("associateCarrierIpAddress").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociatePublicIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress")
                    .unmarshallLocationName("associatePublicIpAddress").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex")
                    .unmarshallLocationName("deviceIndex").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("groupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GroupId").unmarshallLocationName("groupId").build()).build())
                            .build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::interfaceType))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("interfaceType").build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet")
                    .unmarshallLocationName("ipv6AddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressSpecification>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet")
                    .unmarshallLocationName("privateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("secondaryPrivateIpAddressCount").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("networkCardIndex").build()).build();

    private static final SdkField<List<Ipv4PrefixSpecificationResponse>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecificationResponse>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixSet")
                    .unmarshallLocationName("ipv4PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecificationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecificationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount")
                    .unmarshallLocationName("ipv4PrefixCount").build()).build();

    private static final SdkField<List<Ipv6PrefixSpecificationResponse>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecificationResponse>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixSet")
                    .unmarshallLocationName("ipv6PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecificationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecificationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount")
                    .unmarshallLocationName("ipv6PrefixCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD,
            DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD, IPV6_ADDRESS_COUNT_FIELD,
            IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD, NETWORK_CARD_INDEX_FIELD, IPV4_PREFIXES_FIELD,
            IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean associateCarrierIpAddress;

    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final String interfaceType;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private final Integer networkCardIndex;

    private final List<Ipv4PrefixSpecificationResponse> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final List<Ipv6PrefixSpecificationResponse> ipv6Prefixes;

    private final Integer ipv6PrefixCount;

    private LaunchTemplateInstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.networkCardIndex = builder.networkCardIndex;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
    }

    /**
     * <p>
     * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
     * </p>
     * <p>
     * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with
     * the network interface. For more information about Carrier IP addresses, see <a
     * href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     * >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
     * </p>
     * 
     * @return Indicates whether to associate a Carrier IP address with eth0 for a new network interface.</p>
     *         <p>
     *         Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP
     *         address with the network interface. For more information about Carrier IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     *         >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
     */
    public final Boolean associateCarrierIpAddress() {
        return associateCarrierIpAddress;
    }

    /**
     * <p>
     * Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
     * </p>
     * 
     * @return Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The device index for the network interface attachment.
     * </p>
     * 
     * @return The device index for the network interface attachment.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * 
     * @return The type of network interface.
     */
    public final String interfaceType() {
        return interfaceType;
    }

    /**
     * <p>
     * The number of IPv6 addresses for the network interface.
     * </p>
     * 
     * @return The number of IPv6 addresses for the network interface.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * Returns true if the Ipv6Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses for the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 addresses for the network interface.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return The primary private IPv4 address of the network interface.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the PrivateIpAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more private IPv4 addresses.
     */
    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses for the network interface.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses for the network interface.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet for the network interface.
     * </p>
     * 
     * @return The ID of the subnet for the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The index of the network card.
     * </p>
     * 
     * @return The index of the network card.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * Returns true if the Ipv4Prefixes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv4 delegated prefixes assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv4Prefixes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IPv4 delegated prefixes assigned to the network interface.
     */
    public final List<Ipv4PrefixSpecificationResponse> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv4 delegated prefixes that AWS automatically assigned to the network interface.
     * </p>
     * 
     * @return The number of IPv4 delegated prefixes that AWS automatically assigned to the network interface.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * Returns true if the Ipv6Prefixes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 delegated prefixes assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Prefixes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IPv6 delegated prefixes assigned to the network interface.
     */
    public final List<Ipv6PrefixSpecificationResponse> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The number of IPv6 delegated prefixes that AWS automatically assigned to the network interface.
     * </p>
     * 
     * @return The number of IPv6 delegated prefixes that AWS automatically assigned to the network interface.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceNetworkInterfaceSpecification)) {
            return false;
        }
        LaunchTemplateInstanceNetworkInterfaceSpecification other = (LaunchTemplateInstanceNetworkInterfaceSpecification) obj;
        return Objects.equals(associateCarrierIpAddress(), other.associateCarrierIpAddress())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(interfaceType(), other.interfaceType())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(networkCardIndex(), other.networkCardIndex())
                && hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateInstanceNetworkInterfaceSpecification")
                .add("AssociateCarrierIpAddress", associateCarrierIpAddress())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("DeleteOnTermination", deleteOnTermination())
                .add("Description", description()).add("DeviceIndex", deviceIndex()).add("Groups", hasGroups() ? groups() : null)
                .add("InterfaceType", interfaceType()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).add("SubnetId", subnetId())
                .add("NetworkCardIndex", networkCardIndex()).add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv4PrefixCount", ipv4PrefixCount()).add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null)
                .add("Ipv6PrefixCount", ipv6PrefixCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociateCarrierIpAddress":
            return Optional.ofNullable(clazz.cast(associateCarrierIpAddress()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceType()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceNetworkInterfaceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateInstanceNetworkInterfaceSpecification> {
        /**
         * <p>
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
         * </p>
         * <p>
         * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address
         * with the network interface. For more information about Carrier IP addresses, see <a href=
         * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         * >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
         * </p>
         * 
         * @param associateCarrierIpAddress
         *        Indicates whether to associate a Carrier IP address with eth0 for a new network interface.</p>
         *        <p>
         *        Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP
         *        address with the network interface. For more information about Carrier IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         *        >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress);

        /**
         * <p>
         * Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device index for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The device index for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The number of IPv6 addresses for the network interface.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * The IPv6 addresses for the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses for the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceIpv6Address>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceIpv6Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceIpv6Address>.Builder#build()} is called immediately
         * and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on {@link List<InstanceIpv6Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(List<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param privateIpAddress
         *        The primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateIpAddressSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<PrivateIpAddressSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateIpAddressSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressSpecification>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<PrivateIpAddressSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<PrivateIpAddressSpecification>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses for the network interface.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet for the network interface.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The index of the network card.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * One or more IPv4 delegated prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 delegated prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationResponse> ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 delegated prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 delegated prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecificationResponse... ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 delegated prefixes assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv4PrefixSpecificationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<Ipv4PrefixSpecificationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv4PrefixSpecificationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecificationResponse>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on {@link List<Ipv4PrefixSpecificationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(List<Ipv4PrefixSpecificationResponse>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationResponse.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv4 delegated prefixes that AWS automatically assigned to the network interface.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 delegated prefixes that AWS automatically assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * One or more IPv6 delegated prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 delegated prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationResponse> ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 delegated prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 delegated prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecificationResponse... ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 delegated prefixes assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6PrefixSpecificationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<Ipv6PrefixSpecificationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6PrefixSpecificationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecificationResponse>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on {@link List<Ipv6PrefixSpecificationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(List<Ipv6PrefixSpecificationResponse>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationResponse.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The number of IPv6 delegated prefixes that AWS automatically assigned to the network interface.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 delegated prefixes that AWS automatically assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associateCarrierIpAddress;

        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String interfaceType;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private Integer networkCardIndex;

        private List<Ipv4PrefixSpecificationResponse> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private List<Ipv6PrefixSpecificationResponse> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6PrefixCount;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceNetworkInterfaceSpecification model) {
            associateCarrierIpAddress(model.associateCarrierIpAddress);
            associatePublicIpAddress(model.associatePublicIpAddress);
            deleteOnTermination(model.deleteOnTermination);
            description(model.description);
            deviceIndex(model.deviceIndex);
            groups(model.groups);
            interfaceType(model.interfaceType);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            subnetId(model.subnetId);
            networkCardIndex(model.networkCardIndex);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            ipv6PrefixCount(model.ipv6PrefixCount);
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        @Transient
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        @Transient
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        @Transient
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        @Transient
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        @Transient
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        @Transient
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        @Transient
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        @Transient
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> PrivateIpAddressSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        @Transient
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        @Transient
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final List<Ipv4PrefixSpecificationResponse.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationResponse.Builder> result = Ipv4PrefixListResponseCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationResponse.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListResponseCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationResponse> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListResponseCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationResponse... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationResponse.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecificationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        @Transient
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationResponse.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationResponse.Builder> result = Ipv6PrefixListResponseCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationResponse.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListResponseCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationResponse> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListResponseCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationResponse... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationResponse.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecificationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        @Transient
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        @Override
        public LaunchTemplateInstanceNetworkInterfaceSpecification build() {
            return new LaunchTemplateInstanceNetworkInterfaceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
