/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySnapshotAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifySnapshotAttributeRequest.Builder, ModifySnapshotAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(ModifySnapshotAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<CreateVolumePermissionModifications> CREATE_VOLUME_PERMISSION_FIELD = SdkField
            .<CreateVolumePermissionModifications> builder(MarshallingType.SDK_POJO)
            .memberName("CreateVolumePermission")
            .getter(getter(ModifySnapshotAttributeRequest::createVolumePermission))
            .setter(setter(Builder::createVolumePermission))
            .constructor(CreateVolumePermissionModifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateVolumePermission")
                    .unmarshallLocationName("CreateVolumePermission").build()).build();

    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupNames")
            .getter(getter(ModifySnapshotAttributeRequest::groupNames))
            .setter(setter(Builder::groupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup")
                    .unmarshallLocationName("UserGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GroupName").unmarshallLocationName("GroupName").build())
                                            .build()).build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperationType")
            .getter(getter(ModifySnapshotAttributeRequest::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType")
                    .unmarshallLocationName("OperationType").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(ModifySnapshotAttributeRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(ModifySnapshotAttributeRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("UserId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserId").unmarshallLocationName("UserId").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            CREATE_VOLUME_PERMISSION_FIELD, GROUP_NAMES_FIELD, OPERATION_TYPE_FIELD, SNAPSHOT_ID_FIELD, USER_IDS_FIELD));

    private final String attribute;

    private final CreateVolumePermissionModifications createVolumePermission;

    private final List<String> groupNames;

    private final String operationType;

    private final String snapshotId;

    private final List<String> userIds;

    private ModifySnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.createVolumePermission = builder.createVolumePermission;
        this.groupNames = builder.groupNames;
        this.operationType = builder.operationType;
        this.snapshotId = builder.snapshotId;
        this.userIds = builder.userIds;
    }

    /**
     * <p>
     * The snapshot attribute to modify. Only volume creation permissions can be modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The snapshot attribute to modify. Only volume creation permissions can be modified.
     * @see SnapshotAttributeName
     */
    public final SnapshotAttributeName attribute() {
        return SnapshotAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The snapshot attribute to modify. Only volume creation permissions can be modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The snapshot attribute to modify. Only volume creation permissions can be modified.
     * @see SnapshotAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * A JSON representation of the snapshot attribute modification.
     * </p>
     * 
     * @return A JSON representation of the snapshot attribute modification.
     */
    public final CreateVolumePermissionModifications createVolumePermission() {
        return createVolumePermission;
    }

    /**
     * Returns true if the GroupNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroupNames() {
        return groupNames != null && !(groupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group to modify for the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The group to modify for the snapshot.
     */
    public final List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * The type of operation to perform to the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation to perform to the attribute.
     * @see OperationType
     */
    public final OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of operation to perform to the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation to perform to the attribute.
     * @see OperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * Returns true if the UserIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account ID to modify for the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The account ID to modify for the snapshot.
     */
    public final List<String> userIds() {
        return userIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createVolumePermission());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupNames() ? groupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(createVolumePermission(), other.createVolumePermission())
                && hasGroupNames() == other.hasGroupNames() && Objects.equals(groupNames(), other.groupNames())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(snapshotId(), other.snapshotId()) && hasUserIds() == other.hasUserIds()
                && Objects.equals(userIds(), other.userIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySnapshotAttributeRequest").add("Attribute", attributeAsString())
                .add("CreateVolumePermission", createVolumePermission()).add("GroupNames", hasGroupNames() ? groupNames() : null)
                .add("OperationType", operationTypeAsString()).add("SnapshotId", snapshotId())
                .add("UserIds", hasUserIds() ? userIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "CreateVolumePermission":
            return Optional.ofNullable(clazz.cast(createVolumePermission()));
        case "GroupNames":
            return Optional.ofNullable(clazz.cast(groupNames()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifySnapshotAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
        /**
         * <p>
         * The snapshot attribute to modify. Only volume creation permissions can be modified.
         * </p>
         * 
         * @param attribute
         *        The snapshot attribute to modify. Only volume creation permissions can be modified.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The snapshot attribute to modify. Only volume creation permissions can be modified.
         * </p>
         * 
         * @param attribute
         *        The snapshot attribute to modify. Only volume creation permissions can be modified.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(SnapshotAttributeName attribute);

        /**
         * <p>
         * A JSON representation of the snapshot attribute modification.
         * </p>
         * 
         * @param createVolumePermission
         *        A JSON representation of the snapshot attribute modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission);

        /**
         * <p>
         * A JSON representation of the snapshot attribute modification.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateVolumePermissionModifications.Builder}
         * avoiding the need to create one manually via {@link CreateVolumePermissionModifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateVolumePermissionModifications.Builder#build()} is called
         * immediately and its result is passed to {@link #createVolumePermission(CreateVolumePermissionModifications)}.
         * 
         * @param createVolumePermission
         *        a consumer that will call methods on {@link CreateVolumePermissionModifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createVolumePermission(CreateVolumePermissionModifications)
         */
        default Builder createVolumePermission(Consumer<CreateVolumePermissionModifications.Builder> createVolumePermission) {
            return createVolumePermission(CreateVolumePermissionModifications.builder().applyMutation(createVolumePermission)
                    .build());
        }

        /**
         * <p>
         * The group to modify for the snapshot.
         * </p>
         * 
         * @param groupNames
         *        The group to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * The group to modify for the snapshot.
         * </p>
         * 
         * @param groupNames
         *        The group to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * The type of operation to perform to the attribute.
         * </p>
         * 
         * @param operationType
         *        The type of operation to perform to the attribute.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation to perform to the attribute.
         * </p>
         * 
         * @param operationType
         *        The type of operation to perform to the attribute.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The account ID to modify for the snapshot.
         * </p>
         * 
         * @param userIds
         *        The account ID to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The account ID to modify for the snapshot.
         * </p>
         * 
         * @param userIds
         *        The account ID to modify for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private CreateVolumePermissionModifications createVolumePermission;

        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();

        private String operationType;

        private String snapshotId;

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            createVolumePermission(model.createVolumePermission);
            groupNames(model.groupNames);
            operationType(model.operationType);
            snapshotId(model.snapshotId);
            userIds(model.userIds);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        @Transient
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        @Transient
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final CreateVolumePermissionModifications.Builder getCreateVolumePermission() {
            return createVolumePermission != null ? createVolumePermission.toBuilder() : null;
        }

        public final void setCreateVolumePermission(CreateVolumePermissionModifications.BuilderImpl createVolumePermission) {
            this.createVolumePermission = createVolumePermission != null ? createVolumePermission.build() : null;
        }

        @Override
        @Transient
        public final Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
            return this;
        }

        public final Collection<String> getGroupNames() {
            if (groupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return groupNames;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @Override
        @Transient
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        @Transient
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        @Transient
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotAttributeRequest build() {
            return new ModifySnapshotAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
