/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrafficMirrorFilterNetworkServicesRequest extends Ec2Request
        implements
        ToCopyableBuilder<ModifyTrafficMirrorFilterNetworkServicesRequest.Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<List<String>> ADD_NETWORK_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddNetworkServices")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::addNetworkServicesAsStrings))
            .setter(setter(Builder::addNetworkServicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkService")
                    .unmarshallLocationName("AddNetworkService").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_NETWORK_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveNetworkServices")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::removeNetworkServicesAsStrings))
            .setter(setter(Builder::removeNetworkServicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkService")
                    .unmarshallLocationName("RemoveNetworkService").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_ID_FIELD, ADD_NETWORK_SERVICES_FIELD, REMOVE_NETWORK_SERVICES_FIELD));

    private final String trafficMirrorFilterId;

    private final List<String> addNetworkServices;

    private final List<String> removeNetworkServices;

    private ModifyTrafficMirrorFilterNetworkServicesRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.addNetworkServices = builder.addNetworkServices;
        this.removeNetworkServices = builder.removeNetworkServices;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddNetworkServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you want to mirror.
     */
    public final List<TrafficMirrorNetworkService> addNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(addNetworkServices);
    }

    /**
     * Returns true if the AddNetworkServices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAddNetworkServices() {
        return addNetworkServices != null && !(addNetworkServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddNetworkServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you want to mirror.
     */
    public final List<String> addNetworkServicesAsStrings() {
        return addNetworkServices;
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you no longer want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveNetworkServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you no longer want to mirror.
     */
    public final List<TrafficMirrorNetworkService> removeNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(removeNetworkServices);
    }

    /**
     * Returns true if the RemoveNetworkServices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRemoveNetworkServices() {
        return removeNetworkServices != null && !(removeNetworkServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you no longer want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveNetworkServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you no longer want to mirror.
     */
    public final List<String> removeNetworkServicesAsStrings() {
        return removeNetworkServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddNetworkServices() ? addNetworkServicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveNetworkServices() ? removeNetworkServicesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorFilterNetworkServicesRequest)) {
            return false;
        }
        ModifyTrafficMirrorFilterNetworkServicesRequest other = (ModifyTrafficMirrorFilterNetworkServicesRequest) obj;
        return Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && hasAddNetworkServices() == other.hasAddNetworkServices()
                && Objects.equals(addNetworkServicesAsStrings(), other.addNetworkServicesAsStrings())
                && hasRemoveNetworkServices() == other.hasRemoveNetworkServices()
                && Objects.equals(removeNetworkServicesAsStrings(), other.removeNetworkServicesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTrafficMirrorFilterNetworkServicesRequest")
                .add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("AddNetworkServices", hasAddNetworkServices() ? addNetworkServicesAsStrings() : null)
                .add("RemoveNetworkServices", hasRemoveNetworkServices() ? removeNetworkServicesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "AddNetworkServices":
            return Optional.ofNullable(clazz.cast(addNetworkServicesAsStrings()));
        case "RemoveNetworkServices":
            return Optional.ofNullable(clazz.cast(removeNetworkServicesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorFilterNetworkServicesRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorFilterNetworkServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServicesWithStrings(Collection<String> addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServicesWithStrings(String... addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServices(Collection<TrafficMirrorNetworkService> addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServices(TrafficMirrorNetworkService... addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServicesWithStrings(Collection<String> removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServicesWithStrings(String... removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServices(TrafficMirrorNetworkService... removeNetworkServices);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorFilterId;

        private List<String> addNetworkServices = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeNetworkServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorFilterNetworkServicesRequest model) {
            super(model);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            addNetworkServicesWithStrings(model.addNetworkServices);
            removeNetworkServicesWithStrings(model.removeNetworkServices);
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        @Transient
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final Collection<String> getAddNetworkServices() {
            if (addNetworkServices instanceof SdkAutoConstructList) {
                return null;
            }
            return addNetworkServices;
        }

        public final void setAddNetworkServices(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
        }

        @Override
        @Transient
        public final Builder addNetworkServicesWithStrings(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addNetworkServicesWithStrings(String... addNetworkServices) {
            addNetworkServicesWithStrings(Arrays.asList(addNetworkServices));
            return this;
        }

        @Override
        @Transient
        public final Builder addNetworkServices(Collection<TrafficMirrorNetworkService> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(addNetworkServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addNetworkServices(TrafficMirrorNetworkService... addNetworkServices) {
            addNetworkServices(Arrays.asList(addNetworkServices));
            return this;
        }

        public final Collection<String> getRemoveNetworkServices() {
            if (removeNetworkServices instanceof SdkAutoConstructList) {
                return null;
            }
            return removeNetworkServices;
        }

        public final void setRemoveNetworkServices(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
        }

        @Override
        @Transient
        public final Builder removeNetworkServicesWithStrings(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeNetworkServicesWithStrings(String... removeNetworkServices) {
            removeNetworkServicesWithStrings(Arrays.asList(removeNetworkServices));
            return this;
        }

        @Override
        @Transient
        public final Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(removeNetworkServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeNetworkServices(TrafficMirrorNetworkService... removeNetworkServices) {
            removeNetworkServices(Arrays.asList(removeNetworkServices));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorFilterNetworkServicesRequest build() {
            return new ModifyTrafficMirrorFilterNetworkServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
