/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the processor used by the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ProcessorInfo.Builder, ProcessorInfo> {
    private static final SdkField<List<String>> SUPPORTED_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedArchitectures")
            .getter(getter(ProcessorInfo::supportedArchitecturesAsStrings))
            .setter(setter(Builder::supportedArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedArchitectures")
                    .unmarshallLocationName("supportedArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Double> SUSTAINED_CLOCK_SPEED_IN_GHZ_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("SustainedClockSpeedInGhz")
            .getter(getter(ProcessorInfo::sustainedClockSpeedInGhz))
            .setter(setter(Builder::sustainedClockSpeedInGhz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SustainedClockSpeedInGhz")
                    .unmarshallLocationName("sustainedClockSpeedInGhz").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_ARCHITECTURES_FIELD,
            SUSTAINED_CLOCK_SPEED_IN_GHZ_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> supportedArchitectures;

    private final Double sustainedClockSpeedInGhz;

    private ProcessorInfo(BuilderImpl builder) {
        this.supportedArchitectures = builder.supportedArchitectures;
        this.sustainedClockSpeedInGhz = builder.sustainedClockSpeedInGhz;
    }

    /**
     * <p>
     * The architectures supported by the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedArchitectures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The architectures supported by the instance type.
     */
    public final List<ArchitectureType> supportedArchitectures() {
        return ArchitectureTypeListCopier.copyStringToEnum(supportedArchitectures);
    }

    /**
     * Returns true if the SupportedArchitectures property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedArchitectures() {
        return supportedArchitectures != null && !(supportedArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The architectures supported by the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedArchitectures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The architectures supported by the instance type.
     */
    public final List<String> supportedArchitecturesAsStrings() {
        return supportedArchitectures;
    }

    /**
     * <p>
     * The speed of the processor, in GHz.
     * </p>
     * 
     * @return The speed of the processor, in GHz.
     */
    public final Double sustainedClockSpeedInGhz() {
        return sustainedClockSpeedInGhz;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedArchitectures() ? supportedArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sustainedClockSpeedInGhz());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorInfo)) {
            return false;
        }
        ProcessorInfo other = (ProcessorInfo) obj;
        return hasSupportedArchitectures() == other.hasSupportedArchitectures()
                && Objects.equals(supportedArchitecturesAsStrings(), other.supportedArchitecturesAsStrings())
                && Objects.equals(sustainedClockSpeedInGhz(), other.sustainedClockSpeedInGhz());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessorInfo")
                .add("SupportedArchitectures", hasSupportedArchitectures() ? supportedArchitecturesAsStrings() : null)
                .add("SustainedClockSpeedInGhz", sustainedClockSpeedInGhz()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportedArchitectures":
            return Optional.ofNullable(clazz.cast(supportedArchitecturesAsStrings()));
        case "SustainedClockSpeedInGhz":
            return Optional.ofNullable(clazz.cast(sustainedClockSpeedInGhz()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessorInfo, T> g) {
        return obj -> g.apply((ProcessorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessorInfo> {
        /**
         * <p>
         * The architectures supported by the instance type.
         * </p>
         * 
         * @param supportedArchitectures
         *        The architectures supported by the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedArchitecturesWithStrings(Collection<String> supportedArchitectures);

        /**
         * <p>
         * The architectures supported by the instance type.
         * </p>
         * 
         * @param supportedArchitectures
         *        The architectures supported by the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedArchitecturesWithStrings(String... supportedArchitectures);

        /**
         * <p>
         * The architectures supported by the instance type.
         * </p>
         * 
         * @param supportedArchitectures
         *        The architectures supported by the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedArchitectures(Collection<ArchitectureType> supportedArchitectures);

        /**
         * <p>
         * The architectures supported by the instance type.
         * </p>
         * 
         * @param supportedArchitectures
         *        The architectures supported by the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedArchitectures(ArchitectureType... supportedArchitectures);

        /**
         * <p>
         * The speed of the processor, in GHz.
         * </p>
         * 
         * @param sustainedClockSpeedInGhz
         *        The speed of the processor, in GHz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz);
    }

    static final class BuilderImpl implements Builder {
        private List<String> supportedArchitectures = DefaultSdkAutoConstructList.getInstance();

        private Double sustainedClockSpeedInGhz;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorInfo model) {
            supportedArchitecturesWithStrings(model.supportedArchitectures);
            sustainedClockSpeedInGhz(model.sustainedClockSpeedInGhz);
        }

        public final Collection<String> getSupportedArchitectures() {
            if (supportedArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedArchitectures;
        }

        public final void setSupportedArchitectures(Collection<String> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copy(supportedArchitectures);
        }

        @Override
        @Transient
        public final Builder supportedArchitecturesWithStrings(Collection<String> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copy(supportedArchitectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedArchitecturesWithStrings(String... supportedArchitectures) {
            supportedArchitecturesWithStrings(Arrays.asList(supportedArchitectures));
            return this;
        }

        @Override
        @Transient
        public final Builder supportedArchitectures(Collection<ArchitectureType> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copyEnumToString(supportedArchitectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedArchitectures(ArchitectureType... supportedArchitectures) {
            supportedArchitectures(Arrays.asList(supportedArchitectures));
            return this;
        }

        public final Double getSustainedClockSpeedInGhz() {
            return sustainedClockSpeedInGhz;
        }

        public final void setSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
            this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
        }

        @Override
        @Transient
        public final Builder sustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
            this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
            return this;
        }

        @Override
        public ProcessorInfo build() {
            return new ProcessorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
