/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcPeeringConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcPeeringConnection.Builder, VpcPeeringConnection> {
    private static final SdkField<VpcPeeringConnectionVpcInfo> ACCEPTER_VPC_INFO_FIELD = SdkField
            .<VpcPeeringConnectionVpcInfo> builder(MarshallingType.SDK_POJO)
            .memberName("AccepterVpcInfo")
            .getter(getter(VpcPeeringConnection::accepterVpcInfo))
            .setter(setter(Builder::accepterVpcInfo))
            .constructor(VpcPeeringConnectionVpcInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterVpcInfo")
                    .unmarshallLocationName("accepterVpcInfo").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime")
            .getter(getter(VpcPeeringConnection::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime")
                    .unmarshallLocationName("expirationTime").build()).build();

    private static final SdkField<VpcPeeringConnectionVpcInfo> REQUESTER_VPC_INFO_FIELD = SdkField
            .<VpcPeeringConnectionVpcInfo> builder(MarshallingType.SDK_POJO)
            .memberName("RequesterVpcInfo")
            .getter(getter(VpcPeeringConnection::requesterVpcInfo))
            .setter(setter(Builder::requesterVpcInfo))
            .constructor(VpcPeeringConnectionVpcInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterVpcInfo")
                    .unmarshallLocationName("requesterVpcInfo").build()).build();

    private static final SdkField<VpcPeeringConnectionStateReason> STATUS_FIELD = SdkField
            .<VpcPeeringConnectionStateReason> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(VpcPeeringConnection::status))
            .setter(setter(Builder::status))
            .constructor(VpcPeeringConnectionStateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VpcPeeringConnection::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(VpcPeeringConnection::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTER_VPC_INFO_FIELD,
            EXPIRATION_TIME_FIELD, REQUESTER_VPC_INFO_FIELD, STATUS_FIELD, TAGS_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;

    private final Instant expirationTime;

    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;

    private final VpcPeeringConnectionStateReason status;

    private final List<Tag> tags;

    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering
     * connection.
     * </p>
     * 
     * @return Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
     *         peering connection.
     */
    public final VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return accepterVpcInfo;
    }

    /**
     * <p>
     * The time that an unaccepted VPC peering connection will expire.
     * </p>
     * 
     * @return The time that an unaccepted VPC peering connection will expire.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
     * peering connection.
     * </p>
     * 
     * @return Information about the requester VPC. CIDR block information is only returned when describing an active
     *         VPC peering connection.
     */
    public final VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return requesterVpcInfo;
    }

    /**
     * <p>
     * The status of the VPC peering connection.
     * </p>
     * 
     * @return The status of the VPC peering connection.
     */
    public final VpcPeeringConnectionStateReason status() {
        return status;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accepterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(requesterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection) obj;
        return Objects.equals(accepterVpcInfo(), other.accepterVpcInfo())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(requesterVpcInfo(), other.requesterVpcInfo()) && Objects.equals(status(), other.status())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcPeeringConnection").add("AccepterVpcInfo", accepterVpcInfo())
                .add("ExpirationTime", expirationTime()).add("RequesterVpcInfo", requesterVpcInfo()).add("Status", status())
                .add("Tags", hasTags() ? tags() : null).add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterVpcInfo":
            return Optional.ofNullable(clazz.cast(accepterVpcInfo()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "RequesterVpcInfo":
            return Optional.ofNullable(clazz.cast(requesterVpcInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnection, T> g) {
        return obj -> g.apply((VpcPeeringConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcPeeringConnection> {
        /**
         * <p>
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param accepterVpcInfo
         *        Information about the accepter VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo);

        /**
         * <p>
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionVpcInfo.Builder} avoiding
         * the need to create one manually via {@link VpcPeeringConnectionVpcInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionVpcInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #accepterVpcInfo(VpcPeeringConnectionVpcInfo)}.
         * 
         * @param accepterVpcInfo
         *        a consumer that will call methods on {@link VpcPeeringConnectionVpcInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterVpcInfo(VpcPeeringConnectionVpcInfo)
         */
        default Builder accepterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> accepterVpcInfo) {
            return accepterVpcInfo(VpcPeeringConnectionVpcInfo.builder().applyMutation(accepterVpcInfo).build());
        }

        /**
         * <p>
         * The time that an unaccepted VPC peering connection will expire.
         * </p>
         * 
         * @param expirationTime
         *        The time that an unaccepted VPC peering connection will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param requesterVpcInfo
         *        Information about the requester VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo);

        /**
         * <p>
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionVpcInfo.Builder} avoiding
         * the need to create one manually via {@link VpcPeeringConnectionVpcInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionVpcInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #requesterVpcInfo(VpcPeeringConnectionVpcInfo)}.
         * 
         * @param requesterVpcInfo
         *        a consumer that will call methods on {@link VpcPeeringConnectionVpcInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterVpcInfo(VpcPeeringConnectionVpcInfo)
         */
        default Builder requesterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> requesterVpcInfo) {
            return requesterVpcInfo(VpcPeeringConnectionVpcInfo.builder().applyMutation(requesterVpcInfo).build());
        }

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * 
         * @param status
         *        The status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VpcPeeringConnectionStateReason status);

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionStateReason.Builder}
         * avoiding the need to create one manually via {@link VpcPeeringConnectionStateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionStateReason.Builder#build()} is called
         * immediately and its result is passed to {@link #status(VpcPeeringConnectionStateReason)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VpcPeeringConnectionStateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VpcPeeringConnectionStateReason)
         */
        default Builder status(Consumer<VpcPeeringConnectionStateReason.Builder> status) {
            return status(VpcPeeringConnectionStateReason.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;

        private Instant expirationTime;

        private VpcPeeringConnectionVpcInfo requesterVpcInfo;

        private VpcPeeringConnectionStateReason status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            accepterVpcInfo(model.accepterVpcInfo);
            expirationTime(model.expirationTime);
            requesterVpcInfo(model.requesterVpcInfo);
            status(model.status);
            tags(model.tags);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo.Builder getAccepterVpcInfo() {
            return accepterVpcInfo != null ? accepterVpcInfo.toBuilder() : null;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        @Transient
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final VpcPeeringConnectionVpcInfo.Builder getRequesterVpcInfo() {
            return requesterVpcInfo != null ? requesterVpcInfo.toBuilder() : null;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final VpcPeeringConnectionStateReason.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(VpcPeeringConnectionStateReason.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        @Transient
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
