/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.IpamScope;

public class DescribeIpamScopesIterable
implements SdkIterable<DescribeIpamScopesResponse> {
    private final Ec2Client client;
    private final DescribeIpamScopesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamScopesIterable(Ec2Client client, DescribeIpamScopesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeIpamScopesResponseFetcher();
    }

    public Iterator<DescribeIpamScopesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamScope> ipamScopes() {
        Function<DescribeIpamScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamScopes() != null) {
                return response.ipamScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamScopesResponseFetcher
    implements SyncPageFetcher<DescribeIpamScopesResponse> {
        private DescribeIpamScopesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamScopesResponse nextPage(DescribeIpamScopesResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamScopesIterable.this.client.describeIpamScopes(DescribeIpamScopesIterable.this.firstRequest);
            }
            return DescribeIpamScopesIterable.this.client.describeIpamScopes((DescribeIpamScopesRequest)((Object)DescribeIpamScopesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

