/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkInsightsAnalysesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeNetworkInsightsAnalysesRequest.Builder, DescribeNetworkInsightsAnalysesRequest> {
    private static final SdkField<List<String>> NETWORK_INSIGHTS_ANALYSIS_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInsightsAnalysisIds")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::networkInsightsAnalysisIds))
            .setter(setter(Builder::networkInsightsAnalysisIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisId")
                    .unmarshallLocationName("NetworkInsightsAnalysisId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathId")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::networkInsightsPathId))
            .setter(setter(Builder::networkInsightsPathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId")
                    .unmarshallLocationName("NetworkInsightsPathId").build()).build();

    private static final SdkField<Instant> ANALYSIS_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AnalysisStartTime")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::analysisStartTime))
            .setter(setter(Builder::analysisStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTime")
                    .unmarshallLocationName("AnalysisStartTime").build()).build();

    private static final SdkField<Instant> ANALYSIS_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AnalysisEndTime")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::analysisEndTime))
            .setter(setter(Builder::analysisEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisEndTime")
                    .unmarshallLocationName("AnalysisEndTime").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeNetworkInsightsAnalysesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ANALYSIS_IDS_FIELD, NETWORK_INSIGHTS_PATH_ID_FIELD, ANALYSIS_START_TIME_FIELD,
            ANALYSIS_END_TIME_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> networkInsightsAnalysisIds;

    private final String networkInsightsPathId;

    private final Instant analysisStartTime;

    private final Instant analysisEndTime;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeNetworkInsightsAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAnalysisIds = builder.networkInsightsAnalysisIds;
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.analysisStartTime = builder.analysisStartTime;
        this.analysisEndTime = builder.analysisEndTime;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInsightsAnalysisIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInsightsAnalysisIds() {
        return networkInsightsAnalysisIds != null && !(networkInsightsAnalysisIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInsightsAnalysisIds} method.
     * </p>
     * 
     * @return The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
     */
    public final List<String> networkInsightsAnalysisIds() {
        return networkInsightsAnalysisIds;
    }

    /**
     * <p>
     * The ID of the path. You must specify either a path ID or analysis IDs.
     * </p>
     * 
     * @return The ID of the path. You must specify either a path ID or analysis IDs.
     */
    public final String networkInsightsPathId() {
        return networkInsightsPathId;
    }

    /**
     * <p>
     * The time when the network insights analyses started.
     * </p>
     * 
     * @return The time when the network insights analyses started.
     */
    public final Instant analysisStartTime() {
        return analysisStartTime;
    }

    /**
     * <p>
     * The time when the network insights analyses ended.
     * </p>
     * 
     * @return The time when the network insights analyses ended.
     */
    public final Instant analysisEndTime() {
        return analysisEndTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PathFound - A Boolean value that indicates whether a feasible path is found.
     * </p>
     * </li>
     * <li>
     * <p>
     * Status - The status of the analysis (running | succeeded | failed).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PathFound - A Boolean value that indicates whether a feasible path is found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Status - The status of the analysis (running | succeeded | failed).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInsightsAnalysisIds() ? networkInsightsAnalysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(analysisEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAnalysesRequest)) {
            return false;
        }
        DescribeNetworkInsightsAnalysesRequest other = (DescribeNetworkInsightsAnalysesRequest) obj;
        return hasNetworkInsightsAnalysisIds() == other.hasNetworkInsightsAnalysisIds()
                && Objects.equals(networkInsightsAnalysisIds(), other.networkInsightsAnalysisIds())
                && Objects.equals(networkInsightsPathId(), other.networkInsightsPathId())
                && Objects.equals(analysisStartTime(), other.analysisStartTime())
                && Objects.equals(analysisEndTime(), other.analysisEndTime()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNetworkInsightsAnalysesRequest")
                .add("NetworkInsightsAnalysisIds", hasNetworkInsightsAnalysisIds() ? networkInsightsAnalysisIds() : null)
                .add("NetworkInsightsPathId", networkInsightsPathId()).add("AnalysisStartTime", analysisStartTime())
                .add("AnalysisEndTime", analysisEndTime()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAnalysisIds":
            return Optional.ofNullable(clazz.cast(networkInsightsAnalysisIds()));
        case "NetworkInsightsPathId":
            return Optional.ofNullable(clazz.cast(networkInsightsPathId()));
        case "AnalysisStartTime":
            return Optional.ofNullable(clazz.cast(analysisStartTime()));
        case "AnalysisEndTime":
            return Optional.ofNullable(clazz.cast(analysisEndTime()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAnalysesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAnalysesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNetworkInsightsAnalysesRequest> {
        /**
         * <p>
         * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         * </p>
         * 
         * @param networkInsightsAnalysisIds
         *        The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAnalysisIds(Collection<String> networkInsightsAnalysisIds);

        /**
         * <p>
         * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         * </p>
         * 
         * @param networkInsightsAnalysisIds
         *        The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAnalysisIds(String... networkInsightsAnalysisIds);

        /**
         * <p>
         * The ID of the path. You must specify either a path ID or analysis IDs.
         * </p>
         * 
         * @param networkInsightsPathId
         *        The ID of the path. You must specify either a path ID or analysis IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathId(String networkInsightsPathId);

        /**
         * <p>
         * The time when the network insights analyses started.
         * </p>
         * 
         * @param analysisStartTime
         *        The time when the network insights analyses started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStartTime(Instant analysisStartTime);

        /**
         * <p>
         * The time when the network insights analyses ended.
         * </p>
         * 
         * @param analysisEndTime
         *        The time when the network insights analyses ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisEndTime(Instant analysisEndTime);

        /**
         * <p>
         * The filters. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PathFound - A Boolean value that indicates whether a feasible path is found.
         * </p>
         * </li>
         * <li>
         * <p>
         * Status - The status of the analysis (running | succeeded | failed).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PathFound - A Boolean value that indicates whether a feasible path is found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Status - The status of the analysis (running | succeeded | failed).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PathFound - A Boolean value that indicates whether a feasible path is found.
         * </p>
         * </li>
         * <li>
         * <p>
         * Status - The status of the analysis (running | succeeded | failed).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PathFound - A Boolean value that indicates whether a feasible path is found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Status - The status of the analysis (running | succeeded | failed).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PathFound - A Boolean value that indicates whether a feasible path is found.
         * </p>
         * </li>
         * <li>
         * <p>
         * Status - The status of the analysis (running | succeeded | failed).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> networkInsightsAnalysisIds = DefaultSdkAutoConstructList.getInstance();

        private String networkInsightsPathId;

        private Instant analysisStartTime;

        private Instant analysisEndTime;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAnalysesRequest model) {
            super(model);
            networkInsightsAnalysisIds(model.networkInsightsAnalysisIds);
            networkInsightsPathId(model.networkInsightsPathId);
            analysisStartTime(model.analysisStartTime);
            analysisEndTime(model.analysisEndTime);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getNetworkInsightsAnalysisIds() {
            if (networkInsightsAnalysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInsightsAnalysisIds;
        }

        public final void setNetworkInsightsAnalysisIds(Collection<String> networkInsightsAnalysisIds) {
            this.networkInsightsAnalysisIds = NetworkInsightsAnalysisIdListCopier.copy(networkInsightsAnalysisIds);
        }

        @Override
        @Transient
        public final Builder networkInsightsAnalysisIds(Collection<String> networkInsightsAnalysisIds) {
            this.networkInsightsAnalysisIds = NetworkInsightsAnalysisIdListCopier.copy(networkInsightsAnalysisIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInsightsAnalysisIds(String... networkInsightsAnalysisIds) {
            networkInsightsAnalysisIds(Arrays.asList(networkInsightsAnalysisIds));
            return this;
        }

        public final String getNetworkInsightsPathId() {
            return networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        @Transient
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final Instant getAnalysisStartTime() {
            return analysisStartTime;
        }

        public final void setAnalysisStartTime(Instant analysisStartTime) {
            this.analysisStartTime = analysisStartTime;
        }

        @Override
        @Transient
        public final Builder analysisStartTime(Instant analysisStartTime) {
            this.analysisStartTime = analysisStartTime;
            return this;
        }

        public final Instant getAnalysisEndTime() {
            return analysisEndTime;
        }

        public final void setAnalysisEndTime(Instant analysisEndTime) {
            this.analysisEndTime = analysisEndTime;
        }

        @Override
        @Transient
        public final Builder analysisEndTime(Instant analysisEndTime) {
            this.analysisEndTime = analysisEndTime;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInsightsAnalysesRequest build() {
            return new DescribeNetworkInsightsAnalysesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
