/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFpgaImageResponse extends Ec2Response implements
        ToCopyableBuilder<CreateFpgaImageResponse.Builder, CreateFpgaImageResponse> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FpgaImageId")
            .getter(getter(CreateFpgaImageResponse::fpgaImageId))
            .setter(setter(Builder::fpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("fpgaImageId").build()).build();

    private static final SdkField<String> FPGA_IMAGE_GLOBAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FpgaImageGlobalId")
            .getter(getter(CreateFpgaImageResponse::fpgaImageGlobalId))
            .setter(setter(Builder::fpgaImageGlobalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageGlobalId")
                    .unmarshallLocationName("fpgaImageGlobalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD,
            FPGA_IMAGE_GLOBAL_ID_FIELD));

    private final String fpgaImageId;

    private final String fpgaImageGlobalId;

    private CreateFpgaImageResponse(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
    }

    /**
     * <p>
     * The FPGA image identifier (AFI ID).
     * </p>
     * 
     * @return The FPGA image identifier (AFI ID).
     */
    public final String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The global FPGA image identifier (AGFI ID).
     * </p>
     * 
     * @return The global FPGA image identifier (AGFI ID).
     */
    public final String fpgaImageGlobalId() {
        return fpgaImageGlobalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageGlobalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageResponse)) {
            return false;
        }
        CreateFpgaImageResponse other = (CreateFpgaImageResponse) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId())
                && Objects.equals(fpgaImageGlobalId(), other.fpgaImageGlobalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFpgaImageResponse").add("FpgaImageId", fpgaImageId())
                .add("FpgaImageGlobalId", fpgaImageGlobalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.ofNullable(clazz.cast(fpgaImageId()));
        case "FpgaImageGlobalId":
            return Optional.ofNullable(clazz.cast(fpgaImageGlobalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFpgaImageResponse, T> g) {
        return obj -> g.apply((CreateFpgaImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateFpgaImageResponse> {
        /**
         * <p>
         * The FPGA image identifier (AFI ID).
         * </p>
         * 
         * @param fpgaImageId
         *        The FPGA image identifier (AFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The global FPGA image identifier (AGFI ID).
         * </p>
         * 
         * @param fpgaImageGlobalId
         *        The global FPGA image identifier (AGFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageGlobalId(String fpgaImageGlobalId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String fpgaImageGlobalId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageResponse model) {
            super(model);
            fpgaImageId(model.fpgaImageId);
            fpgaImageGlobalId(model.fpgaImageGlobalId);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        @Override
        @Transient
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final String getFpgaImageGlobalId() {
            return fpgaImageGlobalId;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        @Override
        @Transient
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        @Override
        public CreateFpgaImageResponse build() {
            return new CreateFpgaImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
