/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransitGatewayAttachmentPropagationsResponse extends Ec2Response
        implements
        ToCopyableBuilder<GetTransitGatewayAttachmentPropagationsResponse.Builder, GetTransitGatewayAttachmentPropagationsResponse> {
    private static final SdkField<List<TransitGatewayAttachmentPropagation>> TRANSIT_GATEWAY_ATTACHMENT_PROPAGATIONS_FIELD = SdkField
            .<List<TransitGatewayAttachmentPropagation>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayAttachmentPropagations")
            .getter(getter(GetTransitGatewayAttachmentPropagationsResponse::transitGatewayAttachmentPropagations))
            .setter(setter(Builder::transitGatewayAttachmentPropagations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransitGatewayAttachmentPropagations")
                    .unmarshallLocationName("transitGatewayAttachmentPropagations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayAttachmentPropagation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayAttachmentPropagation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetTransitGatewayAttachmentPropagationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_PROPAGATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations;

    private final String nextToken;

    private GetTransitGatewayAttachmentPropagationsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentPropagations = builder.transitGatewayAttachmentPropagations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitGatewayAttachmentPropagations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasTransitGatewayAttachmentPropagations() {
        return transitGatewayAttachmentPropagations != null
                && !(transitGatewayAttachmentPropagations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the propagation route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitGatewayAttachmentPropagations}
     * method.
     * </p>
     * 
     * @return Information about the propagation route tables.
     */
    public final List<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations() {
        return transitGatewayAttachmentPropagations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasTransitGatewayAttachmentPropagations() ? transitGatewayAttachmentPropagations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayAttachmentPropagationsResponse)) {
            return false;
        }
        GetTransitGatewayAttachmentPropagationsResponse other = (GetTransitGatewayAttachmentPropagationsResponse) obj;
        return hasTransitGatewayAttachmentPropagations() == other.hasTransitGatewayAttachmentPropagations()
                && Objects.equals(transitGatewayAttachmentPropagations(), other.transitGatewayAttachmentPropagations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetTransitGatewayAttachmentPropagationsResponse")
                .add("TransitGatewayAttachmentPropagations",
                        hasTransitGatewayAttachmentPropagations() ? transitGatewayAttachmentPropagations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentPropagations":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentPropagations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayAttachmentPropagationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayAttachmentPropagationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransitGatewayAttachmentPropagationsResponse> {
        /**
         * <p>
         * Information about the propagation route tables.
         * </p>
         * 
         * @param transitGatewayAttachmentPropagations
         *        Information about the propagation route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentPropagations(
                Collection<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations);

        /**
         * <p>
         * Information about the propagation route tables.
         * </p>
         * 
         * @param transitGatewayAttachmentPropagations
         *        Information about the propagation route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentPropagations(TransitGatewayAttachmentPropagation... transitGatewayAttachmentPropagations);

        /**
         * <p>
         * Information about the propagation route tables.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <TransitGatewayAttachmentPropagation>.Builder} avoiding the need to create one manually via {@link List
         * <TransitGatewayAttachmentPropagation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitGatewayAttachmentPropagation>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #transitGatewayAttachmentPropagations(List<TransitGatewayAttachmentPropagation>)}.
         * 
         * @param transitGatewayAttachmentPropagations
         *        a consumer that will call methods on {@link List<TransitGatewayAttachmentPropagation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayAttachmentPropagations(List<TransitGatewayAttachmentPropagation>)
         */
        Builder transitGatewayAttachmentPropagations(
                Consumer<TransitGatewayAttachmentPropagation.Builder>... transitGatewayAttachmentPropagations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayAttachmentPropagationsResponse model) {
            super(model);
            transitGatewayAttachmentPropagations(model.transitGatewayAttachmentPropagations);
            nextToken(model.nextToken);
        }

        public final List<TransitGatewayAttachmentPropagation.Builder> getTransitGatewayAttachmentPropagations() {
            List<TransitGatewayAttachmentPropagation.Builder> result = TransitGatewayAttachmentPropagationListCopier
                    .copyToBuilder(this.transitGatewayAttachmentPropagations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayAttachmentPropagations(
                Collection<TransitGatewayAttachmentPropagation.BuilderImpl> transitGatewayAttachmentPropagations) {
            this.transitGatewayAttachmentPropagations = TransitGatewayAttachmentPropagationListCopier
                    .copyFromBuilder(transitGatewayAttachmentPropagations);
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentPropagations(
                Collection<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations) {
            this.transitGatewayAttachmentPropagations = TransitGatewayAttachmentPropagationListCopier
                    .copy(transitGatewayAttachmentPropagations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayAttachmentPropagations(
                TransitGatewayAttachmentPropagation... transitGatewayAttachmentPropagations) {
            transitGatewayAttachmentPropagations(Arrays.asList(transitGatewayAttachmentPropagations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayAttachmentPropagations(
                Consumer<TransitGatewayAttachmentPropagation.Builder>... transitGatewayAttachmentPropagations) {
            transitGatewayAttachmentPropagations(Stream.of(transitGatewayAttachmentPropagations)
                    .map(c -> TransitGatewayAttachmentPropagation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayAttachmentPropagationsResponse build() {
            return new GetTransitGatewayAttachmentPropagationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
