/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Dedicated Host Reservation and associated Dedicated Hosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostReservation implements SdkPojo, Serializable, ToCopyableBuilder<HostReservation.Builder, HostReservation> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(HostReservation::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(HostReservation::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration")
            .getter(getter(HostReservation::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("End")
            .getter(getter(HostReservation::end))
            .setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").unmarshallLocationName("end")
                    .build()).build();

    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HostIdSet")
            .getter(getter(HostReservation::hostIdSet))
            .setter(setter(Builder::hostIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet")
                    .unmarshallLocationName("hostIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostReservationId")
            .getter(getter(HostReservation::hostReservationId))
            .setter(setter(Builder::hostReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId")
                    .unmarshallLocationName("hostReservationId").build()).build();

    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HourlyPrice")
            .getter(getter(HostReservation::hourlyPrice))
            .setter(setter(Builder::hourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice")
                    .unmarshallLocationName("hourlyPrice").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily")
            .getter(getter(HostReservation::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("instanceFamily").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingId")
            .getter(getter(HostReservation::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId")
                    .unmarshallLocationName("offeringId").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption")
            .getter(getter(HostReservation::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption")
                    .unmarshallLocationName("paymentOption").build()).build();

    private static final SdkField<Instant> START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Start")
            .getter(getter(HostReservation::start))
            .setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start")
                    .unmarshallLocationName("start").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(HostReservation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> UPFRONT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpfrontPrice")
            .getter(getter(HostReservation::upfrontPrice))
            .setter(setter(Builder::upfrontPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice")
                    .unmarshallLocationName("upfrontPrice").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(HostReservation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            CURRENCY_CODE_FIELD, DURATION_FIELD, END_FIELD, HOST_ID_SET_FIELD, HOST_RESERVATION_ID_FIELD, HOURLY_PRICE_FIELD,
            INSTANCE_FAMILY_FIELD, OFFERING_ID_FIELD, PAYMENT_OPTION_FIELD, START_FIELD, STATE_FIELD, UPFRONT_PRICE_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String currencyCode;

    private final Integer duration;

    private final Instant end;

    private final List<String> hostIdSet;

    private final String hostReservationId;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String offeringId;

    private final String paymentOption;

    private final Instant start;

    private final String state;

    private final String upfrontPrice;

    private final List<Tag> tags;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The number of Dedicated Hosts the reservation is associated with.
     * </p>
     * 
     * @return The number of Dedicated Hosts the reservation is associated with.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
     * <code>94608000 (3 years)</code>.
     * </p>
     * 
     * @return The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
     *         <code>94608000 (3 years)</code>.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The date and time that the reservation ends.
     * </p>
     * 
     * @return The date and time that the reservation ends.
     */
    public final Instant end() {
        return end;
    }

    /**
     * For responses, this returns true if the service returned a value for the HostIdSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHostIdSet() {
        return hostIdSet != null && !(hostIdSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts associated with the reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHostIdSet} method.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts associated with the reservation.
     */
    public final List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The ID of the reservation that specifies the associated Dedicated Hosts.
     * </p>
     * 
     * @return The ID of the reservation that specifies the associated Dedicated Hosts.
     */
    public final String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The hourly price of the reservation.
     * </p>
     * 
     * @return The hourly price of the reservation.
     */
    public final String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be the same
     * in order for it to benefit from the reservation.
     * </p>
     * 
     * @return The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be
     *         the same in order for it to benefit from the reservation.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with it.
     * </p>
     * 
     * @return The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with
     *         it.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The payment option selected for this reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option selected for this reservation.
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option selected for this reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option selected for this reservation.
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The date and time that the reservation started.
     * </p>
     * 
     * @return The date and time that the reservation started.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The state of the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the reservation.
     * @see ReservationState
     */
    public final ReservationState state() {
        return ReservationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the reservation.
     * @see ReservationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The upfront price of the reservation.
     * </p>
     * 
     * @return The upfront price of the reservation.
     */
    public final String upfrontPrice() {
        return upfrontPrice;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the Dedicated Host Reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the Dedicated Host Reservation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(hasHostIdSet() ? hostIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPrice());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(duration(), other.duration()) && Objects.equals(end(), other.end())
                && hasHostIdSet() == other.hasHostIdSet() && Objects.equals(hostIdSet(), other.hostIdSet())
                && Objects.equals(hostReservationId(), other.hostReservationId())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(start(), other.start()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(upfrontPrice(), other.upfrontPrice()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostReservation").add("Count", count()).add("CurrencyCode", currencyCodeAsString())
                .add("Duration", duration()).add("End", end()).add("HostIdSet", hasHostIdSet() ? hostIdSet() : null)
                .add("HostReservationId", hostReservationId()).add("HourlyPrice", hourlyPrice())
                .add("InstanceFamily", instanceFamily()).add("OfferingId", offeringId())
                .add("PaymentOption", paymentOptionAsString()).add("Start", start()).add("State", stateAsString())
                .add("UpfrontPrice", upfrontPrice()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "HostIdSet":
            return Optional.ofNullable(clazz.cast(hostIdSet()));
        case "HostReservationId":
            return Optional.ofNullable(clazz.cast(hostReservationId()));
        case "HourlyPrice":
            return Optional.ofNullable(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "UpfrontPrice":
            return Optional.ofNullable(clazz.cast(upfrontPrice()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostReservation, T> g) {
        return obj -> g.apply((HostReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostReservation> {
        /**
         * <p>
         * The number of Dedicated Hosts the reservation is associated with.
         * </p>
         * 
         * @param count
         *        The number of Dedicated Hosts the reservation is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
         * <code>94608000 (3 years)</code>.
         * </p>
         * 
         * @param duration
         *        The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
         *        <code>94608000 (3 years)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The date and time that the reservation ends.
         * </p>
         * 
         * @param end
         *        The date and time that the reservation ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The ID of the reservation that specifies the associated Dedicated Hosts.
         * </p>
         * 
         * @param hostReservationId
         *        The ID of the reservation that specifies the associated Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The hourly price of the reservation.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be the
         * same in order for it to benefit from the reservation.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must
         *        be the same in order for it to benefit from the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with it.
         * </p>
         * 
         * @param offeringId
         *        The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated
         *        with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The payment option selected for this reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option selected for this reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option selected for this reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option selected for this reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The date and time that the reservation started.
         * </p>
         * 
         * @param start
         *        The date and time that the reservation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The state of the reservation.
         * </p>
         * 
         * @param state
         *        The state of the reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the reservation.
         * </p>
         * 
         * @param state
         *        The state of the reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(ReservationState state);

        /**
         * <p>
         * The upfront price of the reservation.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Dedicated Host Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Dedicated Host Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host Reservation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String currencyCode;

        private Integer duration;

        private Instant end;

        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();

        private String hostReservationId;

        private String hourlyPrice;

        private String instanceFamily;

        private String offeringId;

        private String paymentOption;

        private Instant start;

        private String state;

        private String upfrontPrice;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            count(model.count);
            currencyCode(model.currencyCode);
            duration(model.duration);
            end(model.end);
            hostIdSet(model.hostIdSet);
            hostReservationId(model.hostReservationId);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            offeringId(model.offeringId);
            paymentOption(model.paymentOption);
            start(model.start);
            state(model.state);
            upfrontPrice(model.upfrontPrice);
            tags(model.tags);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        @Transient
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        @Transient
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Collection<String> getHostIdSet() {
            if (hostIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return hostIdSet;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        @Override
        @Transient
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        @Override
        @Transient
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        @Override
        @Transient
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        @Transient
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        @Transient
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        @Transient
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        @Transient
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HostReservation build() {
            return new HostReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
