/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransitGatewayRouteTablesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeTransitGatewayRouteTablesRequest.Builder, DescribeTransitGatewayRouteTablesRequest> {
    private static final SdkField<List<String>> TRANSIT_GATEWAY_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayRouteTableIds")
            .getter(getter(DescribeTransitGatewayRouteTablesRequest::transitGatewayRouteTableIds))
            .setter(setter(Builder::transitGatewayRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableIds")
                    .unmarshallLocationName("TransitGatewayRouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeTransitGatewayRouteTablesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeTransitGatewayRouteTablesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeTransitGatewayRouteTablesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> transitGatewayRouteTableIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeTransitGatewayRouteTablesRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableIds = builder.transitGatewayRouteTableIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TransitGatewayRouteTableIds property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasTransitGatewayRouteTableIds() {
        return transitGatewayRouteTableIds != null && !(transitGatewayRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the transit gateway route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransitGatewayRouteTableIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the transit gateway route tables.
     */
    public final List<String> transitGatewayRouteTableIds() {
        return transitGatewayRouteTableIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default-association-route-table</code> - Indicates whether this is the default association route table for
     * the transit gateway (<code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table for
     * the transit gateway (<code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
     * <code>deleted</code> | <code>pending</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-id</code> - The ID of the transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default-association-route-table</code> - Indicates whether this is the default association route
     *         table for the transit gateway (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route
     *         table for the transit gateway (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
     *         <code>deleted</code> | <code>pending</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-id</code> - The ID of the transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayRouteTableIds() ? transitGatewayRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayRouteTablesRequest)) {
            return false;
        }
        DescribeTransitGatewayRouteTablesRequest other = (DescribeTransitGatewayRouteTablesRequest) obj;
        return hasTransitGatewayRouteTableIds() == other.hasTransitGatewayRouteTableIds()
                && Objects.equals(transitGatewayRouteTableIds(), other.transitGatewayRouteTableIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTransitGatewayRouteTablesRequest")
                .add("TransitGatewayRouteTableIds", hasTransitGatewayRouteTableIds() ? transitGatewayRouteTableIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableIds":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayRouteTablesRequest, T> g) {
        return obj -> g.apply((DescribeTransitGatewayRouteTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTransitGatewayRouteTablesRequest> {
        /**
         * <p>
         * The IDs of the transit gateway route tables.
         * </p>
         * 
         * @param transitGatewayRouteTableIds
         *        The IDs of the transit gateway route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableIds(Collection<String> transitGatewayRouteTableIds);

        /**
         * <p>
         * The IDs of the transit gateway route tables.
         * </p>
         * 
         * @param transitGatewayRouteTableIds
         *        The IDs of the transit gateway route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableIds(String... transitGatewayRouteTableIds);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default-association-route-table</code> - Indicates whether this is the default association route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
         * <code>deleted</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default-association-route-table</code> - Indicates whether this is the default association route
         *        table for the transit gateway (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route
         *        table for the transit gateway (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
         *        <code>deleted</code> | <code>pending</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of the transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default-association-route-table</code> - Indicates whether this is the default association route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
         * <code>deleted</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default-association-route-table</code> - Indicates whether this is the default association route
         *        table for the transit gateway (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route
         *        table for the transit gateway (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
         *        <code>deleted</code> | <code>pending</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of the transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default-association-route-table</code> - Indicates whether this is the default association route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table
         * for the transit gateway (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> |
         * <code>deleted</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> transitGatewayRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayRouteTablesRequest model) {
            super(model);
            transitGatewayRouteTableIds(model.transitGatewayRouteTableIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTransitGatewayRouteTableIds() {
            if (transitGatewayRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayRouteTableIds;
        }

        public final void setTransitGatewayRouteTableIds(Collection<String> transitGatewayRouteTableIds) {
            this.transitGatewayRouteTableIds = TransitGatewayRouteTableIdStringListCopier.copy(transitGatewayRouteTableIds);
        }

        @Override
        @Transient
        public final Builder transitGatewayRouteTableIds(Collection<String> transitGatewayRouteTableIds) {
            this.transitGatewayRouteTableIds = TransitGatewayRouteTableIdStringListCopier.copy(transitGatewayRouteTableIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayRouteTableIds(String... transitGatewayRouteTableIds) {
            transitGatewayRouteTableIds(Arrays.asList(transitGatewayRouteTableIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTransitGatewayRouteTablesRequest build() {
            return new DescribeTransitGatewayRouteTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
