/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyPairsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeKeyPairsRequest.Builder, DescribeKeyPairsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeKeyPairsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> KEY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KeyNames")
            .getter(getter(DescribeKeyPairsRequest::keyNames))
            .setter(setter(Builder::keyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("KeyName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("KeyName").unmarshallLocationName("KeyName").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> KEY_PAIR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KeyPairIds")
            .getter(getter(DescribeKeyPairsRequest::keyPairIds))
            .setter(setter(Builder::keyPairIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId")
                    .unmarshallLocationName("KeyPairId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("KeyPairId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("KeyPairId").unmarshallLocationName("KeyPairId").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            KEY_NAMES_FIELD, KEY_PAIR_IDS_FIELD));

    private final List<Filter> filters;

    private final List<String> keyNames;

    private final List<String> keyPairIds;

    private DescribeKeyPairsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.keyNames = builder.keyNames;
        this.keyPairIds = builder.keyPairIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>key-pair-id</code> - The ID of the key pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fingerprint</code> - The fingerprint of the key pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key-name</code> - The name of the key pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>key-pair-id</code> - The ID of the key pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fingerprint</code> - The fingerprint of the key pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key-name</code> - The name of the key pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeyNames() {
        return keyNames != null && !(keyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key pair names.
     * </p>
     * <p>
     * Default: Describes all of your key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyNames} method.
     * </p>
     * 
     * @return The key pair names.</p>
     *         <p>
     *         Default: Describes all of your key pairs.
     */
    public final List<String> keyNames() {
        return keyNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPairIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeyPairIds() {
        return keyPairIds != null && !(keyPairIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPairIds} method.
     * </p>
     * 
     * @return The IDs of the key pairs.
     */
    public final List<String> keyPairIds() {
        return keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyNames() ? keyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyPairIds() ? keyPairIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasKeyNames() == other.hasKeyNames() && Objects.equals(keyNames(), other.keyNames())
                && hasKeyPairIds() == other.hasKeyPairIds() && Objects.equals(keyPairIds(), other.keyPairIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeKeyPairsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("KeyNames", hasKeyNames() ? keyNames() : null).add("KeyPairIds", hasKeyPairIds() ? keyPairIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "KeyNames":
            return Optional.ofNullable(clazz.cast(keyNames()));
        case "KeyPairIds":
            return Optional.ofNullable(clazz.cast(keyPairIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsRequest, T> g) {
        return obj -> g.apply((DescribeKeyPairsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeKeyPairsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key-pair-id</code> - The ID of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key-pair-id</code> - The ID of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fingerprint</code> - The fingerprint of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key-pair-id</code> - The ID of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key-pair-id</code> - The ID of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fingerprint</code> - The fingerprint of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key-pair-id</code> - The ID of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<Filter>.Builder} avoiding the need
         * to create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The key pair names.
         * </p>
         * <p>
         * Default: Describes all of your key pairs.
         * </p>
         * 
         * @param keyNames
         *        The key pair names.</p>
         *        <p>
         *        Default: Describes all of your key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyNames(Collection<String> keyNames);

        /**
         * <p>
         * The key pair names.
         * </p>
         * <p>
         * Default: Describes all of your key pairs.
         * </p>
         * 
         * @param keyNames
         *        The key pair names.</p>
         *        <p>
         *        Default: Describes all of your key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyNames(String... keyNames);

        /**
         * <p>
         * The IDs of the key pairs.
         * </p>
         * 
         * @param keyPairIds
         *        The IDs of the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(Collection<String> keyPairIds);

        /**
         * <p>
         * The IDs of the key pairs.
         * </p>
         * 
         * @param keyPairIds
         *        The IDs of the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(String... keyPairIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyPairIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsRequest model) {
            super(model);
            filters(model.filters);
            keyNames(model.keyNames);
            keyPairIds(model.keyPairIds);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getKeyNames() {
            if (keyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return keyNames;
        }

        public final void setKeyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
        }

        @Override
        public final Builder keyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyNames(String... keyNames) {
            keyNames(Arrays.asList(keyNames));
            return this;
        }

        public final Collection<String> getKeyPairIds() {
            if (keyPairIds instanceof SdkAutoConstructList) {
                return null;
            }
            return keyPairIds;
        }

        public final void setKeyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
        }

        @Override
        public final Builder keyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairIds(String... keyPairIds) {
            keyPairIds(Arrays.asList(keyPairIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeKeyPairsRequest build() {
            return new DescribeKeyPairsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
