/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstanceEventWindowResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteInstanceEventWindowResponse.Builder, DeleteInstanceEventWindowResponse> {
    private static final SdkField<InstanceEventWindowStateChange> INSTANCE_EVENT_WINDOW_STATE_FIELD = SdkField
            .<InstanceEventWindowStateChange> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceEventWindowState")
            .getter(getter(DeleteInstanceEventWindowResponse::instanceEventWindowState))
            .setter(setter(Builder::instanceEventWindowState))
            .constructor(InstanceEventWindowStateChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowState")
                    .unmarshallLocationName("instanceEventWindowState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_EVENT_WINDOW_STATE_FIELD));

    private final InstanceEventWindowStateChange instanceEventWindowState;

    private DeleteInstanceEventWindowResponse(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindowState = builder.instanceEventWindowState;
    }

    /**
     * <p>
     * The state of the event window.
     * </p>
     * 
     * @return The state of the event window.
     */
    public final InstanceEventWindowStateChange instanceEventWindowState() {
        return instanceEventWindowState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindowState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceEventWindowResponse)) {
            return false;
        }
        DeleteInstanceEventWindowResponse other = (DeleteInstanceEventWindowResponse) obj;
        return Objects.equals(instanceEventWindowState(), other.instanceEventWindowState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInstanceEventWindowResponse").add("InstanceEventWindowState", instanceEventWindowState())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventWindowState":
            return Optional.ofNullable(clazz.cast(instanceEventWindowState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceEventWindowResponse, T> g) {
        return obj -> g.apply((DeleteInstanceEventWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInstanceEventWindowResponse> {
        /**
         * <p>
         * The state of the event window.
         * </p>
         * 
         * @param instanceEventWindowState
         *        The state of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindowState(InstanceEventWindowStateChange instanceEventWindowState);

        /**
         * <p>
         * The state of the event window.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceEventWindowStateChange.Builder}
         * avoiding the need to create one manually via {@link InstanceEventWindowStateChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceEventWindowStateChange.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceEventWindowState(InstanceEventWindowStateChange)}.
         * 
         * @param instanceEventWindowState
         *        a consumer that will call methods on {@link InstanceEventWindowStateChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceEventWindowState(InstanceEventWindowStateChange)
         */
        default Builder instanceEventWindowState(Consumer<InstanceEventWindowStateChange.Builder> instanceEventWindowState) {
            return instanceEventWindowState(InstanceEventWindowStateChange.builder().applyMutation(instanceEventWindowState)
                    .build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceEventWindowStateChange instanceEventWindowState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceEventWindowResponse model) {
            super(model);
            instanceEventWindowState(model.instanceEventWindowState);
        }

        public final InstanceEventWindowStateChange.Builder getInstanceEventWindowState() {
            return instanceEventWindowState != null ? instanceEventWindowState.toBuilder() : null;
        }

        public final void setInstanceEventWindowState(InstanceEventWindowStateChange.BuilderImpl instanceEventWindowState) {
            this.instanceEventWindowState = instanceEventWindowState != null ? instanceEventWindowState.build() : null;
        }

        @Override
        public final Builder instanceEventWindowState(InstanceEventWindowStateChange instanceEventWindowState) {
            this.instanceEventWindowState = instanceEventWindowState;
            return this;
        }

        @Override
        public DeleteInstanceEventWindowResponse build() {
            return new DeleteInstanceEventWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
