/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InstanceIpv6PrefixListCopier {
    static List<InstanceIpv6Prefix> copy(Collection<? extends InstanceIpv6Prefix> instanceIpv6PrefixListParam) {
        List<InstanceIpv6Prefix> list;
        if (instanceIpv6PrefixListParam == null || instanceIpv6PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Prefix> modifiableList = new ArrayList<>();
            instanceIpv6PrefixListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InstanceIpv6Prefix> copyFromBuilder(Collection<? extends InstanceIpv6Prefix.Builder> instanceIpv6PrefixListParam) {
        List<InstanceIpv6Prefix> list;
        if (instanceIpv6PrefixListParam == null || instanceIpv6PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Prefix> modifiableList = new ArrayList<>();
            instanceIpv6PrefixListParam.forEach(entry -> {
                InstanceIpv6Prefix member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InstanceIpv6Prefix.Builder> copyToBuilder(Collection<? extends InstanceIpv6Prefix> instanceIpv6PrefixListParam) {
        List<InstanceIpv6Prefix.Builder> list;
        if (instanceIpv6PrefixListParam == null || instanceIpv6PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Prefix.Builder> modifiableList = new ArrayList<>();
            instanceIpv6PrefixListParam.forEach(entry -> {
                InstanceIpv6Prefix.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
