/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an authorization rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationRule.Builder, AuthorizationRule> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(AuthorizationRule::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("clientVpnEndpointId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(AuthorizationRule::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(AuthorizationRule::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<Boolean> ACCESS_ALL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccessAll")
            .getter(getter(AuthorizationRule::accessAll))
            .setter(setter(Builder::accessAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessAll")
                    .unmarshallLocationName("accessAll").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidr")
            .getter(getter(AuthorizationRule::destinationCidr))
            .setter(setter(Builder::destinationCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr")
                    .unmarshallLocationName("destinationCidr").build()).build();

    private static final SdkField<ClientVpnAuthorizationRuleStatus> STATUS_FIELD = SdkField
            .<ClientVpnAuthorizationRuleStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(AuthorizationRule::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnAuthorizationRuleStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            DESCRIPTION_FIELD, GROUP_ID_FIELD, ACCESS_ALL_FIELD, DESTINATION_CIDR_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientVpnEndpointId;

    private final String description;

    private final String groupId;

    private final Boolean accessAll;

    private final String destinationCidr;

    private final ClientVpnAuthorizationRuleStatus status;

    private AuthorizationRule(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.accessAll = builder.accessAll;
        this.destinationCidr = builder.destinationCidr;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * A brief description of the authorization rule.
     * </p>
     * 
     * @return A brief description of the authorization rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Active Directory group to which the authorization rule grants access.
     * </p>
     * 
     * @return The ID of the Active Directory group to which the authorization rule grants access.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Indicates whether the authorization rule grants access to all clients.
     * </p>
     * 
     * @return Indicates whether the authorization rule grants access to all clients.
     */
    public final Boolean accessAll() {
        return accessAll;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    public final String destinationCidr() {
        return destinationCidr;
    }

    /**
     * <p>
     * The current state of the authorization rule.
     * </p>
     * 
     * @return The current state of the authorization rule.
     */
    public final ClientVpnAuthorizationRuleStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(accessAll());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationRule)) {
            return false;
        }
        AuthorizationRule other = (AuthorizationRule) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(description(), other.description()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(accessAll(), other.accessAll()) && Objects.equals(destinationCidr(), other.destinationCidr())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationRule").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("Description", description()).add("GroupId", groupId()).add("AccessAll", accessAll())
                .add("DestinationCidr", destinationCidr()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "AccessAll":
            return Optional.ofNullable(clazz.cast(accessAll()));
        case "DestinationCidr":
            return Optional.ofNullable(clazz.cast(destinationCidr()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationRule, T> g) {
        return obj -> g.apply((AuthorizationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationRule> {
        /**
         * <p>
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint with which the authorization rule is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * A brief description of the authorization rule.
         * </p>
         * 
         * @param description
         *        A brief description of the authorization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Active Directory group to which the authorization rule grants access.
         * </p>
         * 
         * @param groupId
         *        The ID of the Active Directory group to which the authorization rule grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Indicates whether the authorization rule grants access to all clients.
         * </p>
         * 
         * @param accessAll
         *        Indicates whether the authorization rule grants access to all clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessAll(Boolean accessAll);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
         * </p>
         * 
         * @param destinationCidr
         *        The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidr(String destinationCidr);

        /**
         * <p>
         * The current state of the authorization rule.
         * </p>
         * 
         * @param status
         *        The current state of the authorization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnAuthorizationRuleStatus status);

        /**
         * <p>
         * The current state of the authorization rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientVpnAuthorizationRuleStatus.Builder}
         * avoiding the need to create one manually via {@link ClientVpnAuthorizationRuleStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnAuthorizationRuleStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ClientVpnAuthorizationRuleStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnAuthorizationRuleStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnAuthorizationRuleStatus)
         */
        default Builder status(Consumer<ClientVpnAuthorizationRuleStatus.Builder> status) {
            return status(ClientVpnAuthorizationRuleStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String description;

        private String groupId;

        private Boolean accessAll;

        private String destinationCidr;

        private ClientVpnAuthorizationRuleStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationRule model) {
            clientVpnEndpointId(model.clientVpnEndpointId);
            description(model.description);
            groupId(model.groupId);
            accessAll(model.accessAll);
            destinationCidr(model.destinationCidr);
            status(model.status);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Boolean getAccessAll() {
            return accessAll;
        }

        public final void setAccessAll(Boolean accessAll) {
            this.accessAll = accessAll;
        }

        @Override
        public final Builder accessAll(Boolean accessAll) {
            this.accessAll = accessAll;
            return this;
        }

        public final String getDestinationCidr() {
            return destinationCidr;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final ClientVpnAuthorizationRuleStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnAuthorizationRuleStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClientVpnAuthorizationRuleStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public AuthorizationRule build() {
            return new AuthorizationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
