/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathStatementRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PathStatementRequest.Builder, PathStatementRequest> {
    private static final SdkField<PacketHeaderStatementRequest> PACKET_HEADER_STATEMENT_FIELD = SdkField
            .<PacketHeaderStatementRequest> builder(MarshallingType.SDK_POJO)
            .memberName("PacketHeaderStatement")
            .getter(getter(PathStatementRequest::packetHeaderStatement))
            .setter(setter(Builder::packetHeaderStatement))
            .constructor(PacketHeaderStatementRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketHeaderStatement")
                    .unmarshallLocationName("PacketHeaderStatement").build()).build();

    private static final SdkField<ResourceStatementRequest> RESOURCE_STATEMENT_FIELD = SdkField
            .<ResourceStatementRequest> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceStatement")
            .getter(getter(PathStatementRequest::resourceStatement))
            .setter(setter(Builder::resourceStatement))
            .constructor(ResourceStatementRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatement")
                    .unmarshallLocationName("ResourceStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKET_HEADER_STATEMENT_FIELD,
            RESOURCE_STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final PacketHeaderStatementRequest packetHeaderStatement;

    private final ResourceStatementRequest resourceStatement;

    private PathStatementRequest(BuilderImpl builder) {
        this.packetHeaderStatement = builder.packetHeaderStatement;
        this.resourceStatement = builder.resourceStatement;
    }

    /**
     * <p>
     * The packet header statement.
     * </p>
     * 
     * @return The packet header statement.
     */
    public final PacketHeaderStatementRequest packetHeaderStatement() {
        return packetHeaderStatement;
    }

    /**
     * <p>
     * The resource statement.
     * </p>
     * 
     * @return The resource statement.
     */
    public final ResourceStatementRequest resourceStatement() {
        return resourceStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packetHeaderStatement());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathStatementRequest)) {
            return false;
        }
        PathStatementRequest other = (PathStatementRequest) obj;
        return Objects.equals(packetHeaderStatement(), other.packetHeaderStatement())
                && Objects.equals(resourceStatement(), other.resourceStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathStatementRequest").add("PacketHeaderStatement", packetHeaderStatement())
                .add("ResourceStatement", resourceStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PacketHeaderStatement":
            return Optional.ofNullable(clazz.cast(packetHeaderStatement()));
        case "ResourceStatement":
            return Optional.ofNullable(clazz.cast(resourceStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathStatementRequest, T> g) {
        return obj -> g.apply((PathStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathStatementRequest> {
        /**
         * <p>
         * The packet header statement.
         * </p>
         * 
         * @param packetHeaderStatement
         *        The packet header statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetHeaderStatement(PacketHeaderStatementRequest packetHeaderStatement);

        /**
         * <p>
         * The packet header statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link PacketHeaderStatementRequest.Builder}
         * avoiding the need to create one manually via {@link PacketHeaderStatementRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PacketHeaderStatementRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #packetHeaderStatement(PacketHeaderStatementRequest)}.
         * 
         * @param packetHeaderStatement
         *        a consumer that will call methods on {@link PacketHeaderStatementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packetHeaderStatement(PacketHeaderStatementRequest)
         */
        default Builder packetHeaderStatement(Consumer<PacketHeaderStatementRequest.Builder> packetHeaderStatement) {
            return packetHeaderStatement(PacketHeaderStatementRequest.builder().applyMutation(packetHeaderStatement).build());
        }

        /**
         * <p>
         * The resource statement.
         * </p>
         * 
         * @param resourceStatement
         *        The resource statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatement(ResourceStatementRequest resourceStatement);

        /**
         * <p>
         * The resource statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatementRequest.Builder}
         * avoiding the need to create one manually via {@link ResourceStatementRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceStatementRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceStatement(ResourceStatementRequest)}.
         * 
         * @param resourceStatement
         *        a consumer that will call methods on {@link ResourceStatementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceStatement(ResourceStatementRequest)
         */
        default Builder resourceStatement(Consumer<ResourceStatementRequest.Builder> resourceStatement) {
            return resourceStatement(ResourceStatementRequest.builder().applyMutation(resourceStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PacketHeaderStatementRequest packetHeaderStatement;

        private ResourceStatementRequest resourceStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(PathStatementRequest model) {
            packetHeaderStatement(model.packetHeaderStatement);
            resourceStatement(model.resourceStatement);
        }

        public final PacketHeaderStatementRequest.Builder getPacketHeaderStatement() {
            return packetHeaderStatement != null ? packetHeaderStatement.toBuilder() : null;
        }

        public final void setPacketHeaderStatement(PacketHeaderStatementRequest.BuilderImpl packetHeaderStatement) {
            this.packetHeaderStatement = packetHeaderStatement != null ? packetHeaderStatement.build() : null;
        }

        @Override
        public final Builder packetHeaderStatement(PacketHeaderStatementRequest packetHeaderStatement) {
            this.packetHeaderStatement = packetHeaderStatement;
            return this;
        }

        public final ResourceStatementRequest.Builder getResourceStatement() {
            return resourceStatement != null ? resourceStatement.toBuilder() : null;
        }

        public final void setResourceStatement(ResourceStatementRequest.BuilderImpl resourceStatement) {
            this.resourceStatement = resourceStatement != null ? resourceStatement.build() : null;
        }

        @Override
        public final Builder resourceStatement(ResourceStatementRequest resourceStatement) {
            this.resourceStatement = resourceStatement;
            return this;
        }

        @Override
        public PathStatementRequest build() {
            return new PathStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
