/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageRequest;
import software.amazon.awssdk.services.ec2.model.ExportImageResponse;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributePublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClassicLinkInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnAuthorizationRulesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnEndpointsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnRoutesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnTargetNetworksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCoipPoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeDhcpOptionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeEgressOnlyInternetGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeExportImageTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFastLaunchImagesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFastSnapshotRestoresPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFleetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFlowLogsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFpgaImagesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIamInstanceProfileAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportImageTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportSnapshotTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceCreditSpecificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceEventWindowsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceStatusPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypeOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInternetGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamPoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamScopesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpv6PoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplateVersionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplatesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVpcAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfaceGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfacesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeManagedPrefixListsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeMovingAddressesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNatGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkAclsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAccessScopeAnalysesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAccessScopesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAnalysesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsPathsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacePermissionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePrefixListsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePrincipalIdFormatPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePublicIpv4PoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeReplaceRootVolumeTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesModificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstanceAvailabilityPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupRulesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotTierStatusPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotFleetRequestsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotInstanceRequestsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotPriceHistoryPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeStaleSecurityGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeStoreImageTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSubnetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorFiltersPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorSessionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorTargetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayConnectPeersPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayConnectsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayMulticastDomainsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayPeeringAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayVpcAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrunkInterfaceAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumeStatusPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesModificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcClassicLinkDnsSupportPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionNotificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServiceConfigurationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServicePermissionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcPeeringConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetAssociatedIpv6PoolCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetGroupsForCapacityReservationPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetInstanceTypesFromInstanceRequirementsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetIpamAddressHistoryPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetIpamPoolAllocationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetIpamPoolCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetIpamResourceCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetManagedPrefixListAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetManagedPrefixListEntriesPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetSpotPlacementScoresPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayAttachmentPropagationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayMulticastDomainAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayPrefixListReferencesPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTableAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTablePropagationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetVpnConnectionDeviceTypesPublisher;
import software.amazon.awssdk.services.ec2.paginators.ListImagesInRecycleBinPublisher;
import software.amazon.awssdk.services.ec2.paginators.ListSnapshotsInRecycleBinPublisher;
import software.amazon.awssdk.services.ec2.paginators.SearchLocalGatewayRoutesPublisher;
import software.amazon.awssdk.services.ec2.paginators.SearchTransitGatewayMulticastGroupsPublisher;
import software.amazon.awssdk.services.ec2.waiters.Ec2AsyncWaiter;

/**
 * Service client for accessing Amazon EC2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 * <p>
 * Amazon Elastic Compute Cloud (Amazon EC2) provides secure and resizable computing capacity in the Amazon Web Services
 * Cloud. Using Amazon EC2 eliminates the need to invest in hardware up front, so you can develop and deploy
 * applications faster. Amazon Virtual Private Cloud (Amazon VPC) enables you to provision a logically isolated section
 * of the Amazon Web Services Cloud where you can launch Amazon Web Services resources in a virtual network that you've
 * defined. Amazon Elastic Block Store (Amazon EBS) provides block level storage volumes for use with EC2 instances. EBS
 * volumes are highly available and reliable storage volumes that can be attached to any running instance and used like
 * a hard drive.
 * </p>
 * <p>
 * To learn more, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon EC2: <a href="http://aws.amazon.com/ec2">AmazonEC2 product page</a>, <a
 * href="http://aws.amazon.com/documentation/ec2">Amazon EC2 documentation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon EBS: <a href="http://aws.amazon.com/ebs">Amazon EBS product page</a>, <a
 * href="http://aws.amazon.com/documentation/ebs">Amazon EBS documentation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon VPC: <a href="http://aws.amazon.com/vpc">Amazon VPC product page</a>, <a
 * href="http://aws.amazon.com/documentation/vpc">Amazon VPC documentation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon Web Services VPN: <a href="http://aws.amazon.com/vpn">Amazon Web Services VPN product page</a>, <a
 * href="http://aws.amazon.com/documentation/vpn">Amazon Web Services VPN documentation</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Ec2AsyncClient extends SdkClient {
    String SERVICE_NAME = "ec2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ec2";

    /**
     * Create a {@link Ec2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Ec2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Ec2AsyncClient}.
     */
    static Ec2AsyncClientBuilder builder() {
        return new DefaultEc2AsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptReservedInstancesExchangeQuoteRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptReservedInstancesExchangeQuoteRequest#builder()}
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        A {@link Consumer} that will call methods on {@link AcceptReservedInstancesExchangeQuoteRequest.Builder}
     *        to create a request. Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> acceptReservedInstancesExchangeQuote(
            Consumer<AcceptReservedInstancesExchangeQuoteRequest.Builder> acceptReservedInstancesExchangeQuoteRequest) {
        return acceptReservedInstancesExchangeQuote(AcceptReservedInstancesExchangeQuoteRequest.builder()
                .applyMutation(acceptReservedInstancesExchangeQuoteRequest).build());
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayMulticastDomainAssociations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayMulticastDomainAssociationsResponse> acceptTransitGatewayMulticastDomainAssociations(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder} avoiding the need to create one manually
     * via {@link AcceptTransitGatewayMulticastDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptTransitGatewayMulticastDomainAssociations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayMulticastDomainAssociationsResponse> acceptTransitGatewayMulticastDomainAssociations(
            Consumer<AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder> acceptTransitGatewayMulticastDomainAssociationsRequest) {
        return acceptTransitGatewayMulticastDomainAssociations(AcceptTransitGatewayMulticastDomainAssociationsRequest.builder()
                .applyMutation(acceptTransitGatewayMulticastDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> acceptTransitGatewayPeeringAttachment(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link AcceptTransitGatewayPeeringAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> acceptTransitGatewayPeeringAttachment(
            Consumer<AcceptTransitGatewayPeeringAttachmentRequest.Builder> acceptTransitGatewayPeeringAttachmentRequest) {
        return acceptTransitGatewayPeeringAttachment(AcceptTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(acceptTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> acceptTransitGatewayVpcAttachment(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link AcceptTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> acceptTransitGatewayVpcAttachment(
            Consumer<AcceptTransitGatewayVpcAttachmentRequest.Builder> acceptTransitGatewayVpcAttachmentRequest) {
        return acceptTransitGatewayVpcAttachment(AcceptTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(acceptTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptVpcEndpointConnectionsResponse> acceptVpcEndpointConnections(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptVpcEndpointConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptVpcEndpointConnectionsRequest#builder()}
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link AcceptVpcEndpointConnectionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptVpcEndpointConnectionsResponse> acceptVpcEndpointConnections(
            Consumer<AcceptVpcEndpointConnectionsRequest.Builder> acceptVpcEndpointConnectionsRequest) {
        return acceptVpcEndpointConnections(AcceptVpcEndpointConnectionsRequest.builder()
                .applyMutation(acceptVpcEndpointConnectionsRequest).build());
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptVpcPeeringConnectionResponse> acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on {@link AcceptVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptVpcPeeringConnectionResponse> acceptVpcPeeringConnection(
            Consumer<AcceptVpcPeeringConnectionRequest.Builder> acceptVpcPeeringConnectionRequest) {
        return acceptVpcPeeringConnection(AcceptVpcPeeringConnectionRequest.builder()
                .applyMutation(acceptVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdvertiseByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AdvertiseByoipCidrRequest#builder()}
     * </p>
     *
     * @param advertiseByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link AdvertiseByoipCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(
            Consumer<AdvertiseByoipCidrRequest.Builder> advertiseByoipCidrRequest) {
        return advertiseByoipCidr(AdvertiseByoipCidrRequest.builder().applyMutation(advertiseByoipCidrRequest).build());
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP
     * address that you released after it is allocated to another Amazon Web Services account. You cannot recover an
     * Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in
     * this operation.
     * </p>
     * <p>
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5
     * Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @param allocateAddressRequest
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateAddressResponse> allocateAddress(AllocateAddressRequest allocateAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP
     * address that you released after it is allocated to another Amazon Web Services account. You cannot recover an
     * Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in
     * this operation.
     * </p>
     * <p>
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5
     * Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateAddressRequest.Builder} avoiding the need
     * to create one manually via {@link AllocateAddressRequest#builder()}
     * </p>
     *
     * @param allocateAddressRequest
     *        A {@link Consumer} that will call methods on {@link AllocateAddressRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateAddressResponse> allocateAddress(
            Consumer<AllocateAddressRequest.Builder> allocateAddressRequest) {
        return allocateAddress(AllocateAddressRequest.builder().applyMutation(allocateAddressRequest).build());
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP
     * address that you released after it is allocated to another Amazon Web Services account. You cannot recover an
     * Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in
     * this operation.
     * </p>
     * <p>
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5
     * Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateAddressResponse> allocateAddress() {
        return allocateAddress(AllocateAddressRequest.builder().build());
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateHostsResponse> allocateHosts(AllocateHostsRequest allocateHostsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateHostsRequest.Builder} avoiding the need to
     * create one manually via {@link AllocateHostsRequest#builder()}
     * </p>
     *
     * @param allocateHostsRequest
     *        A {@link Consumer} that will call methods on {@link AllocateHostsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateHostsResponse> allocateHosts(Consumer<AllocateHostsRequest.Builder> allocateHostsRequest) {
        return allocateHosts(AllocateHostsRequest.builder().applyMutation(allocateHostsRequest).build());
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another
     * resource or IPAM pool. For more information, see <a href="/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param allocateIpamPoolCidrRequest
     * @return A Java Future containing the result of the AllocateIpamPoolCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateIpamPoolCidrResponse> allocateIpamPoolCidr(
            AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another
     * resource or IPAM pool. For more information, see <a href="/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateIpamPoolCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AllocateIpamPoolCidrRequest#builder()}
     * </p>
     *
     * @param allocateIpamPoolCidrRequest
     *        A {@link Consumer} that will call methods on {@link AllocateIpamPoolCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AllocateIpamPoolCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllocateIpamPoolCidrResponse> allocateIpamPoolCidr(
            Consumer<AllocateIpamPoolCidrRequest.Builder> allocateIpamPoolCidrRequest) {
        return allocateIpamPoolCidr(AllocateIpamPoolCidrRequest.builder().applyMutation(allocateIpamPoolCidrRequest).build());
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> applySecurityGroupsToClientVpnTargetNetwork(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder} avoiding the need to create one manually via
     * {@link ApplySecurityGroupsToClientVpnTargetNetworkRequest#builder()}
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> applySecurityGroupsToClientVpnTargetNetwork(
            Consumer<ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder> applySecurityGroupsToClientVpnTargetNetworkRequest) {
        return applySecurityGroupsToClientVpnTargetNetwork(ApplySecurityGroupsToClientVpnTargetNetworkRequest.builder()
                .applyMutation(applySecurityGroupsToClientVpnTargetNetworkRequest).build());
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssignIpv6AddressesResponse> assignIpv6Addresses(
            AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignIpv6AddressesRequest.Builder} avoiding the
     * need to create one manually via {@link AssignIpv6AddressesRequest#builder()}
     * </p>
     *
     * @param assignIpv6AddressesRequest
     *        A {@link Consumer} that will call methods on {@link AssignIpv6AddressesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssignIpv6AddressesResponse> assignIpv6Addresses(
            Consumer<AssignIpv6AddressesRequest.Builder> assignIpv6AddressesRequest) {
        return assignIpv6Addresses(AssignIpv6AddressesRequest.builder().applyMutation(assignIpv6AddressesRequest).build());
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssignPrivateIpAddressesResponse> assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignPrivateIpAddressesRequest.Builder} avoiding
     * the need to create one manually via {@link AssignPrivateIpAddressesRequest#builder()}
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        A {@link Consumer} that will call methods on {@link AssignPrivateIpAddressesRequest.Builder} to create a
     *        request. Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssignPrivateIpAddressesResponse> assignPrivateIpAddresses(
            Consumer<AssignPrivateIpAddressesRequest.Builder> assignPrivateIpAddressesRequest) {
        return assignPrivateIpAddresses(AssignPrivateIpAddressesRequest.builder().applyMutation(assignPrivateIpAddressesRequest)
                .build());
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different
     * instance, it is disassociated from that instance and associated with the specified instance. If you associate an
     * Elastic IP address with an instance that has an existing Elastic IP address, the existing address is
     * disassociated from the instance, but remains allocated to your account.
     * </p>
     * <p>
     * [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated
     * with the primary IP address. If the Elastic IP address is already associated with a different instance or a
     * network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address
     * with an instance or network interface that has an existing Elastic IP address.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAddressResponse> associateAddress(AssociateAddressRequest associateAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different
     * instance, it is disassociated from that instance and associated with the specified instance. If you associate an
     * Elastic IP address with an instance that has an existing Elastic IP address, the existing address is
     * disassociated from the instance, but remains allocated to your account.
     * </p>
     * <p>
     * [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated
     * with the primary IP address. If the Elastic IP address is already associated with a different instance or a
     * network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address
     * with an instance or network interface that has an existing Elastic IP address.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAddressRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAddressRequest#builder()}
     * </p>
     *
     * @param associateAddressRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAddressRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAddressResponse> associateAddress(
            Consumer<AssociateAddressRequest.Builder> associateAddressRequest) {
        return associateAddress(AssociateAddressRequest.builder().applyMutation(associateAddressRequest).build());
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different
     * instance, it is disassociated from that instance and associated with the specified instance. If you associate an
     * Elastic IP address with an instance that has an existing Elastic IP address, the existing address is
     * disassociated from the instance, but remains allocated to your account.
     * </p>
     * <p>
     * [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated
     * with the primary IP address. If the Elastic IP address is already associated with a different instance or a
     * network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address
     * with an instance or network interface that has an existing Elastic IP address.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAddressResponse> associateAddress() {
        return associateAddress(AssociateAddressRequest.builder().build());
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateClientVpnTargetNetworkResponse> associateClientVpnTargetNetwork(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateClientVpnTargetNetworkRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateClientVpnTargetNetworkRequest#builder()}
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     *        A {@link Consumer} that will call methods on {@link AssociateClientVpnTargetNetworkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateClientVpnTargetNetworkResponse> associateClientVpnTargetNetwork(
            Consumer<AssociateClientVpnTargetNetworkRequest.Builder> associateClientVpnTargetNetworkRequest) {
        return associateClientVpnTargetNetwork(AssociateClientVpnTargetNetworkRequest.builder()
                .applyMutation(associateClientVpnTargetNetworkRequest).build());
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDhcpOptionsResponse> associateDhcpOptions(
            AssociateDhcpOptionsRequest associateDhcpOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDhcpOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param associateDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDhcpOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDhcpOptionsResponse> associateDhcpOptions(
            Consumer<AssociateDhcpOptionsRequest.Builder> associateDhcpOptionsRequest) {
        return associateDhcpOptions(AssociateDhcpOptionsRequest.builder().applyMutation(associateDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     * @return A Java Future containing the result of the AssociateEnclaveCertificateIamRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnclaveCertificateIamRoleResponse> associateEnclaveCertificateIamRole(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnclaveCertificateIamRoleRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEnclaveCertificateIamRoleRequest#builder()}
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEnclaveCertificateIamRoleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateEnclaveCertificateIamRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnclaveCertificateIamRoleResponse> associateEnclaveCertificateIamRole(
            Consumer<AssociateEnclaveCertificateIamRoleRequest.Builder> associateEnclaveCertificateIamRoleRequest) {
        return associateEnclaveCertificateIamRole(AssociateEnclaveCertificateIamRoleRequest.builder()
                .applyMutation(associateEnclaveCertificateIamRoleRequest).build());
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateIamInstanceProfileResponse> associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIamInstanceProfileRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateIamInstanceProfileRequest#builder()}
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link AssociateIamInstanceProfileRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateIamInstanceProfileResponse> associateIamInstanceProfile(
            Consumer<AssociateIamInstanceProfileRequest.Builder> associateIamInstanceProfileRequest) {
        return associateIamInstanceProfile(AssociateIamInstanceProfileRequest.builder()
                .applyMutation(associateIamInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     * @return A Java Future containing the result of the AssociateInstanceEventWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateInstanceEventWindowResponse> associateInstanceEventWindow(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateInstanceEventWindowRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on {@link AssociateInstanceEventWindowRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateInstanceEventWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateInstanceEventWindowResponse> associateInstanceEventWindow(
            Consumer<AssociateInstanceEventWindowRequest.Builder> associateInstanceEventWindowRequest) {
        return associateInstanceEventWindow(AssociateInstanceEventWindowRequest.builder()
                .applyMutation(associateInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateRouteTableResponse> associateRouteTable(
            AssociateRouteTableRequest associateRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRouteTableRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateRouteTableRequest#builder()}
     * </p>
     *
     * @param associateRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link AssociateRouteTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateRouteTableResponse> associateRouteTable(
            Consumer<AssociateRouteTableRequest.Builder> associateRouteTableRequest) {
        return associateRouteTable(AssociateRouteTableRequest.builder().applyMutation(associateRouteTableRequest).build());
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An
     * IPv6 CIDR block must have a prefix length of /64.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSubnetCidrBlockResponse> associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An
     * IPv6 CIDR block must have a prefix length of /64.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSubnetCidrBlockRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSubnetCidrBlockRequest#builder()}
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSubnetCidrBlockRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSubnetCidrBlockResponse> associateSubnetCidrBlock(
            Consumer<AssociateSubnetCidrBlockRequest.Builder> associateSubnetCidrBlockRequest) {
        return associateSubnetCidrBlock(AssociateSubnetCidrBlockRequest.builder().applyMutation(associateSubnetCidrBlockRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> associateTransitGatewayMulticastDomain(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateTransitGatewayMulticastDomainRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTransitGatewayMulticastDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> associateTransitGatewayMulticastDomain(
            Consumer<AssociateTransitGatewayMulticastDomainRequest.Builder> associateTransitGatewayMulticastDomainRequest) {
        return associateTransitGatewayMulticastDomain(AssociateTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(associateTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayRouteTableResponse> associateTransitGatewayRouteTable(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTransitGatewayRouteTableRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTransitGatewayRouteTableResponse> associateTransitGatewayRouteTable(
            Consumer<AssociateTransitGatewayRouteTableRequest.Builder> associateTransitGatewayRouteTableRequest) {
        return associateTransitGatewayRouteTable(AssociateTransitGatewayRouteTableRequest.builder()
                .applyMutation(associateTransitGatewayRouteTableRequest).build());
    }

    /**
     * <note>
     * <p>
     * This API action is currently in <b>limited preview only</b>. If you are interested in using this feature, contact
     * your account manager.
     * </p>
     * </note>
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, run the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also
     * create a network interface for each branch network interface that you want to associate with the trunk network
     * interface.
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     * @return A Java Future containing the result of the AssociateTrunkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateTrunkInterfaceResponse> associateTrunkInterface(
            AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This API action is currently in <b>limited preview only</b>. If you are interested in using this feature, contact
     * your account manager.
     * </p>
     * </note>
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, run the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also
     * create a network interface for each branch network interface that you want to associate with the trunk network
     * interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrunkInterfaceRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrunkInterfaceRequest#builder()}
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTrunkInterfaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateTrunkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateTrunkInterfaceResponse> associateTrunkInterface(
            Consumer<AssociateTrunkInterfaceRequest.Builder> associateTrunkInterfaceRequest) {
        return associateTrunkInterface(AssociateTrunkInterfaceRequest.builder().applyMutation(associateTrunkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>). The IPv6 CIDR
     * block size is fixed at /56.
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateVpcCidrBlockResponse> associateVpcCidrBlock(
            AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>). The IPv6 CIDR
     * block size is fixed at /56.
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVpcCidrBlockRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateVpcCidrBlockRequest#builder()}
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     *        A {@link Consumer} that will call methods on {@link AssociateVpcCidrBlockRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateVpcCidrBlockResponse> associateVpcCidrBlock(
            Consumer<AssociateVpcCidrBlockRequest.Builder> associateVpcCidrBlockRequest) {
        return associateVpcCidrBlock(AssociateVpcCidrBlockRequest.builder().applyMutation(associateVpcCidrBlockRequest).build());
    }

    /**
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachClassicLinkVpcResponse> attachClassicLinkVpc(
            AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachClassicLinkVpcRequest.Builder} avoiding the
     * need to create one manually via {@link AttachClassicLinkVpcRequest#builder()}
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     *        A {@link Consumer} that will call methods on {@link AttachClassicLinkVpcRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachClassicLinkVpcResponse> attachClassicLinkVpc(
            Consumer<AttachClassicLinkVpcRequest.Builder> attachClassicLinkVpcRequest) {
        return attachClassicLinkVpc(AttachClassicLinkVpcRequest.builder().applyMutation(attachClassicLinkVpcRequest).build());
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachInternetGatewayResponse> attachInternetGateway(
            AttachInternetGatewayRequest attachInternetGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link AttachInternetGatewayRequest#builder()}
     * </p>
     *
     * @param attachInternetGatewayRequest
     *        A {@link Consumer} that will call methods on {@link AttachInternetGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachInternetGatewayResponse> attachInternetGateway(
            Consumer<AttachInternetGatewayRequest.Builder> attachInternetGatewayRequest) {
        return attachInternetGateway(AttachInternetGatewayRequest.builder().applyMutation(attachInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachNetworkInterfaceResponse> attachNetworkInterface(
            AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link AttachNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on {@link AttachNetworkInterfaceRequest.Builder} to create a
     *        request. Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachNetworkInterfaceResponse> attachNetworkInterface(
            Consumer<AttachNetworkInterfaceRequest.Builder> attachNetworkInterfaceRequest) {
        return attachNetworkInterface(AttachNetworkInterfaceRequest.builder().applyMutation(attachNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available
     * for use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume
     * to an instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available
     * for use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume
     * to an instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link AttachVolumeRequest#builder()}
     * </p>
     *
     * @param attachVolumeRequest
     *        A {@link Consumer} that will call methods on {@link AttachVolumeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachVolumeResponse> attachVolume(Consumer<AttachVolumeRequest.Builder> attachVolumeRequest) {
        return attachVolume(AttachVolumeRequest.builder().applyMutation(attachVolumeRequest).build());
    }

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachVpnGatewayResponse> attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link AttachVpnGatewayRequest#builder()}
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        A {@link Consumer} that will call methods on {@link AttachVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachVpnGatewayResponse> attachVpnGateway(
            Consumer<AttachVpnGatewayRequest.Builder> attachVpnGatewayRequest) {
        return attachVpnGateway(AttachVpnGatewayRequest.builder().applyMutation(attachVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeClientVpnIngressResponse> authorizeClientVpnIngress(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeClientVpnIngressRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeClientVpnIngressRequest#builder()}
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeClientVpnIngressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeClientVpnIngressResponse> authorizeClientVpnIngress(
            Consumer<AuthorizeClientVpnIngressRequest.Builder> authorizeClientVpnIngressRequest) {
        return authorizeClientVpnIngress(AuthorizeClientVpnIngressRequest.builder()
                .applyMutation(authorizeClientVpnIngressRequest).build());
    }

    /**
     * <p>
     * [VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the
     * instances that are associated with the specified source security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the
     * destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use
     * -1 for the type or code to mean all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * </p>
     * <p>
     * For information about VPC security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSecurityGroupEgressResponse> authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * [VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the
     * instances that are associated with the specified source security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the
     * destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use
     * -1 for the type or code to mean all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * </p>
     * <p>
     * For information about VPC security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSecurityGroupEgressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeSecurityGroupEgressRequest#builder()}
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeSecurityGroupEgressRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSecurityGroupEgressResponse> authorizeSecurityGroupEgress(
            Consumer<AuthorizeSecurityGroupEgressRequest.Builder> authorizeSecurityGroupEgressRequest) {
        return authorizeSecurityGroupEgress(AuthorizeSecurityGroupEgressRequest.builder()
                .applyMutation(authorizeSecurityGroupEgressRequest).build());
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from
     * the instances that are associated with the specified destination security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination
     * port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean
     * all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     * <p>
     * For more information about VPC security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSecurityGroupIngressResponse> authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from
     * the instances that are associated with the specified destination security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination
     * port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean
     * all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     * <p>
     * For more information about VPC security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeSecurityGroupIngressRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSecurityGroupIngressResponse> authorizeSecurityGroupIngress(
            Consumer<AuthorizeSecurityGroupIngressRequest.Builder> authorizeSecurityGroupIngressRequest) {
        return authorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BundleInstanceResponse> bundleInstance(BundleInstanceRequest bundleInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BundleInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link BundleInstanceRequest#builder()}
     * </p>
     *
     * @param bundleInstanceRequest
     *        A {@link Consumer} that will call methods on {@link BundleInstanceRequest.Builder} to create a request.
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BundleInstanceResponse> bundleInstance(Consumer<BundleInstanceRequest.Builder> bundleInstanceRequest) {
        return bundleInstance(BundleInstanceRequest.builder().applyMutation(bundleInstanceRequest).build());
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelBundleTaskResponse> cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBundleTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelBundleTaskRequest#builder()}
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelBundleTaskRequest.Builder} to create a request.
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelBundleTaskResponse> cancelBundleTask(
            Consumer<CancelBundleTaskRequest.Builder> cancelBundleTaskRequest) {
        return cancelBundleTask(CancelBundleTaskRequest.builder().applyMutation(cancelBundleTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelCapacityReservationRequest#builder()}
     * </p>
     *
     * @param cancelCapacityReservationRequest
     *        A {@link Consumer} that will call methods on {@link CancelCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            Consumer<CancelCapacityReservationRequest.Builder> cancelCapacityReservationRequest) {
        return cancelCapacityReservation(CancelCapacityReservationRequest.builder()
                .applyMutation(cancelCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelCapacityReservationFleetsRequest
     * @return A Java Future containing the result of the CancelCapacityReservationFleets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationFleetsResponse> cancelCapacityReservationFleets(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityReservationFleetsRequest.Builder}
     * avoiding the need to create one manually via {@link CancelCapacityReservationFleetsRequest#builder()}
     * </p>
     *
     * @param cancelCapacityReservationFleetsRequest
     *        A {@link Consumer} that will call methods on {@link CancelCapacityReservationFleetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelCapacityReservationFleets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationFleetsResponse> cancelCapacityReservationFleets(
            Consumer<CancelCapacityReservationFleetsRequest.Builder> cancelCapacityReservationFleetsRequest) {
        return cancelCapacityReservationFleets(CancelCapacityReservationFleetsRequest.builder()
                .applyMutation(cancelCapacityReservationFleetsRequest).build());
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     *
     * @param cancelConversionTaskRequest
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelConversionTaskResponse> cancelConversionTask(
            CancelConversionTaskRequest cancelConversionTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelConversionTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CancelConversionTaskRequest#builder()}
     * </p>
     *
     * @param cancelConversionTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelConversionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelConversionTaskResponse> cancelConversionTask(
            Consumer<CancelConversionTaskRequest.Builder> cancelConversionTaskRequest) {
        return cancelConversionTask(CancelConversionTaskRequest.builder().applyMutation(cancelConversionTaskRequest).build());
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportTaskRequest#builder()}
     * </p>
     *
     * @param cancelExportTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelExportTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(
            Consumer<CancelExportTaskRequest.Builder> cancelExportTaskRequest) {
        return cancelExportTask(CancelExportTaskRequest.builder().applyMutation(cancelExportTaskRequest).build());
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelImportTaskRequest#builder()}
     * </p>
     *
     * @param cancelImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelImportTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelImportTaskResponse> cancelImportTask(
            Consumer<CancelImportTaskRequest.Builder> cancelImportTaskRequest) {
        return cancelImportTask(CancelImportTaskRequest.builder().applyMutation(cancelImportTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelReservedInstancesListingResponse> cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReservedInstancesListingRequest.Builder}
     * avoiding the need to create one manually via {@link CancelReservedInstancesListingRequest#builder()}
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        A {@link Consumer} that will call methods on {@link CancelReservedInstancesListingRequest.Builder} to
     *        create a request. Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelReservedInstancesListingResponse> cancelReservedInstancesListing(
            Consumer<CancelReservedInstancesListingRequest.Builder> cancelReservedInstancesListingRequest) {
        return cancelReservedInstancesListing(CancelReservedInstancesListingRequest.builder()
                .applyMutation(cancelReservedInstancesListingRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether
     * the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request
     * enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the
     * <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you
     * terminate them manually.
     * </p>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSpotFleetRequestsResponse> cancelSpotFleetRequests(
            CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether
     * the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request
     * enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the
     * <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you
     * terminate them manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSpotFleetRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSpotFleetRequestsRequest#builder()}
     * </p>
     *
     * @param cancelSpotFleetRequestsRequest
     *        A {@link Consumer} that will call methods on {@link CancelSpotFleetRequestsRequest.Builder} to create a
     *        request. Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSpotFleetRequestsResponse> cancelSpotFleetRequests(
            Consumer<CancelSpotFleetRequestsRequest.Builder> cancelSpotFleetRequestsRequest) {
        return cancelSpotFleetRequests(CancelSpotFleetRequestsRequest.builder().applyMutation(cancelSpotFleetRequestsRequest)
                .build());
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelSpotInstanceRequestsResponse> cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSpotInstanceRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSpotInstanceRequestsRequest#builder()}
     * </p>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        A {@link Consumer} that will call methods on {@link CancelSpotInstanceRequestsRequest.Builder} to create a
     *        request. Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelSpotInstanceRequestsResponse> cancelSpotInstanceRequests(
            Consumer<CancelSpotInstanceRequestsRequest.Builder> cancelSpotInstanceRequestsRequest) {
        return cancelSpotInstanceRequests(CancelSpotInstanceRequestsRequest.builder()
                .applyMutation(cancelSpotInstanceRequestsRequest).build());
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ConfirmProductInstanceResponse> confirmProductInstance(
            ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmProductInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmProductInstanceRequest#builder()}
     * </p>
     *
     * @param confirmProductInstanceRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmProductInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ConfirmProductInstanceResponse> confirmProductInstance(
            Consumer<ConfirmProductInstanceRequest.Builder> confirmProductInstanceRequest) {
        return confirmProductInstance(ConfirmProductInstanceRequest.builder().applyMutation(confirmProductInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyFpgaImageResponse> copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyFpgaImageRequest.Builder} avoiding the need to
     * create one manually via {@link CopyFpgaImageRequest#builder()}
     * </p>
     *
     * @param copyFpgaImageRequest
     *        A {@link Consumer} that will call methods on {@link CopyFpgaImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyFpgaImageResponse> copyFpgaImage(Consumer<CopyFpgaImageRequest.Builder> copyFpgaImageRequest) {
        return copyFpgaImage(CopyFpgaImageRequest.builder().applyMutation(copyFpgaImageRequest).build());
    }

    /**
     * <p>
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You
     * can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy
     * an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and
     * specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are
     * encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code>
     * during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter,
     * and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an
     * Outpost are encrypted by default using the default encryption key for the Region, or a different key that you
     * specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more
     * information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon
     * EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyImageResponse> copyImage(CopyImageRequest copyImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You
     * can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy
     * an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and
     * specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are
     * encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code>
     * during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter,
     * and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an
     * Outpost are encrypted by default using the default encryption key for the Region, or a different key that you
     * specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more
     * information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon
     * EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyImageRequest.Builder} avoiding the need to
     * create one manually via {@link CopyImageRequest#builder()}
     * </p>
     *
     * @param copyImageRequest
     *        A {@link Consumer} that will call methods on {@link CopyImageRequest.Builder} to create a request.
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyImageResponse> copyImage(Consumer<CopyImageRequest.Builder> copyImageRequest) {
        return copyImage(CopyImageRequest.builder().applyMutation(copyImageRequest).build());
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS
     * key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the
     * KMS key used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
     * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS
     * key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the
     * KMS key used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
     * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopySnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest) {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCapacityReservationRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationRequest
     *        A {@link Consumer} that will call methods on {@link CreateCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            Consumer<CreateCapacityReservationRequest.Builder> createCapacityReservationRequest) {
        return createCapacityReservation(CreateCapacityReservationRequest.builder()
                .applyMutation(createCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     * @return A Java Future containing the result of the CreateCapacityReservationFleet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationFleetResponse> createCapacityReservationFleet(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityReservationFleetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCapacityReservationFleetRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateCapacityReservationFleetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCapacityReservationFleet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationFleetResponse> createCapacityReservationFleet(
            Consumer<CreateCapacityReservationFleetRequest.Builder> createCapacityReservationFleetRequest) {
        return createCapacityReservationFleet(CreateCapacityReservationFleetRequest.builder()
                .applyMutation(createCapacityReservationFleetRequest).build());
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     *
     * @param createCarrierGatewayRequest
     * @return A Java Future containing the result of the CreateCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCarrierGatewayResponse> createCarrierGateway(
            CreateCarrierGatewayRequest createCarrierGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCarrierGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCarrierGatewayRequest#builder()}
     * </p>
     *
     * @param createCarrierGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateCarrierGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCarrierGatewayResponse> createCarrierGateway(
            Consumer<CreateCarrierGatewayRequest.Builder> createCarrierGatewayRequest) {
        return createCarrierGateway(CreateCarrierGatewayRequest.builder().applyMutation(createCarrierGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     *
     * @param createClientVpnEndpointRequest
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateClientVpnEndpointResponse> createClientVpnEndpoint(
            CreateClientVpnEndpointRequest createClientVpnEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClientVpnEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClientVpnEndpointRequest#builder()}
     * </p>
     *
     * @param createClientVpnEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateClientVpnEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateClientVpnEndpointResponse> createClientVpnEndpoint(
            Consumer<CreateClientVpnEndpointRequest.Builder> createClientVpnEndpointRequest) {
        return createClientVpnEndpoint(CreateClientVpnEndpointRequest.builder().applyMutation(createClientVpnEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     *
     * @param createClientVpnRouteRequest
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClientVpnRouteResponse> createClientVpnRoute(
            CreateClientVpnRouteRequest createClientVpnRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClientVpnRouteRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClientVpnRouteRequest#builder()}
     * </p>
     *
     * @param createClientVpnRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateClientVpnRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClientVpnRouteResponse> createClientVpnRoute(
            Consumer<CreateClientVpnRouteRequest.Builder> createClientVpnRouteRequest) {
        return createClientVpnRoute(CreateClientVpnRouteRequest.builder().applyMutation(createClientVpnRouteRequest).build());
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your VPN customer gateway device. The customer gateway is the
     * appliance at your end of the VPN connection. (The device on the Amazon Web Services side of the VPN connection is
     * the virtual private gateway.) You must provide the internet-routable IP address of the customer gateway's
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCustomerGatewayResponse> createCustomerGateway(
            CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your VPN customer gateway device. The customer gateway is the
     * appliance at your end of the VPN connection. (The device on the Amazon Web Services side of the VPN connection is
     * the virtual private gateway.) You must provide the internet-routable IP address of the customer gateway's
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomerGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomerGatewayRequest.Builder} to create a
     *        request. Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCustomerGatewayResponse> createCustomerGateway(
            Consumer<CreateCustomerGatewayRequest.Builder> createCustomerGatewayRequest) {
        return createCustomerGateway(CreateCustomerGatewayRequest.builder().applyMutation(createCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default
     * subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDefaultSubnetResponse> createDefaultSubnet(
            CreateDefaultSubnetRequest createDefaultSubnetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default
     * subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDefaultSubnetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDefaultSubnetRequest#builder()}
     * </p>
     *
     * @param createDefaultSubnetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDefaultSubnetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDefaultSubnetResponse> createDefaultSubnet(
            Consumer<CreateDefaultSubnetRequest.Builder> createDefaultSubnetRequest) {
        return createDefaultSubnet(CreateDefaultSubnetRequest.builder().applyMutation(createDefaultSubnetRequest).build());
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and default subnets</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC
     * yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * <p>
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that
     * supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see
     * "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a
     * href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.
     * </p>
     *
     * @param createDefaultVpcRequest
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and default subnets</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC
     * yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * <p>
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that
     * supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see
     * "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a
     * href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDefaultVpcRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDefaultVpcRequest#builder()}
     * </p>
     *
     * @param createDefaultVpcRequest
     *        A {@link Consumer} that will call methods on {@link CreateDefaultVpcRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc(
            Consumer<CreateDefaultVpcRequest.Builder> createDefaultVpcRequest) {
        return createDefaultVpc(CreateDefaultVpcRequest.builder().applyMutation(createDefaultVpcRequest).build());
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and default subnets</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC
     * yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * <p>
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that
     * supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see
     * "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a
     * href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.
     * </p>
     *
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc() {
        return createDefaultVpc(CreateDefaultVpcRequest.builder().build());
    }

    /**
     * <p>
     * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing
     * all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the
     * individual DHCP options you can specify. For more information about the options, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The
     * default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as
     * specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in another Region, specify
     * <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise,
     * specify a domain name (for example, <code>ExampleCompany.com</code>). This value is used to complete unqualified
     * DNS hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single domain, which results in
     * unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating
     * systems, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2
     * (broadcast and multicast are not currently supported). For more information about these node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide
     * (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set
     * the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server
     * of your choice. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDhcpOptionsRequest
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDhcpOptionsResponse> createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing
     * all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the
     * individual DHCP options you can specify. For more information about the options, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The
     * default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as
     * specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in another Region, specify
     * <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise,
     * specify a domain name (for example, <code>ExampleCompany.com</code>). This value is used to complete unqualified
     * DNS hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single domain, which results in
     * unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating
     * systems, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2
     * (broadcast and multicast are not currently supported). For more information about these node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide
     * (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set
     * the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server
     * of your choice. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDhcpOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param createDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on {@link CreateDhcpOptionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDhcpOptionsResponse> createDhcpOptions(
            Consumer<CreateDhcpOptionsRequest.Builder> createDhcpOptionsRequest) {
        return createDhcpOptions(CreateDhcpOptionsRequest.builder().applyMutation(createDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEgressOnlyInternetGatewayResponse> createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEgressOnlyInternetGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEgressOnlyInternetGatewayRequest#builder()}
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateEgressOnlyInternetGatewayRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEgressOnlyInternetGatewayResponse> createEgressOnlyInternetGateway(
            Consumer<CreateEgressOnlyInternetGatewayRequest.Builder> createEgressOnlyInternetGatewayRequest) {
        return createEgressOnlyInternetGateway(CreateEgressOnlyInternetGatewayRequest.builder()
                .applyMutation(createEgressOnlyInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Launches an EC2 Fleet.
     * </p>
     * <p>
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI,
     * Availability Zone, or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches an EC2 Fleet.
     * </p>
     * <p>
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI,
     * Availability Zone, or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createFlowLogsRequest
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowLogsResponse> createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowLogsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowLogsRequest#builder()}
     * </p>
     *
     * @param createFlowLogsRequest
     *        A {@link Consumer} that will call methods on {@link CreateFlowLogsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowLogsResponse> createFlowLogs(Consumer<CreateFlowLogsRequest.Builder> createFlowLogsRequest) {
        return createFlowLogs(CreateFlowLogsRequest.builder().applyMutation(createFlowLogsRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFpgaImageResponse> createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFpgaImageRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFpgaImageRequest#builder()}
     * </p>
     *
     * @param createFpgaImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateFpgaImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFpgaImageResponse> createFpgaImage(
            Consumer<CreateFpgaImageRequest.Builder> createFpgaImageRequest) {
        return createFpgaImage(CreateFpgaImageRequest.builder().applyMutation(createFpgaImageRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the
     * attached volumes while data is at rest, in order to ensure a consistent state. You can set the
     * <code>NoReboot</code> parameter to <code>true</code> in the API request, or use the <code>--no-reboot</code>
     * option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.
     * </p>
     * <important>
     * <p>
     * If you choose to bypass the shutdown and reboot process by setting the <code>NoReboot</code> parameter to
     * <code>true</code> in the API request, or by using the <code>--no-reboot</code> option in the CLI, we can't
     * guarantee the file system integrity of the created image.
     * </p>
     * </important>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed
     * Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the
     * attached volumes while data is at rest, in order to ensure a consistent state. You can set the
     * <code>NoReboot</code> parameter to <code>true</code> in the API request, or use the <code>--no-reboot</code>
     * option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.
     * </p>
     * <important>
     * <p>
     * If you choose to bypass the shutdown and reboot process by setting the <code>NoReboot</code> parameter to
     * <code>true</code> in the API request, or by using the <code>--no-reboot</code> option in the CLI, we can't
     * guarantee the file system integrity of the created image.
     * </p>
     * </important>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed
     * Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(Consumer<CreateImageRequest.Builder> createImageRequest) {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceEventWindowRequest
     * @return A Java Future containing the result of the CreateInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceEventWindowResponse> createInstanceEventWindow(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceEventWindowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param createInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceEventWindowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceEventWindowResponse> createInstanceEventWindow(
            Consumer<CreateInstanceEventWindowRequest.Builder> createInstanceEventWindowRequest) {
        return createInstanceEventWindow(CreateInstanceEventWindowRequest.builder()
                .applyMutation(createInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the supported operating systems, image formats, and known limitations for the types of
     * instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceExportTaskResponse> createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the supported operating systems, image formats, and known limitations for the types of
     * instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceExportTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInstanceExportTaskRequest#builder()}
     * </p>
     *
     * @param createInstanceExportTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceExportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInstanceExportTaskResponse> createInstanceExportTask(
            Consumer<CreateInstanceExportTaskRequest.Builder> createInstanceExportTaskRequest) {
        return createInstanceExportTask(CreateInstanceExportTaskRequest.builder().applyMutation(createInstanceExportTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param createInternetGatewayRequest
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInternetGatewayResponse> createInternetGateway(
            CreateInternetGatewayRequest createInternetGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInternetGatewayRequest#builder()}
     * </p>
     *
     * @param createInternetGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateInternetGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInternetGatewayResponse> createInternetGateway(
            Consumer<CreateInternetGatewayRequest.Builder> createInternetGatewayRequest) {
        return createInternetGateway(CreateInternetGatewayRequest.builder().applyMutation(createInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInternetGatewayResponse> createInternetGateway() {
        return createInternetGateway(CreateInternetGatewayRequest.builder().build());
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamRequest
     * @return A Java Future containing the result of the CreateIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamResponse> createIpam(CreateIpamRequest createIpamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpamRequest#builder()}
     * </p>
     *
     * @param createIpamRequest
     *        A {@link Consumer} that will call methods on {@link CreateIpamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamResponse> createIpam(Consumer<CreateIpamRequest.Builder> createIpamRequest) {
        return createIpam(CreateIpamRequest.builder().applyMutation(createIpamRequest).build());
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamPoolRequest
     * @return A Java Future containing the result of the CreateIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamPoolResponse> createIpamPool(CreateIpamPoolRequest createIpamPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpamPoolRequest#builder()}
     * </p>
     *
     * @param createIpamPoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateIpamPoolRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamPoolResponse> createIpamPool(Consumer<CreateIpamPoolRequest.Builder> createIpamPoolRequest) {
        return createIpamPool(CreateIpamPoolRequest.builder().applyMutation(createIpamPoolRequest).build());
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/add-scope-ipam.html">Add a scope</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamScopeRequest
     * @return A Java Future containing the result of the CreateIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamScopeResponse> createIpamScope(CreateIpamScopeRequest createIpamScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/add-scope-ipam.html">Add a scope</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamScopeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIpamScopeRequest#builder()}
     * </p>
     *
     * @param createIpamScopeRequest
     *        A {@link Consumer} that will call methods on {@link CreateIpamScopeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpamScopeResponse> createIpamScope(
            Consumer<CreateIpamScopeRequest.Builder> createIpamScopeRequest) {
        return createIpamScope(CreateIpamScopeRequest.builder().applyMutation(createIpamScopeRequest).build());
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and
     * displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded
     * PKCS#1 private key. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and
     * displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded
     * PKCS#1 private key. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyPairRequest#builder()}
     * </p>
     *
     * @param createKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyPairResponse> createKeyPair(Consumer<CreateKeyPairRequest.Builder> createKeyPairRequest) {
        return createKeyPair(CreateKeyPairRequest.builder().applyMutation(createKeyPairRequest).build());
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you want to clone an existing launch template as the basis for creating a new launch template, you can use the
     * Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateRequest
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLaunchTemplateResponse> createLaunchTemplate(
            CreateLaunchTemplateRequest createLaunchTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you want to clone an existing launch template as the basis for creating a new launch template, you can use the
     * Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLaunchTemplateRequest#builder()}
     * </p>
     *
     * @param createLaunchTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLaunchTemplateResponse> createLaunchTemplate(
            Consumer<CreateLaunchTemplateRequest.Builder> createLaunchTemplateRequest) {
        return createLaunchTemplate(CreateLaunchTemplateRequest.builder().applyMutation(createLaunchTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new version for a launch template. You can specify an existing version of launch template from which to
     * base the new version.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You cannot specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Managing launch template versions</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchTemplateVersionResponse> createLaunchTemplateVersion(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version for a launch template. You can specify an existing version of launch template from which to
     * base the new version.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You cannot specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Managing launch template versions</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLaunchTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchTemplateVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchTemplateVersionResponse> createLaunchTemplateVersion(
            Consumer<CreateLaunchTemplateVersionRequest.Builder> createLaunchTemplateVersionRequest) {
        return createLaunchTemplateVersion(CreateLaunchTemplateVersionRequest.builder()
                .applyMutation(createLaunchTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocalGatewayRouteResponse> createLocalGatewayRoute(
            CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocalGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocalGatewayRouteRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateLocalGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocalGatewayRouteResponse> createLocalGatewayRoute(
            Consumer<CreateLocalGatewayRouteRequest.Builder> createLocalGatewayRouteRequest) {
        return createLocalGatewayRoute(CreateLocalGatewayRouteRequest.builder().applyMutation(createLocalGatewayRouteRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> createLocalGatewayRouteTableVpcAssociation(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateLocalGatewayRouteTableVpcAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateLocalGatewayRouteTableVpcAssociationRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateLocalGatewayRouteTableVpcAssociationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> createLocalGatewayRouteTableVpcAssociation(
            Consumer<CreateLocalGatewayRouteTableVpcAssociationRequest.Builder> createLocalGatewayRouteTableVpcAssociationRequest) {
        return createLocalGatewayRouteTableVpcAssociation(CreateLocalGatewayRouteTableVpcAssociationRequest.builder()
                .applyMutation(createLocalGatewayRouteTableVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     *
     * @param createManagedPrefixListRequest
     * @return A Java Future containing the result of the CreateManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateManagedPrefixListResponse> createManagedPrefixList(
            CreateManagedPrefixListRequest createManagedPrefixListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateManagedPrefixListRequest.Builder} avoiding
     * the need to create one manually via {@link CreateManagedPrefixListRequest#builder()}
     * </p>
     *
     * @param createManagedPrefixListRequest
     *        A {@link Consumer} that will call methods on {@link CreateManagedPrefixListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateManagedPrefixListResponse> createManagedPrefixList(
            Consumer<CreateManagedPrefixListRequest.Builder> createManagedPrefixListRequest) {
        return createManagedPrefixList(CreateManagedPrefixListRequest.builder().applyMutation(createManagedPrefixListRequest)
                .build());
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNatGatewayRequest
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNatGatewayResponse> createNatGateway(CreateNatGatewayRequest createNatGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNatGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNatGatewayRequest#builder()}
     * </p>
     *
     * @param createNatGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateNatGatewayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNatGatewayResponse> createNatGateway(
            Consumer<CreateNatGatewayRequest.Builder> createNatGatewayRequest) {
        return createNatGateway(CreateNatGatewayRequest.builder().applyMutation(createNatGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNetworkAclResponse> createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAclRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNetworkAclRequest#builder()}
     * </p>
     *
     * @param createNetworkAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkAclRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNetworkAclResponse> createNetworkAcl(
            Consumer<CreateNetworkAclRequest.Builder> createNetworkAclRequest) {
        return createNetworkAcl(CreateNetworkAclRequest.builder().applyMutation(createNetworkAclRequest).build());
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual
     * Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNetworkAclEntryResponse> createNetworkAclEntry(
            CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual
     * Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAclEntryRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkAclEntryRequest#builder()}
     * </p>
     *
     * @param createNetworkAclEntryRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkAclEntryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNetworkAclEntryResponse> createNetworkAclEntry(
            Consumer<CreateNetworkAclEntryRequest.Builder> createNetworkAclEntryRequest) {
        return createNetworkAclEntry(CreateNetworkAclEntryRequest.builder().applyMutation(createNetworkAclEntryRequest).build());
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInsightsAccessScopeResponse> createNetworkInsightsAccessScope(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInsightsAccessScopeRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkInsightsAccessScopeRequest#builder()}
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkInsightsAccessScopeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInsightsAccessScopeResponse> createNetworkInsightsAccessScope(
            Consumer<CreateNetworkInsightsAccessScopeRequest.Builder> createNetworkInsightsAccessScopeRequest) {
        return createNetworkInsightsAccessScope(CreateNetworkInsightsAccessScopeRequest.builder()
                .applyMutation(createNetworkInsightsAccessScopeRequest).build());
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer</a>.
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInsightsPathResponse> createNetworkInsightsPath(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInsightsPathRequest.Builder} avoiding
     * the need to create one manually via {@link CreateNetworkInsightsPathRequest#builder()}
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkInsightsPathRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInsightsPathResponse> createNetworkInsightsPath(
            Consumer<CreateNetworkInsightsPathRequest.Builder> createNetworkInsightsPathRequest) {
        return createNetworkInsightsPath(CreateNetworkInsightsPathRequest.builder()
                .applyMutation(createNetworkInsightsPathRequest).build());
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     *        Contains the parameters for CreateNetworkInterface.
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInterfaceResponse> createNetworkInterface(
            CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param createNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkInterfaceRequest.Builder} to create a
     *        request. Contains the parameters for CreateNetworkInterface.
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInterfaceResponse> createNetworkInterface(
            Consumer<CreateNetworkInterfaceRequest.Builder> createNetworkInterfaceRequest) {
        return createNetworkInterface(CreateNetworkInterfaceRequest.builder().applyMutation(createNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInterfacePermissionResponse> createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInterfacePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkInterfacePermissionRequest#builder()}
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkInterfacePermissionRequest.Builder} to
     *        create a request. Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkInterfacePermissionResponse> createNetworkInterfacePermission(
            Consumer<CreateNetworkInterfacePermissionRequest.Builder> createNetworkInterfacePermissionRequest) {
        return createNetworkInterfacePermission(CreateNetworkInterfacePermissionRequest.builder()
                .applyMutation(createNetworkInterfacePermissionRequest).build());
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlacementGroupResponse> createPlacementGroup(
            CreatePlacementGroupRequest createPlacementGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlacementGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlacementGroupRequest#builder()}
     * </p>
     *
     * @param createPlacementGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlacementGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlacementGroupResponse> createPlacementGroup(
            Consumer<CreatePlacementGroupRequest.Builder> createPlacementGroupRequest) {
        return createPlacementGroup(CreatePlacementGroupRequest.builder().applyMutation(createPlacementGroupRequest).build());
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     * @return A Java Future containing the result of the CreatePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePublicIpv4PoolResponse> createPublicIpv4Pool(
            CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicIpv4PoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePublicIpv4PoolRequest#builder()}
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     *        A {@link Consumer} that will call methods on {@link CreatePublicIpv4PoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePublicIpv4PoolResponse> createPublicIpv4Pool(
            Consumer<CreatePublicIpv4PoolRequest.Builder> createPublicIpv4PoolRequest) {
        return createPublicIpv4Pool(CreatePublicIpv4PoolRequest.builder().applyMutation(createPublicIpv4PoolRequest).build());
    }

    /**
     * <p>
     * Creates a root volume replacement task for an Amazon EC2 instance. The root volume can either be restored to its
     * initial launch state, or it can be restored using a specific snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     * @return A Java Future containing the result of the CreateReplaceRootVolumeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplaceRootVolumeTaskResponse> createReplaceRootVolumeTask(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a root volume replacement task for an Amazon EC2 instance. The root volume can either be restored to its
     * initial launch state, or it can be restored using a specific snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplaceRootVolumeTaskRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplaceRootVolumeTaskRequest#builder()}
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplaceRootVolumeTaskRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateReplaceRootVolumeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplaceRootVolumeTaskResponse> createReplaceRootVolumeTask(
            Consumer<CreateReplaceRootVolumeTaskRequest.Builder> createReplaceRootVolumeTaskRequest) {
        return createReplaceRootVolumeTask(CreateReplaceRootVolumeTaskRequest.builder()
                .applyMutation(createReplaceRootVolumeTaskRequest).build());
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReservedInstancesListingResponse> createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReservedInstancesListingRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReservedInstancesListingRequest#builder()}
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        A {@link Consumer} that will call methods on {@link CreateReservedInstancesListingRequest.Builder} to
     *        create a request. Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReservedInstancesListingResponse> createReservedInstancesListing(
            Consumer<CreateReservedInstancesListingRequest.Builder> createReservedInstancesListingRequest) {
        return createReservedInstancesListing(CreateReservedInstancesListingRequest.builder()
                .applyMutation(createReservedInstancesListingRequest).build());
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createRestoreImageTaskRequest
     * @return A Java Future containing the result of the CreateRestoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRestoreImageTaskResponse> createRestoreImageTask(
            CreateRestoreImageTaskRequest createRestoreImageTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestoreImageTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRestoreImageTaskRequest#builder()}
     * </p>
     *
     * @param createRestoreImageTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateRestoreImageTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRestoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRestoreImageTaskResponse> createRestoreImageTask(
            Consumer<CreateRestoreImageTaskRequest.Builder> createRestoreImageTaskRequest) {
        return createRestoreImageTask(CreateRestoreImageTaskRequest.builder().applyMutation(createRestoreImageTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT
     * gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT
     * gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRouteRequest#builder()}
     * </p>
     *
     * @param createRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteResponse> createRoute(Consumer<CreateRouteRequest.Builder> createRouteRequest) {
        return createRoute(CreateRouteRequest.builder().applyMutation(createRouteRequest).build());
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteTableResponse> createRouteTable(CreateRouteTableRequest createRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteTableRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRouteTableRequest#builder()}
     * </p>
     *
     * @param createRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteTableResponse> createRouteTable(
            Consumer<CreateRouteTableRequest.Builder> createRouteTableRequest) {
        return createRouteTable(CreateRouteTableRequest.builder().applyMutation(createRouteTableRequest).build());
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for
     * use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security
     * groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you
     * don't specify a security group when you launch an instance, the instance is launched into the appropriate default
     * security group. A default security group includes a default rule that grants instances unrestricted network
     * access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(
            CreateSecurityGroupRequest createSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for
     * use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security
     * groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you
     * don't specify a security group when you launch an instance, the instance is launched into the appropriate default
     * security group. A default security group includes a default rule that grants instances unrestricted network
     * access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(
            Consumer<CreateSecurityGroupRequest.Builder> createSecurityGroupRequest) {
        return createSecurityGroup(CreateSecurityGroupRequest.builder().applyMutation(createSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume
     * in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume
     * on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * </p>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the instance before
     * taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon
     * Elastic Block Store</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume
     * in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume
     * on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * </p>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the instance before
     * taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon
     * Elastic Block Store</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance. Boot volumes can be excluded by changing the parameters.
     * </p>
     * <p>
     * You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create
     * snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you
     * create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance,
     * or in the Region for that Outpost.
     * </p>
     *
     * @param createSnapshotsRequest
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotsResponse> createSnapshots(CreateSnapshotsRequest createSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance. Boot volumes can be excluded by changing the parameters.
     * </p>
     * <p>
     * You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create
     * snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you
     * create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance,
     * or in the Region for that Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSnapshotsRequest#builder()}
     * </p>
     *
     * @param createSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotsResponse> createSnapshots(
            Consumer<CreateSnapshotsRequest.Builder> createSnapshotsRequest) {
        return createSnapshots(CreateSnapshotsRequest.builder().applyMutation(createSnapshotsRequest).build());
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSpotDatafeedSubscriptionResponse> createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSpotDatafeedSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSpotDatafeedSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSpotDatafeedSubscriptionRequest.Builder} to
     *        create a request. Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSpotDatafeedSubscriptionResponse> createSpotDatafeedSubscription(
            Consumer<CreateSpotDatafeedSubscriptionRequest.Builder> createSpotDatafeedSubscriptionRequest) {
        return createSpotDatafeedSubscription(CreateSpotDatafeedSubscriptionRequest.builder()
                .applyMutation(createSpotDatafeedSubscriptionRequest).build());
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createStoreImageTaskRequest
     * @return A Java Future containing the result of the CreateStoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStoreImageTaskResponse> createStoreImageTask(
            CreateStoreImageTaskRequest createStoreImageTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStoreImageTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStoreImageTaskRequest#builder()}
     * </p>
     *
     * @param createStoreImageTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateStoreImageTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStoreImageTaskResponse> createStoreImageTask(
            Consumer<CreateStoreImageTaskRequest.Builder> createStoreImageTaskRequest) {
        return createStoreImageTask(CreateStoreImageTaskRequest.builder().applyMutation(createStoreImageTaskRequest).build());
    }

    /**
     * <p>
     * Creates a subnet in a specified VPC.
     * </p>
     * <p>
     * You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block.
     * The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR
     * block must not overlap with the CIDR block of an existing subnet in the VPC.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses
     * a /64 prefix length.
     * </p>
     * <important>
     * <p>
     * Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're
     * not available for use.
     * </p>
     * </important>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information about subnets, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubnetResponse> createSubnet(CreateSubnetRequest createSubnetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet in a specified VPC.
     * </p>
     * <p>
     * You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block.
     * The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR
     * block must not overlap with the CIDR block of an existing subnet in the VPC.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses
     * a /64 prefix length.
     * </p>
     * <important>
     * <p>
     * Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're
     * not available for use.
     * </p>
     * </important>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information about subnets, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSubnetRequest#builder()}
     * </p>
     *
     * @param createSubnetRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubnetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubnetResponse> createSubnet(Consumer<CreateSubnetRequest.Builder> createSubnetRequest) {
        return createSubnet(CreateSubnetRequest.builder().applyMutation(createSubnetRequest).build());
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     * @return A Java Future containing the result of the CreateSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubnetCidrReservationResponse> createSubnetCidrReservation(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetCidrReservationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubnetCidrReservationRequest#builder()}
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubnetCidrReservationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubnetCidrReservationResponse> createSubnetCidrReservation(
            Consumer<CreateSubnetCidrReservationRequest.Builder> createSubnetCidrReservationRequest) {
        return createSubnetCidrReservation(CreateSubnetCidrReservationRequest.builder()
                .applyMutation(createSubnetCidrReservationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorFilterResponse> createTrafficMirrorFilter(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorFilterRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorFilterRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrafficMirrorFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorFilterResponse> createTrafficMirrorFilter(
            Consumer<CreateTrafficMirrorFilterRequest.Builder> createTrafficMirrorFilterRequest) {
        return createTrafficMirrorFilter(CreateTrafficMirrorFilterRequest.builder()
                .applyMutation(createTrafficMirrorFilterRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorFilterRuleResponse> createTrafficMirrorFilterRule(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorFilterRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTrafficMirrorFilterRuleRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrafficMirrorFilterRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorFilterRuleResponse> createTrafficMirrorFilterRule(
            Consumer<CreateTrafficMirrorFilterRuleRequest.Builder> createTrafficMirrorFilterRuleRequest) {
        return createTrafficMirrorFilterRule(CreateTrafficMirrorFilterRuleRequest.builder()
                .applyMutation(createTrafficMirrorFilterRuleRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorSessionResponse> createTrafficMirrorSession(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorSessionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorSessionRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrafficMirrorSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorSessionResponse> createTrafficMirrorSession(
            Consumer<CreateTrafficMirrorSessionRequest.Builder> createTrafficMirrorSessionRequest) {
        return createTrafficMirrorSession(CreateTrafficMirrorSessionRequest.builder()
                .applyMutation(createTrafficMirrorSessionRequest).build());
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorTargetResponse> createTrafficMirrorTarget(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorTargetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorTargetRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrafficMirrorTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficMirrorTargetResponse> createTrafficMirrorTarget(
            Consumer<CreateTrafficMirrorTargetRequest.Builder> createTrafficMirrorTargetRequest) {
        return createTrafficMirrorTarget(CreateTrafficMirrorTargetRequest.builder()
                .applyMutation(createTrafficMirrorTargetRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRequest
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayResponse> createTransitGateway(
            CreateTransitGatewayRequest createTransitGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTransitGatewayRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayResponse> createTransitGateway(
            Consumer<CreateTransitGatewayRequest.Builder> createTransitGatewayRequest) {
        return createTransitGateway(CreateTransitGatewayRequest.builder().applyMutation(createTransitGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayResponse> createTransitGateway() {
        return createTransitGateway(CreateTransitGatewayRequest.builder().build());
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayConnectResponse> createTransitGatewayConnect(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayConnectRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayConnectRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayConnectRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayConnectResponse> createTransitGatewayConnect(
            Consumer<CreateTransitGatewayConnectRequest.Builder> createTransitGatewayConnectRequest) {
        return createTransitGatewayConnect(CreateTransitGatewayConnectRequest.builder()
                .applyMutation(createTransitGatewayConnectRequest).build());
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Transit Gateways Guide</i>.
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayConnectPeerResponse> createTransitGatewayConnectPeer(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Transit Gateways Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayConnectPeerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayConnectPeerResponse> createTransitGatewayConnectPeer(
            Consumer<CreateTransitGatewayConnectPeerRequest.Builder> createTransitGatewayConnectPeerRequest) {
        return createTransitGatewayConnectPeer(CreateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(createTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayMulticastDomainResponse> createTransitGatewayMulticastDomain(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayMulticastDomainRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayMulticastDomainRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayMulticastDomainResponse> createTransitGatewayMulticastDomain(
            Consumer<CreateTransitGatewayMulticastDomainRequest.Builder> createTransitGatewayMulticastDomainRequest) {
        return createTransitGatewayMulticastDomain(CreateTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(createTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The transit gateways must be in different Regions. The peer transit gateway can be in
     * your account or a different Amazon Web Services account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> createTransitGatewayPeeringAttachment(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The transit gateways must be in different Regions. The peer transit gateway can be in
     * your account or a different Amazon Web Services account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayPeeringAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> createTransitGatewayPeeringAttachment(
            Consumer<CreateTransitGatewayPeeringAttachmentRequest.Builder> createTransitGatewayPeeringAttachmentRequest) {
        return createTransitGatewayPeeringAttachment(CreateTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(createTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPrefixListReferenceResponse> createTransitGatewayPrefixListReference(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayPrefixListReferenceRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayPrefixListReferenceRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateTransitGatewayPrefixListReferenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayPrefixListReferenceResponse> createTransitGatewayPrefixListReference(
            Consumer<CreateTransitGatewayPrefixListReferenceRequest.Builder> createTransitGatewayPrefixListReferenceRequest) {
        return createTransitGatewayPrefixListReference(CreateTransitGatewayPrefixListReferenceRequest.builder()
                .applyMutation(createTransitGatewayPrefixListReferenceRequest).build());
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteResponse> createTransitGatewayRoute(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTransitGatewayRouteRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteResponse> createTransitGatewayRoute(
            Consumer<CreateTransitGatewayRouteRequest.Builder> createTransitGatewayRouteRequest) {
        return createTransitGatewayRoute(CreateTransitGatewayRouteRequest.builder()
                .applyMutation(createTransitGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteTableResponse> createTransitGatewayRouteTable(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayRouteTableRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayRouteTableResponse> createTransitGatewayRouteTable(
            Consumer<CreateTransitGatewayRouteTableRequest.Builder> createTransitGatewayRouteTableRequest) {
        return createTransitGatewayRouteTable(CreateTransitGatewayRouteTableRequest.builder()
                .applyMutation(createTransitGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> createTransitGatewayVpcAttachment(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> createTransitGatewayVpcAttachment(
            Consumer<CreateTransitGatewayVpcAttachmentRequest.Builder> createTransitGatewayVpcAttachmentRequest) {
        return createTransitGatewayVpcAttachment(CreateTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(createTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Create an Amazon EBS
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Create an Amazon EBS
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVolumeRequest#builder()}
     * </p>
     *
     * @param createVolumeRequest
     *        A {@link Consumer} that will call methods on {@link CreateVolumeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVolumeResponse> createVolume(Consumer<CreateVolumeRequest.Builder> createVolumeRequest) {
        return createVolume(CreateVolumeRequest.builder().applyMutation(createVolumeRequest).build());
    }

    /**
     * <p>
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4
     * addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to
     * make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned
     * through bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS
     * server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcResponse> createVpc(CreateVpcRequest createVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4
     * addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to
     * make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned
     * through bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS
     * server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcRequest#builder()}
     * </p>
     *
     * @param createVpcRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcResponse> createVpc(Consumer<CreateVpcRequest.Builder> createVpcRequest) {
        return createVpc(CreateVpcRequest.builder().applyMutation(createVpcRequest).build());
    }

    /**
     * <p>
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between
     * your VPC and the service. The service may be provided by Amazon Web Services, an Amazon Web Services Marketplace
     * Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink Guide</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     *        Contains the parameters for CreateVpcEndpoint.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between
     * your VPC and the service. The service may be provided by Amazon Web Services, an Amazon Web Services Marketplace
     * Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcEndpointRequest.Builder} to create a request.
     *        Contains the parameters for CreateVpcEndpoint.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(
            Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest) {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> createVpcEndpointConnectionNotification(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateVpcEndpointConnectionNotificationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateVpcEndpointConnectionNotificationRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateVpcEndpointConnectionNotificationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> createVpcEndpointConnectionNotification(
            Consumer<CreateVpcEndpointConnectionNotificationRequest.Builder> createVpcEndpointConnectionNotificationRequest) {
        return createVpcEndpointConnectionNotification(CreateVpcEndpointConnectionNotificationRequest.builder()
                .applyMutation(createVpcEndpointConnectionNotificationRequest).build());
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, IAM users, and IAM
     * roles) can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> createVpcEndpointServiceConfiguration(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, IAM users, and IAM
     * roles) can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateVpcEndpointServiceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateVpcEndpointServiceConfigurationRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcEndpointServiceConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> createVpcEndpointServiceConfiguration(
            Consumer<CreateVpcEndpointServiceConfigurationRequest.Builder> createVpcEndpointServiceConfigurationRequest) {
        return createVpcEndpointServiceConfiguration(CreateVpcEndpointServiceConfigurationRequest.builder()
                .applyMutation(createVpcEndpointServiceConfigurationRequest).build());
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            Consumer<CreateVpcPeeringConnectionRequest.Builder> createVpcPeeringConnectionRequest) {
        return createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.builder()
                .applyMutation(createVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpnConnectionResponse> createVpnConnection(
            CreateVpnConnectionRequest createVpnConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpnConnectionRequest#builder()}
     * </p>
     *
     * @param createVpnConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpnConnectionRequest.Builder} to create a
     *        request. Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpnConnectionResponse> createVpnConnection(
            Consumer<CreateVpnConnectionRequest.Builder> createVpnConnectionRequest) {
        return createVpnConnection(CreateVpnConnectionRequest.builder().applyMutation(createVpnConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVpnConnectionRouteResponse> createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnConnectionRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpnConnectionRouteRequest#builder()}
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpnConnectionRouteRequest.Builder} to create a
     *        request. Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVpnConnectionRouteResponse> createVpnConnectionRoute(
            Consumer<CreateVpnConnectionRouteRequest.Builder> createVpnConnectionRouteRequest) {
        return createVpnConnectionRoute(CreateVpnConnectionRouteRequest.builder().applyMutation(createVpnConnectionRouteRequest)
                .build());
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpnGatewayResponse> createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpnGatewayRequest#builder()}
     * </p>
     *
     * @param createVpnGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpnGatewayResponse> createVpnGateway(
            Consumer<CreateVpnGatewayRequest.Builder> createVpnGatewayRequest) {
        return createVpnGateway(CreateVpnGatewayRequest.builder().applyMutation(createVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     *
     * @param deleteCarrierGatewayRequest
     * @return A Java Future containing the result of the DeleteCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCarrierGatewayResponse> deleteCarrierGateway(
            DeleteCarrierGatewayRequest deleteCarrierGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCarrierGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCarrierGatewayRequest#builder()}
     * </p>
     *
     * @param deleteCarrierGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCarrierGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCarrierGatewayResponse> deleteCarrierGateway(
            Consumer<DeleteCarrierGatewayRequest.Builder> deleteCarrierGatewayRequest) {
        return deleteCarrierGateway(DeleteCarrierGatewayRequest.builder().applyMutation(deleteCarrierGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteClientVpnEndpointResponse> deleteClientVpnEndpoint(
            DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientVpnEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClientVpnEndpointRequest#builder()}
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClientVpnEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteClientVpnEndpointResponse> deleteClientVpnEndpoint(
            Consumer<DeleteClientVpnEndpointRequest.Builder> deleteClientVpnEndpointRequest) {
        return deleteClientVpnEndpoint(DeleteClientVpnEndpointRequest.builder().applyMutation(deleteClientVpnEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClientVpnRouteResponse> deleteClientVpnRoute(
            DeleteClientVpnRouteRequest deleteClientVpnRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientVpnRouteRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClientVpnRouteRequest#builder()}
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClientVpnRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClientVpnRouteResponse> deleteClientVpnRoute(
            Consumer<DeleteClientVpnRouteRequest.Builder> deleteClientVpnRouteRequest) {
        return deleteClientVpnRoute(DeleteClientVpnRouteRequest.builder().applyMutation(deleteClientVpnRouteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCustomerGatewayResponse> deleteCustomerGateway(
            DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomerGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomerGatewayRequest.Builder} to create a
     *        request. Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCustomerGatewayResponse> deleteCustomerGateway(
            Consumer<DeleteCustomerGatewayRequest.Builder> deleteCustomerGatewayRequest) {
        return deleteCustomerGateway(DeleteCustomerGatewayRequest.builder().applyMutation(deleteCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDhcpOptionsResponse> deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDhcpOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDhcpOptionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDhcpOptionsResponse> deleteDhcpOptions(
            Consumer<DeleteDhcpOptionsRequest.Builder> deleteDhcpOptionsRequest) {
        return deleteDhcpOptions(DeleteDhcpOptionsRequest.builder().applyMutation(deleteDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEgressOnlyInternetGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEgressOnlyInternetGatewayRequest#builder()}
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEgressOnlyInternetGatewayRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> deleteEgressOnlyInternetGateway(
            Consumer<DeleteEgressOnlyInternetGatewayRequest.Builder> deleteEgressOnlyInternetGatewayRequest) {
        return deleteEgressOnlyInternetGateway(DeleteEgressOnlyInternetGatewayRequest.builder()
                .applyMutation(deleteEgressOnlyInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleet.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must specify whether a deleted EC2 Fleet should also terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 <code>instant</code> fleets in a single request. If you exceed this number, no
     * <code>instant</code> fleets are deleted and an error is returned. There is no restriction on the number of fleets
     * of type <code>maintain</code> or <code>request</code> that can be deleted in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Up to 1000 instances can be terminated in a single request to delete <code>instant</code> fleets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteFleetsRequest
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetsResponse> deleteFleets(DeleteFleetsRequest deleteFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleet.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must specify whether a deleted EC2 Fleet should also terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 <code>instant</code> fleets in a single request. If you exceed this number, no
     * <code>instant</code> fleets are deleted and an error is returned. There is no restriction on the number of fleets
     * of type <code>maintain</code> or <code>request</code> that can be deleted in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Up to 1000 instances can be terminated in a single request to delete <code>instant</code> fleets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetsRequest#builder()}
     * </p>
     *
     * @param deleteFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetsResponse> deleteFleets(Consumer<DeleteFleetsRequest.Builder> deleteFleetsRequest) {
        return deleteFleets(DeleteFleetsRequest.builder().applyMutation(deleteFleetsRequest).build());
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowLogsResponse> deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowLogsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowLogsRequest#builder()}
     * </p>
     *
     * @param deleteFlowLogsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFlowLogsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowLogsResponse> deleteFlowLogs(Consumer<DeleteFlowLogsRequest.Builder> deleteFlowLogsRequest) {
        return deleteFlowLogs(DeleteFlowLogsRequest.builder().applyMutation(deleteFlowLogsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFpgaImageResponse> deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFpgaImageRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFpgaImageRequest#builder()}
     * </p>
     *
     * @param deleteFpgaImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFpgaImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFpgaImageResponse> deleteFpgaImage(
            Consumer<DeleteFpgaImageRequest.Builder> deleteFpgaImageRequest) {
        return deleteFpgaImage(DeleteFpgaImageRequest.builder().applyMutation(deleteFpgaImageRequest).build());
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     * @return A Java Future containing the result of the DeleteInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceEventWindowResponse> deleteInstanceEventWindow(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceEventWindowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceEventWindowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceEventWindowResponse> deleteInstanceEventWindow(
            Consumer<DeleteInstanceEventWindowRequest.Builder> deleteInstanceEventWindowRequest) {
        return deleteInstanceEventWindow(DeleteInstanceEventWindowRequest.builder()
                .applyMutation(deleteInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInternetGatewayResponse> deleteInternetGateway(
            DeleteInternetGatewayRequest deleteInternetGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInternetGatewayRequest#builder()}
     * </p>
     *
     * @param deleteInternetGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInternetGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInternetGatewayResponse> deleteInternetGateway(
            Consumer<DeleteInternetGatewayRequest.Builder> deleteInternetGatewayRequest) {
        return deleteInternetGateway(DeleteInternetGatewayRequest.builder().applyMutation(deleteInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-ipam.html">Delete an IPAM</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamRequest
     * @return A Java Future containing the result of the DeleteIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamResponse> deleteIpam(DeleteIpamRequest deleteIpamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-ipam.html">Delete an IPAM</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpamRequest#builder()}
     * </p>
     *
     * @param deleteIpamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIpamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamResponse> deleteIpam(Consumer<DeleteIpamRequest.Builder> deleteIpamRequest) {
        return deleteIpam(DeleteIpamRequest.builder().applyMutation(deleteIpamRequest).build());
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-pool-ipam.html">Delete a pool</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamPoolRequest
     * @return A Java Future containing the result of the DeleteIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamPoolResponse> deleteIpamPool(DeleteIpamPoolRequest deleteIpamPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-pool-ipam.html">Delete a pool</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpamPoolRequest#builder()}
     * </p>
     *
     * @param deleteIpamPoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIpamPoolRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamPoolResponse> deleteIpamPool(Consumer<DeleteIpamPoolRequest.Builder> deleteIpamPoolRequest) {
        return deleteIpamPool(DeleteIpamPoolRequest.builder().applyMutation(deleteIpamPoolRequest).build());
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-scope-ipam.html">Delete a scope</a> in the <i>Amazon
     * VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamScopeRequest
     * @return A Java Future containing the result of the DeleteIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamScopeResponse> deleteIpamScope(DeleteIpamScopeRequest deleteIpamScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="/vpc/latest/ipam/delete-scope-ipam.html">Delete a scope</a> in the <i>Amazon
     * VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamScopeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIpamScopeRequest#builder()}
     * </p>
     *
     * @param deleteIpamScopeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIpamScopeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpamScopeResponse> deleteIpamScope(
            Consumer<DeleteIpamScopeRequest.Builder> deleteIpamScopeRequest) {
        return deleteIpamScope(DeleteIpamScopeRequest.builder().applyMutation(deleteIpamScopeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyPairRequest#builder()}
     * </p>
     *
     * @param deleteKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKeyPairRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(Consumer<DeleteKeyPairRequest.Builder> deleteKeyPairRequest) {
        return deleteKeyPair(DeleteKeyPairRequest.builder().applyMutation(deleteKeyPairRequest).build());
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLaunchTemplateResponse> deleteLaunchTemplate(
            DeleteLaunchTemplateRequest deleteLaunchTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLaunchTemplateRequest#builder()}
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLaunchTemplateResponse> deleteLaunchTemplate(
            Consumer<DeleteLaunchTemplateRequest.Builder> deleteLaunchTemplateRequest) {
        return deleteLaunchTemplate(DeleteLaunchTemplateRequest.builder().applyMutation(deleteLaunchTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template. You cannot delete the default version of a launch template;
     * you must first assign a different version as the default. If the default version is the only version for the
     * launch template, you must delete the entire launch template using <a>DeleteLaunchTemplate</a>.
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchTemplateVersionsResponse> deleteLaunchTemplateVersions(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template. You cannot delete the default version of a launch template;
     * you must first assign a different version as the default. If the default version is the only version for the
     * launch template, you must delete the entire launch template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLaunchTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchTemplateVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchTemplateVersionsResponse> deleteLaunchTemplateVersions(
            Consumer<DeleteLaunchTemplateVersionsRequest.Builder> deleteLaunchTemplateVersionsRequest) {
        return deleteLaunchTemplateVersions(DeleteLaunchTemplateVersionsRequest.builder()
                .applyMutation(deleteLaunchTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLocalGatewayRouteResponse> deleteLocalGatewayRoute(
            DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocalGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLocalGatewayRouteRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLocalGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLocalGatewayRouteResponse> deleteLocalGatewayRoute(
            Consumer<DeleteLocalGatewayRouteRequest.Builder> deleteLocalGatewayRouteRequest) {
        return deleteLocalGatewayRoute(DeleteLocalGatewayRouteRequest.builder().applyMutation(deleteLocalGatewayRouteRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> deleteLocalGatewayRouteTableVpcAssociation(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteLocalGatewayRouteTableVpcAssociationRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> deleteLocalGatewayRouteTableVpcAssociation(
            Consumer<DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder> deleteLocalGatewayRouteTableVpcAssociationRequest) {
        return deleteLocalGatewayRouteTableVpcAssociation(DeleteLocalGatewayRouteTableVpcAssociationRequest.builder()
                .applyMutation(deleteLocalGatewayRouteTableVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     * @return A Java Future containing the result of the DeleteManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteManagedPrefixListResponse> deleteManagedPrefixList(
            DeleteManagedPrefixListRequest deleteManagedPrefixListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteManagedPrefixListRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteManagedPrefixListRequest#builder()}
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteManagedPrefixListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteManagedPrefixListResponse> deleteManagedPrefixList(
            Consumer<DeleteManagedPrefixListRequest.Builder> deleteManagedPrefixListRequest) {
        return deleteManagedPrefixList(DeleteManagedPrefixListRequest.builder().applyMutation(deleteManagedPrefixListRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNatGatewayResponse> deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNatGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNatGatewayRequest#builder()}
     * </p>
     *
     * @param deleteNatGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNatGatewayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNatGatewayResponse> deleteNatGateway(
            Consumer<DeleteNatGatewayRequest.Builder> deleteNatGatewayRequest) {
        return deleteNatGateway(DeleteNatGatewayRequest.builder().applyMutation(deleteNatGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAclResponse> deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAclRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNetworkAclRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkAclRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAclResponse> deleteNetworkAcl(
            Consumer<DeleteNetworkAclRequest.Builder> deleteNetworkAclRequest) {
        return deleteNetworkAcl(DeleteNetworkAclRequest.builder().applyMutation(deleteNetworkAclRequest).build());
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAclEntryResponse> deleteNetworkAclEntry(
            DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAclEntryRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkAclEntryRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkAclEntryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNetworkAclEntryResponse> deleteNetworkAclEntry(
            Consumer<DeleteNetworkAclEntryRequest.Builder> deleteNetworkAclEntryRequest) {
        return deleteNetworkAclEntry(DeleteNetworkAclEntryRequest.builder().applyMutation(deleteNetworkAclEntryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAccessScopeResponse> deleteNetworkInsightsAccessScope(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsAccessScopeRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInsightsAccessScopeRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkInsightsAccessScopeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAccessScopeResponse> deleteNetworkInsightsAccessScope(
            Consumer<DeleteNetworkInsightsAccessScopeRequest.Builder> deleteNetworkInsightsAccessScopeRequest) {
        return deleteNetworkInsightsAccessScope(DeleteNetworkInsightsAccessScopeRequest.builder()
                .applyMutation(deleteNetworkInsightsAccessScopeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAccessScopeAnalysisResponse> deleteNetworkInsightsAccessScopeAnalysis(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNetworkInsightsAccessScopeAnalysisRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAccessScopeAnalysisResponse> deleteNetworkInsightsAccessScopeAnalysis(
            Consumer<DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder> deleteNetworkInsightsAccessScopeAnalysisRequest) {
        return deleteNetworkInsightsAccessScopeAnalysis(DeleteNetworkInsightsAccessScopeAnalysisRequest.builder()
                .applyMutation(deleteNetworkInsightsAccessScopeAnalysisRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAnalysisResponse> deleteNetworkInsightsAnalysis(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInsightsAnalysisRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkInsightsAnalysisRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsAnalysisResponse> deleteNetworkInsightsAnalysis(
            Consumer<DeleteNetworkInsightsAnalysisRequest.Builder> deleteNetworkInsightsAnalysisRequest) {
        return deleteNetworkInsightsAnalysis(DeleteNetworkInsightsAnalysisRequest.builder()
                .applyMutation(deleteNetworkInsightsAnalysisRequest).build());
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsPathResponse> deleteNetworkInsightsPath(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsPathRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteNetworkInsightsPathRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkInsightsPathRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInsightsPathResponse> deleteNetworkInsightsPath(
            Consumer<DeleteNetworkInsightsPathRequest.Builder> deleteNetworkInsightsPathRequest) {
        return deleteNetworkInsightsPath(DeleteNetworkInsightsPathRequest.builder()
                .applyMutation(deleteNetworkInsightsPathRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInterfaceResponse> deleteNetworkInterface(
            DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkInterfaceRequest.Builder} to create a
     *        request. Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInterfaceResponse> deleteNetworkInterface(
            Consumer<DeleteNetworkInterfaceRequest.Builder> deleteNetworkInterfaceRequest) {
        return deleteNetworkInterface(DeleteNetworkInterfaceRequest.builder().applyMutation(deleteNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInterfacePermissionResponse> deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInterfacePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInterfacePermissionRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkInterfacePermissionRequest.Builder} to
     *        create a request. Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkInterfacePermissionResponse> deleteNetworkInterfacePermission(
            Consumer<DeleteNetworkInterfacePermissionRequest.Builder> deleteNetworkInterfacePermissionRequest) {
        return deleteNetworkInterfacePermission(DeleteNetworkInterfacePermissionRequest.builder()
                .applyMutation(deleteNetworkInterfacePermissionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePlacementGroupResponse> deletePlacementGroup(
            DeletePlacementGroupRequest deletePlacementGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlacementGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePlacementGroupRequest#builder()}
     * </p>
     *
     * @param deletePlacementGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlacementGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePlacementGroupResponse> deletePlacementGroup(
            Consumer<DeletePlacementGroupRequest.Builder> deletePlacementGroupRequest) {
        return deletePlacementGroup(DeletePlacementGroupRequest.builder().applyMutation(deletePlacementGroupRequest).build());
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     * @return A Java Future containing the result of the DeletePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePublicIpv4PoolResponse> deletePublicIpv4Pool(
            DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicIpv4PoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePublicIpv4PoolRequest#builder()}
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     *        A {@link Consumer} that will call methods on {@link DeletePublicIpv4PoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePublicIpv4PoolResponse> deletePublicIpv4Pool(
            Consumer<DeletePublicIpv4PoolRequest.Builder> deletePublicIpv4PoolRequest) {
        return deletePublicIpv4Pool(DeletePublicIpv4PoolRequest.builder().applyMutation(deletePublicIpv4PoolRequest).build());
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueuedReservedInstancesResponse> deleteQueuedReservedInstances(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueuedReservedInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQueuedReservedInstancesRequest#builder()}
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQueuedReservedInstancesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueuedReservedInstancesResponse> deleteQueuedReservedInstances(
            Consumer<DeleteQueuedReservedInstancesRequest.Builder> deleteQueuedReservedInstancesRequest) {
        return deleteQueuedReservedInstances(DeleteQueuedReservedInstancesRequest.builder()
                .applyMutation(deleteQueuedReservedInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRouteRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(Consumer<DeleteRouteRequest.Builder> deleteRouteRequest) {
        return deleteRoute(DeleteRouteRequest.builder().applyMutation(deleteRouteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteTableResponse> deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteTableRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRouteTableRequest#builder()}
     * </p>
     *
     * @param deleteRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteTableResponse> deleteRouteTable(
            Consumer<DeleteRouteTableRequest.Builder> deleteRouteTableRequest) {
        return deleteRouteTable(DeleteRouteTableRequest.builder().applyMutation(deleteRouteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance, or is referenced by another
     * security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or
     * <code>DependencyViolation</code> in EC2-VPC.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(
            DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance, or is referenced by another
     * security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or
     * <code>DependencyViolation</code> in EC2-VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(
            Consumer<DeleteSecurityGroupRequest.Builder> deleteSecurityGroupRequest) {
        return deleteSecurityGroup(DeleteSecurityGroupRequest.builder().applyMutation(deleteSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpotDatafeedSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSpotDatafeedSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSpotDatafeedSubscriptionRequest.Builder} to
     *        create a request. Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription(
            Consumer<DeleteSpotDatafeedSubscriptionRequest.Builder> deleteSpotDatafeedSubscriptionRequest) {
        return deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest.builder()
                .applyMutation(deleteSpotDatafeedSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription() {
        return deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSubnetResponse> deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSubnetRequest#builder()}
     * </p>
     *
     * @param deleteSubnetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubnetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSubnetResponse> deleteSubnet(Consumer<DeleteSubnetRequest.Builder> deleteSubnetRequest) {
        return deleteSubnet(DeleteSubnetRequest.builder().applyMutation(deleteSubnetRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     * @return A Java Future containing the result of the DeleteSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubnetCidrReservationResponse> deleteSubnetCidrReservation(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetCidrReservationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSubnetCidrReservationRequest#builder()}
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubnetCidrReservationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubnetCidrReservationResponse> deleteSubnetCidrReservation(
            Consumer<DeleteSubnetCidrReservationRequest.Builder> deleteSubnetCidrReservationRequest) {
        return deleteSubnetCidrReservation(DeleteSubnetCidrReservationRequest.builder()
                .applyMutation(deleteSubnetCidrReservationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorFilterResponse> deleteTrafficMirrorFilter(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorFilterRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorFilterRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrafficMirrorFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorFilterResponse> deleteTrafficMirrorFilter(
            Consumer<DeleteTrafficMirrorFilterRequest.Builder> deleteTrafficMirrorFilterRequest) {
        return deleteTrafficMirrorFilter(DeleteTrafficMirrorFilterRequest.builder()
                .applyMutation(deleteTrafficMirrorFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> deleteTrafficMirrorFilterRule(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorFilterRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTrafficMirrorFilterRuleRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrafficMirrorFilterRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> deleteTrafficMirrorFilterRule(
            Consumer<DeleteTrafficMirrorFilterRuleRequest.Builder> deleteTrafficMirrorFilterRuleRequest) {
        return deleteTrafficMirrorFilterRule(DeleteTrafficMirrorFilterRuleRequest.builder()
                .applyMutation(deleteTrafficMirrorFilterRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorSessionResponse> deleteTrafficMirrorSession(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorSessionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorSessionRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrafficMirrorSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorSessionResponse> deleteTrafficMirrorSession(
            Consumer<DeleteTrafficMirrorSessionRequest.Builder> deleteTrafficMirrorSessionRequest) {
        return deleteTrafficMirrorSession(DeleteTrafficMirrorSessionRequest.builder()
                .applyMutation(deleteTrafficMirrorSessionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorTargetResponse> deleteTrafficMirrorTarget(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorTargetRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrafficMirrorTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficMirrorTargetResponse> deleteTrafficMirrorTarget(
            Consumer<DeleteTrafficMirrorTargetRequest.Builder> deleteTrafficMirrorTargetRequest) {
        return deleteTrafficMirrorTarget(DeleteTrafficMirrorTargetRequest.builder()
                .applyMutation(deleteTrafficMirrorTargetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     *
     * @param deleteTransitGatewayRequest
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayResponse> deleteTransitGateway(
            DeleteTransitGatewayRequest deleteTransitGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTransitGatewayRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayResponse> deleteTransitGateway(
            Consumer<DeleteTransitGatewayRequest.Builder> deleteTransitGatewayRequest) {
        return deleteTransitGateway(DeleteTransitGatewayRequest.builder().applyMutation(deleteTransitGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayConnectResponse> deleteTransitGatewayConnect(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayConnectRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayConnectRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayConnectRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayConnectResponse> deleteTransitGatewayConnect(
            Consumer<DeleteTransitGatewayConnectRequest.Builder> deleteTransitGatewayConnectRequest) {
        return deleteTransitGatewayConnect(DeleteTransitGatewayConnectRequest.builder()
                .applyMutation(deleteTransitGatewayConnectRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayConnectPeerResponse> deleteTransitGatewayConnectPeer(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayConnectPeerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayConnectPeerResponse> deleteTransitGatewayConnectPeer(
            Consumer<DeleteTransitGatewayConnectPeerRequest.Builder> deleteTransitGatewayConnectPeerRequest) {
        return deleteTransitGatewayConnectPeer(DeleteTransitGatewayConnectPeerRequest.builder()
                .applyMutation(deleteTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> deleteTransitGatewayMulticastDomain(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayMulticastDomainRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayMulticastDomainRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> deleteTransitGatewayMulticastDomain(
            Consumer<DeleteTransitGatewayMulticastDomainRequest.Builder> deleteTransitGatewayMulticastDomainRequest) {
        return deleteTransitGatewayMulticastDomain(DeleteTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(deleteTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> deleteTransitGatewayPeeringAttachment(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayPeeringAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> deleteTransitGatewayPeeringAttachment(
            Consumer<DeleteTransitGatewayPeeringAttachmentRequest.Builder> deleteTransitGatewayPeeringAttachmentRequest) {
        return deleteTransitGatewayPeeringAttachment(DeleteTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(deleteTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayPrefixListReferenceResponse> deleteTransitGatewayPrefixListReference(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTransitGatewayPrefixListReferenceRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTransitGatewayPrefixListReferenceRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteTransitGatewayPrefixListReferenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayPrefixListReferenceResponse> deleteTransitGatewayPrefixListReference(
            Consumer<DeleteTransitGatewayPrefixListReferenceRequest.Builder> deleteTransitGatewayPrefixListReferenceRequest) {
        return deleteTransitGatewayPrefixListReference(DeleteTransitGatewayPrefixListReferenceRequest.builder()
                .applyMutation(deleteTransitGatewayPrefixListReferenceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayRouteResponse> deleteTransitGatewayRoute(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTransitGatewayRouteRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayRouteResponse> deleteTransitGatewayRoute(
            Consumer<DeleteTransitGatewayRouteRequest.Builder> deleteTransitGatewayRouteRequest) {
        return deleteTransitGatewayRoute(DeleteTransitGatewayRouteRequest.builder()
                .applyMutation(deleteTransitGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway
     * route tables before you can delete it.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayRouteTableResponse> deleteTransitGatewayRouteTable(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway
     * route tables before you can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayRouteTableRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayRouteTableResponse> deleteTransitGatewayRouteTable(
            Consumer<DeleteTransitGatewayRouteTableRequest.Builder> deleteTransitGatewayRouteTableRequest) {
        return deleteTransitGatewayRouteTable(DeleteTransitGatewayRouteTableRequest.builder()
                .applyMutation(deleteTransitGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayVpcAttachmentResponse> deleteTransitGatewayVpcAttachment(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTransitGatewayVpcAttachmentResponse> deleteTransitGatewayVpcAttachment(
            Consumer<DeleteTransitGatewayVpcAttachmentRequest.Builder> deleteTransitGatewayVpcAttachmentRequest) {
        return deleteTransitGatewayVpcAttachment(DeleteTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(deleteTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Delete an Amazon EBS
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteVolumeRequest
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Delete an Amazon EBS
     * volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVolumeRequest#builder()}
     * </p>
     *
     * @param deleteVolumeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVolumeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVolumeResponse> deleteVolume(Consumer<DeleteVolumeRequest.Builder> deleteVolumeRequest) {
        return deleteVolume(DeleteVolumeRequest.builder().applyMutation(deleteVolumeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on.
     * </p>
     *
     * @param deleteVpcRequest
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcResponse> deleteVpc(DeleteVpcRequest deleteVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcRequest#builder()}
     * </p>
     *
     * @param deleteVpcRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcResponse> deleteVpc(Consumer<DeleteVpcRequest.Builder> deleteVpcRequest) {
        return deleteVpc(DeleteVpcRequest.builder().applyMutation(deleteVpcRequest).build());
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint connection notifications.
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointConnectionNotifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointConnectionNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointConnectionNotificationsResponse> deleteVpcEndpointConnectionNotifications(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint connection notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVpcEndpointConnectionNotificationsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVpcEndpointConnectionNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVpcEndpointConnectionNotificationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVpcEndpointConnectionNotifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointConnectionNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointConnectionNotificationsResponse> deleteVpcEndpointConnectionNotifications(
            Consumer<DeleteVpcEndpointConnectionNotificationsRequest.Builder> deleteVpcEndpointConnectionNotificationsRequest) {
        return deleteVpcEndpointConnectionNotifications(DeleteVpcEndpointConnectionNotificationsRequest.builder()
                .applyMutation(deleteVpcEndpointConnectionNotificationsRequest).build());
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointServiceConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointServiceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointServiceConfigurationsResponse> deleteVpcEndpointServiceConfigurations(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVpcEndpointServiceConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVpcEndpointServiceConfigurationsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcEndpointServiceConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteVpcEndpointServiceConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointServiceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointServiceConfigurationsResponse> deleteVpcEndpointServiceConfigurations(
            Consumer<DeleteVpcEndpointServiceConfigurationsRequest.Builder> deleteVpcEndpointServiceConfigurationsRequest) {
        return deleteVpcEndpointServiceConfigurations(DeleteVpcEndpointServiceConfigurationsRequest.builder()
                .applyMutation(deleteVpcEndpointServiceConfigurationsRequest).build());
    }

    /**
     * <p>
     * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gateway endpoint,
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer endpoint,
     * </p>
     * </li>
     * <li>
     * <p>
     * Interface endpoint
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following rules apply when you delete a VPC endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with
     * the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.
     * </p>
     * <p>
     * You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you delete an interface endpoint, we delete the endpoint network interfaces.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteVpcEndpointsRequest
     *        Contains the parameters for DeleteVpcEndpoints.
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointsResponse> deleteVpcEndpoints(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gateway endpoint,
     * </p>
     * </li>
     * <li>
     * <p>
     * Gateway Load Balancer endpoint,
     * </p>
     * </li>
     * <li>
     * <p>
     * Interface endpoint
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following rules apply when you delete a VPC endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with
     * the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.
     * </p>
     * <p>
     * You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you delete an interface endpoint, we delete the endpoint network interfaces.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcEndpointsRequest.Builder} to create a
     *        request. Contains the parameters for DeleteVpcEndpoints.
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointsResponse> deleteVpcEndpoints(
            Consumer<DeleteVpcEndpointsRequest.Builder> deleteVpcEndpointsRequest) {
        return deleteVpcEndpoints(DeleteVpcEndpointsRequest.builder().applyMutation(deleteVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> state.
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            Consumer<DeleteVpcPeeringConnectionRequest.Builder> deleteVpcPeeringConnectionRequest) {
        return deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.builder()
                .applyMutation(deleteVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpnConnectionResponse> deleteVpnConnection(
            DeleteVpnConnectionRequest deleteVpnConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpnConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpnConnectionRequest.Builder} to create a
     *        request. Contains the parameters for DeleteVpnConnection.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpnConnectionResponse> deleteVpnConnection(
            Consumer<DeleteVpnConnectionRequest.Builder> deleteVpnConnectionRequest) {
        return deleteVpnConnection(DeleteVpnConnectionRequest.builder().applyMutation(deleteVpnConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVpnConnectionRouteResponse> deleteVpnConnectionRoute(
            DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnConnectionRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpnConnectionRouteRequest#builder()}
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpnConnectionRouteRequest.Builder} to create a
     *        request. Contains the parameters for DeleteVpnConnectionRoute.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVpnConnectionRouteResponse> deleteVpnConnectionRoute(
            Consumer<DeleteVpnConnectionRouteRequest.Builder> deleteVpnConnectionRouteRequest) {
        return deleteVpnConnectionRoute(DeleteVpnConnectionRouteRequest.builder().applyMutation(deleteVpnConnectionRouteRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpnGatewayResponse> deleteVpnGateway(DeleteVpnGatewayRequest deleteVpnGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpnGatewayRequest#builder()}
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for DeleteVpnGateway.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpnGatewayResponse> deleteVpnGateway(
            Consumer<DeleteVpnGatewayRequest.Builder> deleteVpnGatewayRequest) {
        return deleteVpnGateway(DeleteVpnGatewayRequest.builder().applyMutation(deleteVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link DeprovisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link DeprovisionByoipCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            Consumer<DeprovisionByoipCidrRequest.Builder> deprovisionByoipCidrRequest) {
        return deprovisionByoipCidr(DeprovisionByoipCidrRequest.builder().applyMutation(deprovisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the <i>Amazon VPC IPAM User
     * Guide</i>.
     * </p>
     *
     * @param deprovisionIpamPoolCidrRequest
     * @return A Java Future containing the result of the DeprovisionIpamPoolCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeprovisionIpamPoolCidrResponse> deprovisionIpamPoolCidr(
            DeprovisionIpamPoolCidrRequest deprovisionIpamPoolCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the <i>Amazon VPC IPAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionIpamPoolCidrRequest.Builder} avoiding
     * the need to create one manually via {@link DeprovisionIpamPoolCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionIpamPoolCidrRequest
     *        A {@link Consumer} that will call methods on {@link DeprovisionIpamPoolCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeprovisionIpamPoolCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeprovisionIpamPoolCidrResponse> deprovisionIpamPoolCidr(
            Consumer<DeprovisionIpamPoolCidrRequest.Builder> deprovisionIpamPoolCidrRequest) {
        return deprovisionIpamPoolCidr(DeprovisionIpamPoolCidrRequest.builder().applyMutation(deprovisionIpamPoolCidrRequest)
                .build());
    }

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     *
     * @param deprovisionPublicIpv4PoolCidrRequest
     * @return A Java Future containing the result of the DeprovisionPublicIpv4PoolCidr operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionPublicIpv4PoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeprovisionPublicIpv4PoolCidrResponse> deprovisionPublicIpv4PoolCidr(
            DeprovisionPublicIpv4PoolCidrRequest deprovisionPublicIpv4PoolCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionPublicIpv4PoolCidrRequest.Builder}
     * avoiding the need to create one manually via {@link DeprovisionPublicIpv4PoolCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionPublicIpv4PoolCidrRequest
     *        A {@link Consumer} that will call methods on {@link DeprovisionPublicIpv4PoolCidrRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeprovisionPublicIpv4PoolCidr operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionPublicIpv4PoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeprovisionPublicIpv4PoolCidrResponse> deprovisionPublicIpv4PoolCidr(
            Consumer<DeprovisionPublicIpv4PoolCidrRequest.Builder> deprovisionPublicIpv4PoolCidrRequest) {
        return deprovisionPublicIpv4PoolCidr(DeprovisionPublicIpv4PoolCidrRequest.builder()
                .applyMutation(deprovisionPublicIpv4PoolCidrRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the Amazon Elastic
     * Compute Cloud User Guide.
     * </p>
     * <p>
     * When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll
     * continue to incur usage costs for those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     *
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterImageResponse> deregisterImage(DeregisterImageRequest deregisterImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the Amazon Elastic
     * Compute Cloud User Guide.
     * </p>
     * <p>
     * When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll
     * continue to incur usage costs for those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterImageRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterImageRequest#builder()}
     * </p>
     *
     * @param deregisterImageRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterImageRequest.Builder} to create a request.
     *        Contains the parameters for DeregisterImage.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterImageResponse> deregisterImage(
            Consumer<DeregisterImageRequest.Builder> deregisterImageRequest) {
        return deregisterImage(DeregisterImageRequest.builder().applyMutation(deregisterImageRequest).build());
    }

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     *
     * @param deregisterInstanceEventNotificationAttributesRequest
     * @return A Java Future containing the result of the DeregisterInstanceEventNotificationAttributes operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterInstanceEventNotificationAttributesResponse> deregisterInstanceEventNotificationAttributes(
            DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterInstanceEventNotificationAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterInstanceEventNotificationAttributesRequest#builder()}
     * </p>
     *
     * @param deregisterInstanceEventNotificationAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeregisterInstanceEventNotificationAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterInstanceEventNotificationAttributes operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterInstanceEventNotificationAttributesResponse> deregisterInstanceEventNotificationAttributes(
            Consumer<DeregisterInstanceEventNotificationAttributesRequest.Builder> deregisterInstanceEventNotificationAttributesRequest) {
        return deregisterInstanceEventNotificationAttributes(DeregisterInstanceEventNotificationAttributesRequest.builder()
                .applyMutation(deregisterInstanceEventNotificationAttributesRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupMembers operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayMulticastGroupMembersResponse> deregisterTransitGatewayMulticastGroupMembers(
            DeregisterTransitGatewayMulticastGroupMembersRequest deregisterTransitGatewayMulticastGroupMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterTransitGatewayMulticastGroupMembersRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterTransitGatewayMulticastGroupMembersRequest#builder()}
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeregisterTransitGatewayMulticastGroupMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupMembers operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayMulticastGroupMembersResponse> deregisterTransitGatewayMulticastGroupMembers(
            Consumer<DeregisterTransitGatewayMulticastGroupMembersRequest.Builder> deregisterTransitGatewayMulticastGroupMembersRequest) {
        return deregisterTransitGatewayMulticastGroupMembers(DeregisterTransitGatewayMulticastGroupMembersRequest.builder()
                .applyMutation(deregisterTransitGatewayMulticastGroupMembersRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupSourcesRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupSources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupSources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayMulticastGroupSourcesResponse> deregisterTransitGatewayMulticastGroupSources(
            DeregisterTransitGatewayMulticastGroupSourcesRequest deregisterTransitGatewayMulticastGroupSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterTransitGatewayMulticastGroupSourcesRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterTransitGatewayMulticastGroupSourcesRequest#builder()}
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeregisterTransitGatewayMulticastGroupSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupSources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupSources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTransitGatewayMulticastGroupSourcesResponse> deregisterTransitGatewayMulticastGroupSources(
            Consumer<DeregisterTransitGatewayMulticastGroupSourcesRequest.Builder> deregisterTransitGatewayMulticastGroupSourcesRequest) {
        return deregisterTransitGatewayMulticastGroupSources(DeregisterTransitGatewayMulticastGroupSourcesRequest.builder()
                .applyMutation(deregisterTransitGatewayMulticastGroupSourcesRequest).build());
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and
     * EC2-VPC, or only into EC2-VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-Classic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and
     * EC2-VPC, or only into EC2-VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-Classic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-VPC.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and
     * EC2-VPC, or only into EC2-VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-Classic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes() {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAddressesRequest
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAddressesResponse> describeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAddressesRequest#builder()}
     * </p>
     *
     * @param describeAddressesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddressesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAddressesResponse> describeAddresses(
            Consumer<DescribeAddressesRequest.Builder> describeAddressesRequest) {
        return describeAddresses(DescribeAddressesRequest.builder().applyMutation(describeAddressesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAddressesResponse> describeAddresses() {
        return describeAddresses(DescribeAddressesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     *
     * @param describeAddressesAttributeRequest
     * @return A Java Future containing the result of the DescribeAddressesAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddressesAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAddressesAttributeResponse> describeAddressesAttribute(
            DescribeAddressesAttributeRequest describeAddressesAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressesAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAddressesAttributeRequest#builder()}
     * </p>
     *
     * @param describeAddressesAttributeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddressesAttributeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAddressesAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddressesAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAddressesAttributeResponse> describeAddressesAttribute(
            Consumer<DescribeAddressesAttributeRequest.Builder> describeAddressesAttributeRequest) {
        return describeAddressesAttribute(DescribeAddressesAttributeRequest.builder()
                .applyMutation(describeAddressesAttributeRequest).build());
    }

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddressesAttribute(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributePublisher publisher = client.describeAddressesAttributePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributePublisher publisher = client.describeAddressesAttributePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddressesAttribute(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAddressesAttributeRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddressesAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAddressesAttributePublisher describeAddressesAttributePaginator(
            DescribeAddressesAttributeRequest describeAddressesAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddressesAttribute(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributePublisher publisher = client.describeAddressesAttributePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributePublisher publisher = client.describeAddressesAttributePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddressesAttribute(software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressesAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAddressesAttributeRequest#builder()}
     * </p>
     *
     * @param describeAddressesAttributeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddressesAttributeRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddressesAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAddressesAttributePublisher describeAddressesAttributePaginator(
            Consumer<DescribeAddressesAttributeRequest.Builder> describeAddressesAttributeRequest) {
        return describeAddressesAttributePaginator(DescribeAddressesAttributeRequest.builder()
                .applyMutation(describeAddressesAttributeRequest).build());
    }

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     *
     * @param describeAggregateIdFormatRequest
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAggregateIdFormat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateIdFormatResponse> describeAggregateIdFormat(
            DescribeAggregateIdFormatRequest describeAggregateIdFormatRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregateIdFormatRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAggregateIdFormatRequest#builder()}
     * </p>
     *
     * @param describeAggregateIdFormatRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAggregateIdFormatRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAggregateIdFormat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateIdFormatResponse> describeAggregateIdFormat(
            Consumer<DescribeAggregateIdFormatRequest.Builder> describeAggregateIdFormatRequest) {
        return describeAggregateIdFormat(DescribeAggregateIdFormatRequest.builder()
                .applyMutation(describeAggregateIdFormatRequest).build());
    }

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAggregateIdFormat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateIdFormatResponse> describeAggregateIdFormat() {
        return describeAggregateIdFormat(DescribeAggregateIdFormatRequest.builder().build());
    }

    /**
     * <p>
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an
     * event impacting a zone, you can use this request to view the state and any provided messages for that zone.
     * </p>
     * <p>
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAvailabilityZonesRequest
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailabilityZonesResponse> describeAvailabilityZones(
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an
     * event impacting a zone, you can use this request to view the state and any provided messages for that zone.
     * </p>
     * <p>
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailabilityZonesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailabilityZonesRequest#builder()}
     * </p>
     *
     * @param describeAvailabilityZonesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailabilityZonesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailabilityZonesResponse> describeAvailabilityZones(
            Consumer<DescribeAvailabilityZonesRequest.Builder> describeAvailabilityZonesRequest) {
        return describeAvailabilityZones(DescribeAvailabilityZonesRequest.builder()
                .applyMutation(describeAvailabilityZonesRequest).build());
    }

    /**
     * <p>
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an
     * event impacting a zone, you can use this request to view the state and any provided messages for that zone.
     * </p>
     * <p>
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailabilityZonesResponse> describeAvailabilityZones() {
        return describeAvailabilityZones(DescribeAvailabilityZonesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note>
     *
     * @param describeBundleTasksRequest
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeBundleTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBundleTasksResponse> describeBundleTasks(
            DescribeBundleTasksRequest describeBundleTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBundleTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBundleTasksRequest#builder()}
     * </p>
     *
     * @param describeBundleTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBundleTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeBundleTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBundleTasksResponse> describeBundleTasks(
            Consumer<DescribeBundleTasksRequest.Builder> describeBundleTasksRequest) {
        return describeBundleTasks(DescribeBundleTasksRequest.builder().applyMutation(describeBundleTasksRequest).build());
    }

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeBundleTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBundleTasksResponse> describeBundleTasks() {
        return describeBundleTasks(DescribeBundleTasksRequest.builder().build());
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     *
     * @param describeByoipCidrsRequest
     * @return A Java Future containing the result of the DescribeByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeByoipCidrsResponse> describeByoipCidrs(DescribeByoipCidrsRequest describeByoipCidrsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeByoipCidrsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeByoipCidrsRequest#builder()}
     * </p>
     *
     * @param describeByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeByoipCidrsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeByoipCidrsResponse> describeByoipCidrs(
            Consumer<DescribeByoipCidrsRequest.Builder> describeByoipCidrsRequest) {
        return describeByoipCidrs(DescribeByoipCidrsRequest.builder().applyMutation(describeByoipCidrsRequest).build());
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation.</b>
     * </p>
     *
     * @param describeByoipCidrsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeByoipCidrsPublisher describeByoipCidrsPaginator(DescribeByoipCidrsRequest describeByoipCidrsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeByoipCidrsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeByoipCidrsRequest#builder()}
     * </p>
     *
     * @param describeByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeByoipCidrsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeByoipCidrsPublisher describeByoipCidrsPaginator(
            Consumer<DescribeByoipCidrsRequest.Builder> describeByoipCidrsRequest) {
        return describeByoipCidrsPaginator(DescribeByoipCidrsRequest.builder().applyMutation(describeByoipCidrsRequest).build());
    }

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     *
     * @param describeCapacityReservationFleetsRequest
     * @return A Java Future containing the result of the DescribeCapacityReservationFleets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationFleetsResponse> describeCapacityReservationFleets(
            DescribeCapacityReservationFleetsRequest describeCapacityReservationFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityReservationFleetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCapacityReservationFleetsRequest#builder()}
     * </p>
     *
     * @param describeCapacityReservationFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCapacityReservationFleetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCapacityReservationFleets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationFleetsResponse> describeCapacityReservationFleets(
            Consumer<DescribeCapacityReservationFleetsRequest.Builder> describeCapacityReservationFleetsRequest) {
        return describeCapacityReservationFleets(DescribeCapacityReservationFleetsRequest.builder()
                .applyMutation(describeCapacityReservationFleetsRequest).build());
    }

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservationFleets(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsPublisher publisher = client.describeCapacityReservationFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsPublisher publisher = client.describeCapacityReservationFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservationFleets(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCapacityReservationFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCapacityReservationFleetsPublisher describeCapacityReservationFleetsPaginator(
            DescribeCapacityReservationFleetsRequest describeCapacityReservationFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservationFleets(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsPublisher publisher = client.describeCapacityReservationFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsPublisher publisher = client.describeCapacityReservationFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservationFleets(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityReservationFleetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCapacityReservationFleetsRequest#builder()}
     * </p>
     *
     * @param describeCapacityReservationFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCapacityReservationFleetsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCapacityReservationFleetsPublisher describeCapacityReservationFleetsPaginator(
            Consumer<DescribeCapacityReservationFleetsRequest.Builder> describeCapacityReservationFleetsRequest) {
        return describeCapacityReservationFleetsPaginator(DescribeCapacityReservationFleetsRequest.builder()
                .applyMutation(describeCapacityReservationFleetsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     *
     * @param describeCapacityReservationsRequest
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationsResponse> describeCapacityReservations(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityReservationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCapacityReservationsRequest#builder()}
     * </p>
     *
     * @param describeCapacityReservationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCapacityReservationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationsResponse> describeCapacityReservations(
            Consumer<DescribeCapacityReservationsRequest.Builder> describeCapacityReservationsRequest) {
        return describeCapacityReservations(DescribeCapacityReservationsRequest.builder()
                .applyMutation(describeCapacityReservationsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationsResponse> describeCapacityReservations() {
        return describeCapacityReservations(DescribeCapacityReservationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCapacityReservationsPublisher describeCapacityReservationsPaginator() {
        return describeCapacityReservationsPaginator(DescribeCapacityReservationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCapacityReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCapacityReservationsPublisher describeCapacityReservationsPaginator(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityReservationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCapacityReservationsRequest#builder()}
     * </p>
     *
     * @param describeCapacityReservationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCapacityReservationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCapacityReservationsPublisher describeCapacityReservationsPaginator(
            Consumer<DescribeCapacityReservationsRequest.Builder> describeCapacityReservationsRequest) {
        return describeCapacityReservationsPaginator(DescribeCapacityReservationsRequest.builder()
                .applyMutation(describeCapacityReservationsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     *
     * @param describeCarrierGatewaysRequest
     * @return A Java Future containing the result of the DescribeCarrierGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCarrierGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCarrierGatewaysResponse> describeCarrierGateways(
            DescribeCarrierGatewaysRequest describeCarrierGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCarrierGatewaysRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCarrierGatewaysRequest#builder()}
     * </p>
     *
     * @param describeCarrierGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCarrierGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCarrierGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCarrierGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCarrierGatewaysResponse> describeCarrierGateways(
            Consumer<DescribeCarrierGatewaysRequest.Builder> describeCarrierGatewaysRequest) {
        return describeCarrierGateways(DescribeCarrierGatewaysRequest.builder().applyMutation(describeCarrierGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCarrierGateways(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysPublisher publisher = client.describeCarrierGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysPublisher publisher = client.describeCarrierGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCarrierGateways(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCarrierGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCarrierGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCarrierGatewaysPublisher describeCarrierGatewaysPaginator(
            DescribeCarrierGatewaysRequest describeCarrierGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCarrierGateways(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysPublisher publisher = client.describeCarrierGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysPublisher publisher = client.describeCarrierGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCarrierGateways(software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCarrierGatewaysRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCarrierGatewaysRequest#builder()}
     * </p>
     *
     * @param describeCarrierGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCarrierGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service an