/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface Ec2AsyncWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link Ec2AsyncClient#describeBundleTasks} API until the desired condition {@code BundleTaskComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBundleTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(
            DescribeBundleTasksRequest describeBundleTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeBundleTasks} API until the desired condition {@code BundleTaskComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBundleTasksRequest#builder()}
     *
     * @param describeBundleTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(
            Consumer<DescribeBundleTasksRequest.Builder> describeBundleTasksRequest) {
        return waitUntilBundleTaskComplete(DescribeBundleTasksRequest.builder().applyMutation(describeBundleTasksRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeBundleTasks} API until the desired condition {@code BundleTaskComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBundleTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(
            DescribeBundleTasksRequest describeBundleTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeBundleTasks} API until the desired condition {@code BundleTaskComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBundleTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(
            Consumer<DescribeBundleTasksRequest.Builder> describeBundleTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBundleTaskComplete(
                DescribeBundleTasksRequest.builder().applyMutation(describeBundleTasksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCancelled} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCancelled} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeConversionTasksRequest#builder()}
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest) {
        return waitUntilConversionTaskCancelled(DescribeConversionTasksRequest.builder()
                .applyMutation(describeConversionTasksRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCancelled} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCancelled} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilConversionTaskCancelled(
                DescribeConversionTasksRequest.builder().applyMutation(describeConversionTasksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeConversionTasksRequest#builder()}
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest) {
        return waitUntilConversionTaskCompleted(DescribeConversionTasksRequest.builder()
                .applyMutation(describeConversionTasksRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilConversionTaskCompleted(
                DescribeConversionTasksRequest.builder().applyMutation(describeConversionTasksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeConversionTasksRequest#builder()}
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest) {
        return waitUntilConversionTaskDeleted(DescribeConversionTasksRequest.builder()
                .applyMutation(describeConversionTasksRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeConversionTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeConversionTasks} API until the desired condition
     * {@code ConversionTaskDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeConversionTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(
            Consumer<DescribeConversionTasksRequest.Builder> describeConversionTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilConversionTaskDeleted(
                DescribeConversionTasksRequest.builder().applyMutation(describeConversionTasksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeCustomerGateways} API until the desired condition
     * {@code CustomerGatewayAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeCustomerGatewaysRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeCustomerGateways} API until the desired condition
     * {@code CustomerGatewayAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeCustomerGatewaysRequest#builder()}
     *
     * @param describeCustomerGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(
            Consumer<DescribeCustomerGatewaysRequest.Builder> describeCustomerGatewaysRequest) {
        return waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest.builder()
                .applyMutation(describeCustomerGatewaysRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeCustomerGateways} API until the desired condition
     * {@code CustomerGatewayAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeCustomerGatewaysRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeCustomerGateways} API until the desired condition
     * {@code CustomerGatewayAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeCustomerGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(
            Consumer<DescribeCustomerGatewaysRequest.Builder> describeCustomerGatewaysRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilCustomerGatewayAvailable(
                DescribeCustomerGatewaysRequest.builder().applyMutation(describeCustomerGatewaysRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(
            DescribeExportTasksRequest describeExportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeExportTasksRequest#builder()}
     *
     * @param describeExportTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return waitUntilExportTaskCancelled(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(
            DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeExportTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilExportTaskCancelled(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportTasksRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(
            DescribeExportTasksRequest describeExportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeExportTasksRequest#builder()}
     *
     * @param describeExportTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return waitUntilExportTaskCompleted(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportTasksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(
            DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeExportTasks} API until the desired condition {@code ExportTaskCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeExportTasksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilExportTaskCompleted(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeImagesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(
            DescribeImagesRequest describeImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeImagesRequest#builder()}
     *
     * @param describeImagesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(
            Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return waitUntilImageAvailable(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeImagesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(
            DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeImagesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(
            Consumer<DescribeImagesRequest.Builder> describeImagesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilImageAvailable(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageExists} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeImagesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(
            DescribeImagesRequest describeImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageExists} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeImagesRequest#builder()}
     *
     * @param describeImagesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(
            Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return waitUntilImageExists(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageExists} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeImagesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(
            DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeImages} API until the desired condition {@code ImageExists} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeImagesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(
            Consumer<DescribeImagesRequest.Builder> describeImagesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilImageExists(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(
            DescribeInstancesRequest describeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstancesRequest#builder()}
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return waitUntilInstanceExists(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(
            DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInstanceExists(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceRunning} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(
            DescribeInstancesRequest describeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceRunning} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstancesRequest#builder()}
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return waitUntilInstanceRunning(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceRunning} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(
            DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceRunning} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInstanceRunning(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code InstanceStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstanceStatusRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code InstanceStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstanceStatusRequest#builder()}
     *
     * @param describeInstanceStatusRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(
            Consumer<DescribeInstanceStatusRequest.Builder> describeInstanceStatusRequest) {
        return waitUntilInstanceStatusOk(DescribeInstanceStatusRequest.builder().applyMutation(describeInstanceStatusRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code InstanceStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstanceStatusRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code InstanceStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstanceStatusRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(
            Consumer<DescribeInstanceStatusRequest.Builder> describeInstanceStatusRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInstanceStatusOk(DescribeInstanceStatusRequest.builder().applyMutation(describeInstanceStatusRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceStopped} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(
            DescribeInstancesRequest describeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceStopped} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstancesRequest#builder()}
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return waitUntilInstanceStopped(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceStopped} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(
            DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceStopped} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInstanceStopped(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceTerminated} is met,
     * or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(
            DescribeInstancesRequest describeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceTerminated} is met,
     * or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstancesRequest#builder()}
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return waitUntilInstanceTerminated(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceTerminated} is met,
     * or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstancesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(
            DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstances} API until the desired condition {@code InstanceTerminated} is met,
     * or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstancesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInstanceTerminated(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInternetGateways} API until the desired condition
     * {@code InternetGatewayExists} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeInternetGatewaysRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInternetGateways} API until the desired condition
     * {@code InternetGatewayExists} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInternetGatewaysRequest#builder()}
     *
     * @param describeInternetGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(
            Consumer<DescribeInternetGatewaysRequest.Builder> describeInternetGatewaysRequest) {
        return waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest.builder()
                .applyMutation(describeInternetGatewaysRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInternetGateways} API until the desired condition
     * {@code InternetGatewayExists} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeInternetGatewaysRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInternetGateways} API until the desired condition
     * {@code InternetGatewayExists} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInternetGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(
            Consumer<DescribeInternetGatewaysRequest.Builder> describeInternetGatewaysRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilInternetGatewayExists(
                DescribeInternetGatewaysRequest.builder().applyMutation(describeInternetGatewaysRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeKeyPairs} API until the desired condition {@code KeyPairExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeKeyPairsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(
            DescribeKeyPairsRequest describeKeyPairsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeKeyPairs} API until the desired condition {@code KeyPairExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeKeyPairsRequest#builder()}
     *
     * @param describeKeyPairsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(
            Consumer<DescribeKeyPairsRequest.Builder> describeKeyPairsRequest) {
        return waitUntilKeyPairExists(DescribeKeyPairsRequest.builder().applyMutation(describeKeyPairsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeKeyPairs} API until the desired condition {@code KeyPairExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeKeyPairsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(
            DescribeKeyPairsRequest describeKeyPairsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeKeyPairs} API until the desired condition {@code KeyPairExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeKeyPairsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(
            Consumer<DescribeKeyPairsRequest.Builder> describeKeyPairsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilKeyPairExists(DescribeKeyPairsRequest.builder().applyMutation(describeKeyPairsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeNatGatewaysRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeNatGatewaysRequest#builder()}
     *
     * @param describeNatGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(
            Consumer<DescribeNatGatewaysRequest.Builder> describeNatGatewaysRequest) {
        return waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest.builder().applyMutation(describeNatGatewaysRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeNatGatewaysRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(
            DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeNatGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(
            Consumer<DescribeNatGatewaysRequest.Builder> describeNatGatewaysRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest.builder().applyMutation(describeNatGatewaysRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeNatGatewaysRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeNatGatewaysRequest#builder()}
     *
     * @param describeNatGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(
            Consumer<DescribeNatGatewaysRequest.Builder> describeNatGatewaysRequest) {
        return waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest.builder().applyMutation(describeNatGatewaysRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeNatGatewaysRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(
            DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNatGateways} API until the desired condition {@code NatGatewayDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeNatGatewaysRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(
            Consumer<DescribeNatGatewaysRequest.Builder> describeNatGatewaysRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest.builder().applyMutation(describeNatGatewaysRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNetworkInterfaces} API until the desired condition
     * {@code NetworkInterfaceAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeNetworkInterfacesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNetworkInterfaces} API until the desired condition
     * {@code NetworkInterfaceAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeNetworkInterfacesRequest#builder()}
     *
     * @param describeNetworkInterfacesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(
            Consumer<DescribeNetworkInterfacesRequest.Builder> describeNetworkInterfacesRequest) {
        return waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest.builder()
                .applyMutation(describeNetworkInterfacesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNetworkInterfaces} API until the desired condition
     * {@code NetworkInterfaceAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeNetworkInterfacesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeNetworkInterfaces} API until the desired condition
     * {@code NetworkInterfaceAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeNetworkInterfacesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(
            Consumer<DescribeNetworkInterfacesRequest.Builder> describeNetworkInterfacesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilNetworkInterfaceAvailable(
                DescribeNetworkInterfacesRequest.builder().applyMutation(describeNetworkInterfacesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#getPasswordData} API until the desired condition {@code PasswordDataAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getPasswordDataRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(
            GetPasswordDataRequest getPasswordDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#getPasswordData} API until the desired condition {@code PasswordDataAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetPasswordDataRequest#builder()}
     *
     * @param getPasswordDataRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(
            Consumer<GetPasswordDataRequest.Builder> getPasswordDataRequest) {
        return waitUntilPasswordDataAvailable(GetPasswordDataRequest.builder().applyMutation(getPasswordDataRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#getPasswordData} API until the desired condition {@code PasswordDataAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getPasswordDataRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(
            GetPasswordDataRequest getPasswordDataRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#getPasswordData} API until the desired condition {@code PasswordDataAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getPasswordDataRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(
            Consumer<GetPasswordDataRequest.Builder> getPasswordDataRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilPasswordDataAvailable(GetPasswordDataRequest.builder().applyMutation(getPasswordDataRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSecurityGroups} API until the desired condition {@code SecurityGroupExists}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeSecurityGroupsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSecurityGroups} API until the desired condition {@code SecurityGroupExists}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeSecurityGroupsRequest#builder()}
     *
     * @param describeSecurityGroupsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(
            Consumer<DescribeSecurityGroupsRequest.Builder> describeSecurityGroupsRequest) {
        return waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest.builder().applyMutation(describeSecurityGroupsRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSecurityGroups} API until the desired condition {@code SecurityGroupExists}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeSecurityGroupsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSecurityGroups} API until the desired condition {@code SecurityGroupExists}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeSecurityGroupsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(
            Consumer<DescribeSecurityGroupsRequest.Builder> describeSecurityGroupsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest.builder().applyMutation(describeSecurityGroupsRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSnapshots} API until the desired condition {@code SnapshotCompleted} is met,
     * or until it is determined that the resource will never enter into the desired state
     *
     * @param describeSnapshotsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(
            DescribeSnapshotsRequest describeSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSnapshots} API until the desired condition {@code SnapshotCompleted} is met,
     * or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeSnapshotsRequest#builder()}
     *
     * @param describeSnapshotsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return waitUntilSnapshotCompleted(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSnapshots} API until the desired condition {@code SnapshotCompleted} is met,
     * or until it is determined that the resource will never enter into the desired state
     *
     * @param describeSnapshotsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(
            DescribeSnapshotsRequest describeSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSnapshots} API until the desired condition {@code SnapshotCompleted} is met,
     * or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeSnapshotsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilSnapshotCompleted(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSpotInstanceRequests} API until the desired condition
     * {@code SpotInstanceRequestFulfilled} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param describeSpotInstanceRequestsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSpotInstanceRequests} API until the desired condition
     * {@code SpotInstanceRequestFulfilled} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeSpotInstanceRequestsRequest#builder()}
     *
     * @param describeSpotInstanceRequestsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(
            Consumer<DescribeSpotInstanceRequestsRequest.Builder> describeSpotInstanceRequestsRequest) {
        return waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest.builder()
                .applyMutation(describeSpotInstanceRequestsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSpotInstanceRequests} API until the desired condition
     * {@code SpotInstanceRequestFulfilled} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param describeSpotInstanceRequestsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSpotInstanceRequests} API until the desired condition
     * {@code SpotInstanceRequestFulfilled} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeSpotInstanceRequestsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(
            Consumer<DescribeSpotInstanceRequestsRequest.Builder> describeSpotInstanceRequestsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilSpotInstanceRequestFulfilled(
                DescribeSpotInstanceRequestsRequest.builder().applyMutation(describeSpotInstanceRequestsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSubnets} API until the desired condition {@code SubnetAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeSubnetsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(
            DescribeSubnetsRequest describeSubnetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSubnets} API until the desired condition {@code SubnetAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeSubnetsRequest#builder()}
     *
     * @param describeSubnetsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(
            Consumer<DescribeSubnetsRequest.Builder> describeSubnetsRequest) {
        return waitUntilSubnetAvailable(DescribeSubnetsRequest.builder().applyMutation(describeSubnetsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSubnets} API until the desired condition {@code SubnetAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeSubnetsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(
            DescribeSubnetsRequest describeSubnetsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeSubnets} API until the desired condition {@code SubnetAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeSubnetsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(
            Consumer<DescribeSubnetsRequest.Builder> describeSubnetsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilSubnetAvailable(DescribeSubnetsRequest.builder().applyMutation(describeSubnetsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code SystemStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstanceStatusRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code SystemStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeInstanceStatusRequest#builder()}
     *
     * @param describeInstanceStatusRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(
            Consumer<DescribeInstanceStatusRequest.Builder> describeInstanceStatusRequest) {
        return waitUntilSystemStatusOk(DescribeInstanceStatusRequest.builder().applyMutation(describeInstanceStatusRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code SystemStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeInstanceStatusRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeInstanceStatus} API until the desired condition {@code SystemStatusOk} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeInstanceStatusRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(
            Consumer<DescribeInstanceStatusRequest.Builder> describeInstanceStatusRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilSystemStatusOk(DescribeInstanceStatusRequest.builder().applyMutation(describeInstanceStatusRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(
            DescribeVolumesRequest describeVolumesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVolumesRequest#builder()}
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest) {
        return waitUntilVolumeAvailable(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(
            DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVolumeAvailable(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(
            DescribeVolumesRequest describeVolumesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVolumesRequest#builder()}
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest) {
        return waitUntilVolumeDeleted(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(
            DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVolumeDeleted(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeInUse} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(
            DescribeVolumesRequest describeVolumesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeInUse} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVolumesRequest#builder()}
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest) {
        return waitUntilVolumeInUse(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeInUse} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeVolumesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(
            DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVolumes} API until the desired condition {@code VolumeInUse} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVolumesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(
            Consumer<DescribeVolumesRequest.Builder> describeVolumesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVolumeInUse(DescribeVolumesRequest.builder().applyMutation(describeVolumesRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeVpcsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpcsRequest#builder()}
     *
     * @param describeVpcsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(
            Consumer<DescribeVpcsRequest.Builder> describeVpcsRequest) {
        return waitUntilVpcAvailable(DescribeVpcsRequest.builder().applyMutation(describeVpcsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param describeVpcsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(
            DescribeVpcsRequest describeVpcsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpcsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(
            Consumer<DescribeVpcsRequest.Builder> describeVpcsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpcAvailable(DescribeVpcsRequest.builder().applyMutation(describeVpcsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcExists} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param describeVpcsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcExists} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpcsRequest#builder()}
     *
     * @param describeVpcsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(
            Consumer<DescribeVpcsRequest.Builder> describeVpcsRequest) {
        return waitUntilVpcExists(DescribeVpcsRequest.builder().applyMutation(describeVpcsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcExists} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param describeVpcsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcs} API until the desired condition {@code VpcExists} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpcsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(
            Consumer<DescribeVpcsRequest.Builder> describeVpcsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpcExists(DescribeVpcsRequest.builder().applyMutation(describeVpcsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpcPeeringConnectionsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpcPeeringConnectionsRequest#builder()}
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest) {
        return waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest.builder()
                .applyMutation(describeVpcPeeringConnectionsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpcPeeringConnectionDeleted(
                DescribeVpcPeeringConnectionsRequest.builder().applyMutation(describeVpcPeeringConnectionsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionExists} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpcPeeringConnectionsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionExists} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpcPeeringConnectionsRequest#builder()}
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest) {
        return waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest.builder()
                .applyMutation(describeVpcPeeringConnectionsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionExists} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpcPeeringConnections} API until the desired condition
     * {@code VpcPeeringConnectionExists} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpcPeeringConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpcPeeringConnectionExists(
                DescribeVpcPeeringConnectionsRequest.builder().applyMutation(describeVpcPeeringConnectionsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition
     * {@code VpnConnectionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpnConnectionsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition
     * {@code VpnConnectionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpnConnectionsRequest#builder()}
     *
     * @param describeVpnConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(
            Consumer<DescribeVpnConnectionsRequest.Builder> describeVpnConnectionsRequest) {
        return waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest.builder()
                .applyMutation(describeVpnConnectionsRequest).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition
     * {@code VpnConnectionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeVpnConnectionsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition
     * {@code VpnConnectionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpnConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(
            Consumer<DescribeVpnConnectionsRequest.Builder> describeVpnConnectionsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpnConnectionAvailable(
                DescribeVpnConnectionsRequest.builder().applyMutation(describeVpnConnectionsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition {@code VpnConnectionDeleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeVpnConnectionsRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition {@code VpnConnectionDeleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeVpnConnectionsRequest#builder()}
     *
     * @param describeVpnConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(
            Consumer<DescribeVpnConnectionsRequest.Builder> describeVpnConnectionsRequest) {
        return waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest.builder().applyMutation(describeVpnConnectionsRequest)
                .build());
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition {@code VpnConnectionDeleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeVpnConnectionsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link Ec2AsyncClient#describeVpnConnections} API until the desired condition {@code VpnConnectionDeleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeVpnConnectionsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(
            Consumer<DescribeVpnConnectionsRequest.Builder> describeVpnConnectionsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest.builder().applyMutation(describeVpnConnectionsRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link Ec2AsyncWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultEc2AsyncWaiter.builder();
    }

    /**
     * Create an instance of {@link Ec2AsyncWaiter} with the default configuration.
     * <p>
     * <b>A default {@link Ec2AsyncClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link Ec2AsyncWaiter}
     */
    static Ec2AsyncWaiter create() {
        return DefaultEc2AsyncWaiter.builder().build();
    }

    interface Builder {
        /**
         * Sets a custom {@link ScheduledExecutorService} that will be used to schedule async polling attempts
         * <p>
         * This executorService must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * executorService when the waiter is closed
         *
         * @param executorService
         *        the executorService to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder scheduledExecutorService(ScheduledExecutorService executorService);

        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link Ec2AsyncClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(Ec2AsyncClient client);

        /**
         * Builds an instance of {@link Ec2AsyncWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link Ec2AsyncWaiter}
         */
        Ec2AsyncWaiter build();
    }
}
