/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTransitGatewayVpcAttachmentRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyTransitGatewayVpcAttachmentRequest.Builder, ModifyTransitGatewayVpcAttachmentRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequest::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("TransitGatewayAttachmentId").build()).build();

    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSubnetIds")
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequest::addSubnetIds))
            .setter(setter(Builder::addSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetIds")
                    .unmarshallLocationName("AddSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSubnetIds")
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequest::removeSubnetIds))
            .setter(setter(Builder::removeSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetIds")
                    .unmarshallLocationName("RemoveSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<ModifyTransitGatewayVpcAttachmentRequestOptions> OPTIONS_FIELD = SdkField
            .<ModifyTransitGatewayVpcAttachmentRequestOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options")
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequest::options))
            .setter(setter(Builder::options))
            .constructor(ModifyTransitGatewayVpcAttachmentRequestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, OPTIONS_FIELD));

    private final String transitGatewayAttachmentId;

    private final List<String> addSubnetIds;

    private final List<String> removeSubnetIds;

    private final ModifyTransitGatewayVpcAttachmentRequestOptions options;

    private ModifyTransitGatewayVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSubnetIds() {
        return addSubnetIds != null && !(addSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnetIds} method.
     * </p>
     * 
     * @return The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
     */
    public final List<String> addSubnetIds() {
        return addSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnetIds() {
        return removeSubnetIds != null && !(removeSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more subnets to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnetIds} method.
     * </p>
     * 
     * @return The IDs of one or more subnets to remove.
     */
    public final List<String> removeSubnetIds() {
        return removeSubnetIds;
    }

    /**
     * <p>
     * The new VPC attachment options.
     * </p>
     * <note>
     * <p>
     * You cannot modify the IPv6 options.
     * </p>
     * </note>
     * 
     * @return The new VPC attachment options.</p> <note>
     *         <p>
     *         You cannot modify the IPv6 options.
     *         </p>
     */
    public final ModifyTransitGatewayVpcAttachmentRequestOptions options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnetIds() ? addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnetIds() ? removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayVpcAttachmentRequest)) {
            return false;
        }
        ModifyTransitGatewayVpcAttachmentRequest other = (ModifyTransitGatewayVpcAttachmentRequest) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(addSubnetIds(), other.addSubnetIds())
                && hasRemoveSubnetIds() == other.hasRemoveSubnetIds()
                && Objects.equals(removeSubnetIds(), other.removeSubnetIds()) && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTransitGatewayVpcAttachmentRequest")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("AddSubnetIds", hasAddSubnetIds() ? addSubnetIds() : null)
                .add("RemoveSubnetIds", hasRemoveSubnetIds() ? removeSubnetIds() : null).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "AddSubnetIds":
            return Optional.ofNullable(clazz.cast(addSubnetIds()));
        case "RemoveSubnetIds":
            return Optional.ofNullable(clazz.cast(removeSubnetIds()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayVpcAttachmentRequest, T> g) {
        return obj -> g.apply((ModifyTransitGatewayVpcAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequest> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
         * </p>
         * 
         * @param addSubnetIds
         *        The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(Collection<String> addSubnetIds);

        /**
         * <p>
         * The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
         * </p>
         * 
         * @param addSubnetIds
         *        The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(String... addSubnetIds);

        /**
         * <p>
         * The IDs of one or more subnets to remove.
         * </p>
         * 
         * @param removeSubnetIds
         *        The IDs of one or more subnets to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(Collection<String> removeSubnetIds);

        /**
         * <p>
         * The IDs of one or more subnets to remove.
         * </p>
         * 
         * @param removeSubnetIds
         *        The IDs of one or more subnets to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(String... removeSubnetIds);

        /**
         * <p>
         * The new VPC attachment options.
         * </p>
         * <note>
         * <p>
         * You cannot modify the IPv6 options.
         * </p>
         * </note>
         * 
         * @param options
         *        The new VPC attachment options.</p> <note>
         *        <p>
         *        You cannot modify the IPv6 options.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(ModifyTransitGatewayVpcAttachmentRequestOptions options);

        /**
         * <p>
         * The new VPC attachment options.
         * </p>
         * <note>
         * <p>
         * You cannot modify the IPv6 options.
         * </p>
         * </note> This is a convenience that creates an instance of the
         * {@link ModifyTransitGatewayVpcAttachmentRequestOptions.Builder} avoiding the need to create one manually via
         * {@link ModifyTransitGatewayVpcAttachmentRequestOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModifyTransitGatewayVpcAttachmentRequestOptions.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #options(ModifyTransitGatewayVpcAttachmentRequestOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link ModifyTransitGatewayVpcAttachmentRequestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(ModifyTransitGatewayVpcAttachmentRequestOptions)
         */
        default Builder options(Consumer<ModifyTransitGatewayVpcAttachmentRequestOptions.Builder> options) {
            return options(ModifyTransitGatewayVpcAttachmentRequestOptions.builder().applyMutation(options).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private ModifyTransitGatewayVpcAttachmentRequestOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayVpcAttachmentRequest model) {
            super(model);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            addSubnetIds(model.addSubnetIds);
            removeSubnetIds(model.removeSubnetIds);
            options(model.options);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = TransitGatewaySubnetIdListCopier.copy(addSubnetIds);
        }

        @Override
        @Transient
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = TransitGatewaySubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSubnetIds(String... addSubnetIds) {
            addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = TransitGatewaySubnetIdListCopier.copy(removeSubnetIds);
        }

        @Override
        @Transient
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = TransitGatewaySubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSubnetIds(String... removeSubnetIds) {
            removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final ModifyTransitGatewayVpcAttachmentRequestOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(ModifyTransitGatewayVpcAttachmentRequestOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(ModifyTransitGatewayVpcAttachmentRequestOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTransitGatewayVpcAttachmentRequest build() {
            return new ModifyTransitGatewayVpcAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
