/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a network ACL and a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkAclAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkAclAssociation.Builder, NetworkAclAssociation> {
    private static final SdkField<String> NETWORK_ACL_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclAssociationId")
            .getter(getter(NetworkAclAssociation::networkAclAssociationId))
            .setter(setter(Builder::networkAclAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclAssociationId")
                    .unmarshallLocationName("networkAclAssociationId").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclId")
            .getter(getter(NetworkAclAssociation::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId")
                    .unmarshallLocationName("networkAclId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(NetworkAclAssociation::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_ACL_ASSOCIATION_ID_FIELD, NETWORK_ACL_ID_FIELD, SUBNET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkAclAssociationId;

    private final String networkAclId;

    private final String subnetId;

    private NetworkAclAssociation(BuilderImpl builder) {
        this.networkAclAssociationId = builder.networkAclAssociationId;
        this.networkAclId = builder.networkAclId;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The ID of the association between a network ACL and a subnet.
     * </p>
     * 
     * @return The ID of the association between a network ACL and a subnet.
     */
    public final String networkAclAssociationId() {
        return networkAclAssociationId;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public final String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAclAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclAssociation)) {
            return false;
        }
        NetworkAclAssociation other = (NetworkAclAssociation) obj;
        return Objects.equals(networkAclAssociationId(), other.networkAclAssociationId())
                && Objects.equals(networkAclId(), other.networkAclId()) && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkAclAssociation").add("NetworkAclAssociationId", networkAclAssociationId())
                .add("NetworkAclId", networkAclId()).add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAclAssociationId":
            return Optional.ofNullable(clazz.cast(networkAclAssociationId()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAclAssociation, T> g) {
        return obj -> g.apply((NetworkAclAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkAclAssociation> {
        /**
         * <p>
         * The ID of the association between a network ACL and a subnet.
         * </p>
         * 
         * @param networkAclAssociationId
         *        The ID of the association between a network ACL and a subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclAssociationId(String networkAclAssociationId);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private String networkAclAssociationId;

        private String networkAclId;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclAssociation model) {
            networkAclAssociationId(model.networkAclAssociationId);
            networkAclId(model.networkAclId);
            subnetId(model.subnetId);
        }

        public final String getNetworkAclAssociationId() {
            return networkAclAssociationId;
        }

        public final void setNetworkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
        }

        @Override
        @Transient
        public final Builder networkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
            return this;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        @Transient
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public NetworkAclAssociation build() {
            return new NetworkAclAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
