/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGateway implements SdkPojo, Serializable, ToCopyableBuilder<TransitGateway.Builder, TransitGateway> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(TransitGateway::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayArn")
            .getter(getter(TransitGateway::transitGatewayArn))
            .setter(setter(Builder::transitGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn")
                    .unmarshallLocationName("transitGatewayArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGateway::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(TransitGateway::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(TransitGateway::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGateway::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<TransitGatewayOptions> OPTIONS_FIELD = SdkField
            .<TransitGatewayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options")
            .getter(getter(TransitGateway::options))
            .setter(setter(Builder::options))
            .constructor(TransitGatewayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("options").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGateway::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD,
            TRANSIT_GATEWAY_ARN_FIELD, STATE_FIELD, OWNER_ID_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, OPTIONS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayId;

    private final String transitGatewayArn;

    private final String state;

    private final String ownerId;

    private final String description;

    private final Instant creationTime;

    private final TransitGatewayOptions options;

    private final List<Tag> tags;

    private TransitGateway(BuilderImpl builder) {
        this.transitGatewayId = builder.transitGatewayId;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.options = builder.options;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transit gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transit gateway.
     */
    public final String transitGatewayArn() {
        return transitGatewayArn;
    }

    /**
     * <p>
     * The state of the transit gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway.
     * @see TransitGatewayState
     */
    public final TransitGatewayState state() {
        return TransitGatewayState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway.
     * @see TransitGatewayState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the AWS account ID that owns the transit gateway.
     * </p>
     * 
     * @return The ID of the AWS account ID that owns the transit gateway.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The description of the transit gateway.
     * </p>
     * 
     * @return The description of the transit gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The transit gateway options.
     * </p>
     * 
     * @return The transit gateway options.
     */
    public final TransitGatewayOptions options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the transit gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the transit gateway.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGateway)) {
            return false;
        }
        TransitGateway other = (TransitGateway) obj;
        return Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(transitGatewayArn(), other.transitGatewayArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(options(), other.options()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGateway").add("TransitGatewayId", transitGatewayId())
                .add("TransitGatewayArn", transitGatewayArn()).add("State", stateAsString()).add("OwnerId", ownerId())
                .add("Description", description()).add("CreationTime", creationTime()).add("Options", options())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "TransitGatewayArn":
            return Optional.ofNullable(clazz.cast(transitGatewayArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGateway, T> g) {
        return obj -> g.apply((TransitGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGateway> {
        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transit gateway.
         * </p>
         * 
         * @param transitGatewayArn
         *        The Amazon Resource Name (ARN) of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayArn(String transitGatewayArn);

        /**
         * <p>
         * The state of the transit gateway.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway.
         * @see TransitGatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway.
         * @see TransitGatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayState
         */
        Builder state(TransitGatewayState state);

        /**
         * <p>
         * The ID of the AWS account ID that owns the transit gateway.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account ID that owns the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The description of the transit gateway.
         * </p>
         * 
         * @param description
         *        The description of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The transit gateway options.
         * </p>
         * 
         * @param options
         *        The transit gateway options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(TransitGatewayOptions options);

        /**
         * <p>
         * The transit gateway options.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayOptions.Builder} avoiding the need
         * to create one manually via {@link TransitGatewayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #options(TransitGatewayOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link TransitGatewayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(TransitGatewayOptions)
         */
        default Builder options(Consumer<TransitGatewayOptions.Builder> options) {
            return options(TransitGatewayOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The tags for the transit gateway.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the transit gateway.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the transit gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayId;

        private String transitGatewayArn;

        private String state;

        private String ownerId;

        private String description;

        private Instant creationTime;

        private TransitGatewayOptions options;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGateway model) {
            transitGatewayId(model.transitGatewayId);
            transitGatewayArn(model.transitGatewayArn);
            state(model.state);
            ownerId(model.ownerId);
            description(model.description);
            creationTime(model.creationTime);
            options(model.options);
            tags(model.tags);
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        @Transient
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getTransitGatewayArn() {
            return transitGatewayArn;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        @Override
        @Transient
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(TransitGatewayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final TransitGatewayOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(TransitGatewayOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(TransitGatewayOptions options) {
            this.options = options;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGateway build() {
            return new TransitGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
