/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an export instance task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportToS3TaskSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportToS3TaskSpecification.Builder, ExportToS3TaskSpecification> {
    private static final SdkField<String> CONTAINER_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContainerFormat")
            .getter(getter(ExportToS3TaskSpecification::containerFormatAsString))
            .setter(setter(Builder::containerFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFormat")
                    .unmarshallLocationName("containerFormat").build()).build();

    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DiskImageFormat")
            .getter(getter(ExportToS3TaskSpecification::diskImageFormatAsString))
            .setter(setter(Builder::diskImageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat")
                    .unmarshallLocationName("diskImageFormat").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket")
            .getter(getter(ExportToS3TaskSpecification::s3Bucket))
            .setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket")
                    .unmarshallLocationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix")
            .getter(getter(ExportToS3TaskSpecification::s3Prefix))
            .setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix")
                    .unmarshallLocationName("s3Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FORMAT_FIELD,
            DISK_IMAGE_FORMAT_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerFormat;

    private final String diskImageFormat;

    private final String s3Bucket;

    private final String s3Prefix;

    private ExportToS3TaskSpecification(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public final ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(containerFormat);
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public final String containerFormatAsString() {
        return containerFormat;
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public final DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public final String diskImageFormatAsString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     * permissions to the Amazon Web Services account <code>vm-import-export@amazon.com</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
     *         READ_ACP permissions to the Amazon Web Services account <code>vm-import-export@amazon.com</code>.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
     * diskImageFormat.
     * </p>
     * 
     * @return The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix + exportTaskId +
     *         '.' + diskImageFormat.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3TaskSpecification)) {
            return false;
        }
        ExportToS3TaskSpecification other = (ExportToS3TaskSpecification) obj;
        return Objects.equals(containerFormatAsString(), other.containerFormatAsString())
                && Objects.equals(diskImageFormatAsString(), other.diskImageFormatAsString())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Prefix(), other.s3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportToS3TaskSpecification").add("ContainerFormat", containerFormatAsString())
                .add("DiskImageFormat", diskImageFormatAsString()).add("S3Bucket", s3Bucket()).add("S3Prefix", s3Prefix())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerFormat":
            return Optional.ofNullable(clazz.cast(containerFormatAsString()));
        case "DiskImageFormat":
            return Optional.ofNullable(clazz.cast(diskImageFormatAsString()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportToS3TaskSpecification, T> g) {
        return obj -> g.apply((ExportToS3TaskSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportToS3TaskSpecification> {
        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(String containerFormat);

        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(ContainerFormat containerFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
         * READ_ACP permissions to the Amazon Web Services account <code>vm-import-export@amazon.com</code>.
         * </p>
         * 
         * @param s3Bucket
         *        The Amazon S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
         *        READ_ACP permissions to the Amazon Web Services account <code>vm-import-export@amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
         * diskImageFormat.
         * </p>
         * 
         * @param s3Prefix
         *        The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix + exportTaskId
         *        + '.' + diskImageFormat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String containerFormat;

        private String diskImageFormat;

        private String s3Bucket;

        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3TaskSpecification model) {
            containerFormat(model.containerFormat);
            diskImageFormat(model.diskImageFormat);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
        }

        public final String getContainerFormat() {
            return containerFormat;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat == null ? null : containerFormat.toString());
            return this;
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        @Override
        public ExportToS3TaskSpecification build() {
            return new ExportToS3TaskSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
