/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSecurityGroupRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteSecurityGroupRequest.Builder, DeleteSecurityGroupRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(DeleteSecurityGroupRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(DeleteSecurityGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            GROUP_NAME_FIELD));

    private final String groupId;

    private final String groupName;

    private DeleteSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The ID of the security group. Required for a nondefault VPC.
     * </p>
     * 
     * @return The ID of the security group. Required for a nondefault VPC.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the
     * security group ID.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the security group. You can specify either the security group name
     *         or the security group ID.
     */
    public final String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecurityGroupRequest)) {
            return false;
        }
        DeleteSecurityGroupRequest other = (DeleteSecurityGroupRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSecurityGroupRequest").add("GroupId", groupId()).add("GroupName", groupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSecurityGroupRequest, T> g) {
        return obj -> g.apply((DeleteSecurityGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSecurityGroupRequest> {
        /**
         * <p>
         * The ID of the security group. Required for a nondefault VPC.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group. Required for a nondefault VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or
         * the security group ID.
         * </p>
         * 
         * @param groupName
         *        [EC2-Classic, default VPC] The name of the security group. You can specify either the security group
         *        name or the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecurityGroupRequest model) {
            super(model);
            groupId(model.groupId);
            groupName(model.groupName);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSecurityGroupRequest build() {
            return new DeleteSecurityGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
