/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CidrBlockSetCopier {
    static List<CidrBlock> copy(Collection<? extends CidrBlock> cidrBlockSetParam) {
        List<CidrBlock> list;
        if (cidrBlockSetParam == null || cidrBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CidrBlock> modifiableList = new ArrayList<>();
            cidrBlockSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CidrBlock> copyFromBuilder(Collection<? extends CidrBlock.Builder> cidrBlockSetParam) {
        List<CidrBlock> list;
        if (cidrBlockSetParam == null || cidrBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CidrBlock> modifiableList = new ArrayList<>();
            cidrBlockSetParam.forEach(entry -> {
                CidrBlock member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CidrBlock.Builder> copyToBuilder(Collection<? extends CidrBlock> cidrBlockSetParam) {
        List<CidrBlock.Builder> list;
        if (cidrBlockSetParam == null || cidrBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CidrBlock.Builder> modifiableList = new ArrayList<>();
            cidrBlockSetParam.forEach(entry -> {
                CidrBlock.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
