/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum InstanceAttributeName {
    INSTANCE_TYPE("instanceType"),

    KERNEL("kernel"),

    RAMDISK("ramdisk"),

    USER_DATA("userData"),

    DISABLE_API_TERMINATION("disableApiTermination"),

    INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR("instanceInitiatedShutdownBehavior"),

    ROOT_DEVICE_NAME("rootDeviceName"),

    BLOCK_DEVICE_MAPPING("blockDeviceMapping"),

    PRODUCT_CODES("productCodes"),

    SOURCE_DEST_CHECK("sourceDestCheck"),

    GROUP_SET("groupSet"),

    EBS_OPTIMIZED("ebsOptimized"),

    SRIOV_NET_SUPPORT("sriovNetSupport"),

    ENA_SUPPORT("enaSupport"),

    ENCLAVE_OPTIONS("enclaveOptions"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceAttributeName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InstanceAttributeName corresponding to the value
     */
    public static InstanceAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceAttributeName.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InstanceAttributeName}s
     */
    public static Set<InstanceAttributeName> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
