/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomerGatewayRequest extends Ec2Request implements
        ToCopyableBuilder<CreateCustomerGatewayRequest.Builder, CreateCustomerGatewayRequest> {
    private static final SdkField<Integer> BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("BgpAsn")
            .getter(getter(CreateCustomerGatewayRequest::bgpAsn))
            .setter(setter(Builder::bgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpAsn")
                    .unmarshallLocationName("BgpAsn").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(CreateCustomerGatewayRequest::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("PublicIp").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn")
            .getter(getter(CreateCustomerGatewayRequest::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn")
                    .unmarshallLocationName("CertificateArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(CreateCustomerGatewayRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateCustomerGatewayRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceName")
            .getter(getter(CreateCustomerGatewayRequest::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("DeviceName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddress")
            .getter(getter(CreateCustomerGatewayRequest::ipAddress))
            .setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress")
                    .unmarshallLocationName("IpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BGP_ASN_FIELD,
            PUBLIC_IP_FIELD, CERTIFICATE_ARN_FIELD, TYPE_FIELD, TAG_SPECIFICATIONS_FIELD, DEVICE_NAME_FIELD, IP_ADDRESS_FIELD));

    private final Integer bgpAsn;

    private final String publicIp;

    private final String certificateArn;

    private final String type;

    private final List<TagSpecification> tagSpecifications;

    private final String deviceName;

    private final String ipAddress;

    private CreateCustomerGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.bgpAsn = builder.bgpAsn;
        this.publicIp = builder.publicIp;
        this.certificateArn = builder.certificateArn;
        this.type = builder.type;
        this.tagSpecifications = builder.tagSpecifications;
        this.deviceName = builder.deviceName;
        this.ipAddress = builder.ipAddress;
    }

    /**
     * <p>
     * For devices that support BGP, the customer gateway's BGP ASN.
     * </p>
     * <p>
     * Default: 65000
     * </p>
     * 
     * @return For devices that support BGP, the customer gateway's BGP ASN.</p>
     *         <p>
     *         Default: 65000
     */
    public final Integer bgpAsn() {
        return bgpAsn;
    }

    /**
     * <p>
     * <i>This member has been deprecated.</i> The Internet-routable IP address for the customer gateway's outside
     * interface. The address must be static.
     * </p>
     * 
     * @return <i>This member has been deprecated.</i> The Internet-routable IP address for the customer gateway's
     *         outside interface. The address must be static.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * @see GatewayType
     */
    public final GatewayType type() {
        return GatewayType.fromValue(type);
    }

    /**
     * <p>
     * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * @see GatewayType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the customer gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the customer gateway.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A name for the customer gateway device.
     * </p>
     * <p>
     * Length Constraints: Up to 255 characters.
     * </p>
     * 
     * @return A name for the customer gateway device.</p>
     *         <p>
     *         Length Constraints: Up to 255 characters.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * IPv4 address for the customer gateway device's outside interface. The address must be static.
     * </p>
     * 
     * @return IPv4 address for the customer gateway device's outside interface. The address must be static.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest) obj;
        return Objects.equals(bgpAsn(), other.bgpAsn()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ipAddress(), other.ipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomerGatewayRequest").add("BgpAsn", bgpAsn()).add("PublicIp", publicIp())
                .add("CertificateArn", certificateArn()).add("Type", typeAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DeviceName", deviceName())
                .add("IpAddress", ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BgpAsn":
            return Optional.ofNullable(clazz.cast(bgpAsn()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomerGatewayRequest, T> g) {
        return obj -> g.apply((CreateCustomerGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomerGatewayRequest> {
        /**
         * <p>
         * For devices that support BGP, the customer gateway's BGP ASN.
         * </p>
         * <p>
         * Default: 65000
         * </p>
         * 
         * @param bgpAsn
         *        For devices that support BGP, the customer gateway's BGP ASN.</p>
         *        <p>
         *        Default: 65000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpAsn(Integer bgpAsn);

        /**
         * <p>
         * <i>This member has been deprecated.</i> The Internet-routable IP address for the customer gateway's outside
         * interface. The address must be static.
         * </p>
         * 
         * @param publicIp
         *        <i>This member has been deprecated.</i> The Internet-routable IP address for the customer gateway's
         *        outside interface. The address must be static.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) for the customer gateway certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * The tags to apply to the customer gateway.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the customer gateway.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the customer gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TagSpecification>.Builder} avoiding
         * the need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A name for the customer gateway device.
         * </p>
         * <p>
         * Length Constraints: Up to 255 characters.
         * </p>
         * 
         * @param deviceName
         *        A name for the customer gateway device.</p>
         *        <p>
         *        Length Constraints: Up to 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * IPv4 address for the customer gateway device's outside interface. The address must be static.
         * </p>
         * 
         * @param ipAddress
         *        IPv4 address for the customer gateway device's outside interface. The address must be static.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer bgpAsn;

        private String publicIp;

        private String certificateArn;

        private String type;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String deviceName;

        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayRequest model) {
            super(model);
            bgpAsn(model.bgpAsn);
            publicIp(model.publicIp);
            certificateArn(model.certificateArn);
            type(model.type);
            tagSpecifications(model.tagSpecifications);
            deviceName(model.deviceName);
            ipAddress(model.ipAddress);
        }

        public final Integer getBgpAsn() {
            return bgpAsn;
        }

        public final void setBgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        @Override
        public final Builder bgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomerGatewayRequest build() {
            return new CreateCustomerGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
