/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPeeringAttachmentOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPeeringAttachmentOptions.Builder, TransitGatewayPeeringAttachmentOptions> {
    private static final SdkField<String> DYNAMIC_ROUTING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DynamicRouting")
            .getter(getter(TransitGatewayPeeringAttachmentOptions::dynamicRoutingAsString))
            .setter(setter(Builder::dynamicRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicRouting")
                    .unmarshallLocationName("dynamicRouting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_ROUTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dynamicRouting;

    private TransitGatewayPeeringAttachmentOptions(BuilderImpl builder) {
        this.dynamicRouting = builder.dynamicRouting;
    }

    /**
     * Returns the value of the DynamicRouting property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicRouting}
     * will return {@link DynamicRoutingValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRoutingAsString}.
     * </p>
     * 
     * @return The value of the DynamicRouting property for this object.
     * @see DynamicRoutingValue
     */
    public final DynamicRoutingValue dynamicRouting() {
        return DynamicRoutingValue.fromValue(dynamicRouting);
    }

    /**
     * Returns the value of the DynamicRouting property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicRouting}
     * will return {@link DynamicRoutingValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRoutingAsString}.
     * </p>
     * 
     * @return The value of the DynamicRouting property for this object.
     * @see DynamicRoutingValue
     */
    public final String dynamicRoutingAsString() {
        return dynamicRouting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRoutingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPeeringAttachmentOptions)) {
            return false;
        }
        TransitGatewayPeeringAttachmentOptions other = (TransitGatewayPeeringAttachmentOptions) obj;
        return Objects.equals(dynamicRoutingAsString(), other.dynamicRoutingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPeeringAttachmentOptions").add("DynamicRouting", dynamicRoutingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicRouting":
            return Optional.ofNullable(clazz.cast(dynamicRoutingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPeeringAttachmentOptions, T> g) {
        return obj -> g.apply((TransitGatewayPeeringAttachmentOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPeeringAttachmentOptions> {
        /**
         * Sets the value of the DynamicRouting property for this object.
         *
         * @param dynamicRouting
         *        The new value for the DynamicRouting property for this object.
         * @see DynamicRoutingValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamicRoutingValue
         */
        Builder dynamicRouting(String dynamicRouting);

        /**
         * Sets the value of the DynamicRouting property for this object.
         *
         * @param dynamicRouting
         *        The new value for the DynamicRouting property for this object.
         * @see DynamicRoutingValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamicRoutingValue
         */
        Builder dynamicRouting(DynamicRoutingValue dynamicRouting);
    }

    static final class BuilderImpl implements Builder {
        private String dynamicRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPeeringAttachmentOptions model) {
            dynamicRouting(model.dynamicRouting);
        }

        public final String getDynamicRouting() {
            return dynamicRouting;
        }

        public final void setDynamicRouting(String dynamicRouting) {
            this.dynamicRouting = dynamicRouting;
        }

        @Override
        public final Builder dynamicRouting(String dynamicRouting) {
            this.dynamicRouting = dynamicRouting;
            return this;
        }

        @Override
        public final Builder dynamicRouting(DynamicRoutingValue dynamicRouting) {
            this.dynamicRouting(dynamicRouting == null ? null : dynamicRouting.toString());
            return this;
        }

        @Override
        public TransitGatewayPeeringAttachmentOptions build() {
            return new TransitGatewayPeeringAttachmentOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
