/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateInstanceMaintenanceOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateInstanceMaintenanceOptionsRequest> {
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoRecovery").getter(LaunchTemplateInstanceMaintenanceOptionsRequest.getter(LaunchTemplateInstanceMaintenanceOptionsRequest::autoRecoveryAsString)).setter(LaunchTemplateInstanceMaintenanceOptionsRequest.setter(Builder::autoRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery").unmarshallLocationName("AutoRecovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RECOVERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoRecovery;

    private LaunchTemplateInstanceMaintenanceOptionsRequest(BuilderImpl builder) {
        this.autoRecovery = builder.autoRecovery;
    }

    public final LaunchTemplateAutoRecoveryState autoRecovery() {
        return LaunchTemplateAutoRecoveryState.fromValue(this.autoRecovery);
    }

    public final String autoRecoveryAsString() {
        return this.autoRecovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRecoveryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceMaintenanceOptionsRequest)) {
            return false;
        }
        LaunchTemplateInstanceMaintenanceOptionsRequest other = (LaunchTemplateInstanceMaintenanceOptionsRequest)obj;
        return Objects.equals(this.autoRecoveryAsString(), other.autoRecoveryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateInstanceMaintenanceOptionsRequest").add("AutoRecovery", (Object)this.autoRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoRecovery": {
                return Optional.ofNullable(clazz.cast(this.autoRecoveryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceMaintenanceOptionsRequest, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceMaintenanceOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceMaintenanceOptionsRequest model) {
            this.autoRecovery(model.autoRecovery);
        }

        public final String getAutoRecovery() {
            return this.autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(LaunchTemplateAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        public LaunchTemplateInstanceMaintenanceOptionsRequest build() {
            return new LaunchTemplateInstanceMaintenanceOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateInstanceMaintenanceOptionsRequest> {
        public Builder autoRecovery(String var1);

        public Builder autoRecovery(LaunchTemplateAutoRecoveryState var1);
    }
}

