/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CopyImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageRequest extends Ec2Request implements ToCopyableBuilder<CopyImageRequest.Builder, CopyImageRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CopyImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CopyImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(CopyImageRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(CopyImageRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CopyImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceImageId")
            .getter(getter(CopyImageRequest::sourceImageId))
            .setter(setter(Builder::sourceImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageId")
                    .unmarshallLocationName("SourceImageId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion")
            .getter(getter(CopyImageRequest::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion")
                    .unmarshallLocationName("SourceRegion").build()).build();

    private static final SdkField<String> DESTINATION_OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationOutpostArn")
            .getter(getter(CopyImageRequest::destinationOutpostArn))
            .setter(setter(Builder::destinationOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOutpostArn")
                    .unmarshallLocationName("DestinationOutpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD, SOURCE_IMAGE_ID_FIELD, SOURCE_REGION_FIELD,
            DESTINATION_OUTPOST_ARN_FIELD));

    private final String clientToken;

    private final String description;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String name;

    private final String sourceImageId;

    private final String sourceRegion;

    private final String destinationOutpostArn;

    private CopyImageRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.sourceImageId = builder.sourceImageId;
        this.sourceRegion = builder.sourceRegion;
        this.destinationOutpostArn = builder.destinationOutpostArn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description for the new AMI in the destination Region.
     * </p>
     * 
     * @return A description for the new AMI in the destination Region.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an
     * unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default CMK for EBS
     * is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using <code>KmsKeyId</code>.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon
     * EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a
     *         copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The
     *         default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK
     *         using <code>KmsKeyId</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>
     *         in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when
     * creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is used. If you
     * specify a CMK, you must also set the encrypted state to <code>true</code>.
     * </p>
     * <p>
     * You can specify a CMK using any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias. For example, alias/ExampleAlias.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * </p>
     * </li>
     * </ul>
     * <p>
     * AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid, the action
     * can appear to complete, but eventually fails.
     * </p>
     * <p>
     * The specified CMK must exist in the destination Region.
     * </p>
     * <p>
     * Amazon EBS does not support asymmetric CMKs.
     * </p>
     * 
     * @return The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use
     *         when creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is
     *         used. If you specify a CMK, you must also set the encrypted state to <code>true</code>.</p>
     *         <p>
     *         You can specify a CMK using any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias. For example, alias/ExampleAlias.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid, the
     *         action can appear to complete, but eventually fails.
     *         </p>
     *         <p>
     *         The specified CMK must exist in the destination Region.
     *         </p>
     *         <p>
     *         Amazon EBS does not support asymmetric CMKs.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the new AMI in the destination Region.
     * </p>
     * 
     * @return The name of the new AMI in the destination Region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the AMI to copy.
     * </p>
     * 
     * @return The ID of the AMI to copy.
     */
    public final String sourceImageId() {
        return sourceImageId;
    }

    /**
     * <p>
     * The name of the Region that contains the AMI to copy.
     * </p>
     * 
     * @return The name of the Region that contains the AMI to copy.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying
     * an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot
     * copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from
     * an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when
     *         copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination
     *         Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the
     *         same Outpost.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying
     *         AMIs from an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String destinationOutpostArn() {
        return destinationOutpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(destinationOutpostArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageRequest)) {
            return false;
        }
        CopyImageRequest other = (CopyImageRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceImageId(), other.sourceImageId())
                && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(destinationOutpostArn(), other.destinationOutpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyImageRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId()).add("Name", name())
                .add("SourceImageId", sourceImageId()).add("SourceRegion", sourceRegion())
                .add("DestinationOutpostArn", destinationOutpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceImageId":
            return Optional.ofNullable(clazz.cast(sourceImageId()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "DestinationOutpostArn":
            return Optional.ofNullable(clazz.cast(destinationOutpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyImageRequest, T> g) {
        return obj -> g.apply((CopyImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CopyImageRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description for the new AMI in the destination Region.
         * </p>
         * 
         * @param description
         *        A description for the new AMI in the destination Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy
         * of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default
         * CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using
         * <code>KmsKeyId</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a
         *        copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot.
         *        The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS)
         *        CMK using <code>KmsKeyId</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         *        Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when
         * creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is used. If you
         * specify a CMK, you must also set the encrypted state to <code>true</code>.
         * </p>
         * <p>
         * You can specify a CMK using any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias. For example, alias/ExampleAlias.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * </p>
         * </li>
         * </ul>
         * <p>
         * AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid, the
         * action can appear to complete, but eventually fails.
         * </p>
         * <p>
         * The specified CMK must exist in the destination Region.
         * </p>
         * <p>
         * Amazon EBS does not support asymmetric CMKs.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use
         *        when creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is
         *        used. If you specify a CMK, you must also set the encrypted state to <code>true</code>.</p>
         *        <p>
         *        You can specify a CMK using any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias. For example, alias/ExampleAlias.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid,
         *        the action can appear to complete, but eventually fails.
         *        </p>
         *        <p>
         *        The specified CMK must exist in the destination Region.
         *        </p>
         *        <p>
         *        Amazon EBS does not support asymmetric CMKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the new AMI in the destination Region.
         * </p>
         * 
         * @param name
         *        The name of the new AMI in the destination Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the AMI to copy.
         * </p>
         * 
         * @param sourceImageId
         *        The ID of the AMI to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageId(String sourceImageId);

        /**
         * <p>
         * The name of the Region that contains the AMI to copy.
         * </p>
         * 
         * @param sourceRegion
         *        The name of the Region that contains the AMI to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when
         * copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
         * You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs
         * from an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param destinationOutpostArn
         *        The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter
         *        when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination
         *        Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within
         *        the same Outpost.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying
         *        AMIs from an AWS Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationOutpostArn(String destinationOutpostArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private Boolean encrypted;

        private String kmsKeyId;

        private String name;

        private String sourceImageId;

        private String sourceRegion;

        private String destinationOutpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            sourceImageId(model.sourceImageId);
            sourceRegion(model.sourceRegion);
            destinationOutpostArn(model.destinationOutpostArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceImageId() {
            return sourceImageId;
        }

        public final void setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
        }

        @Override
        @Transient
        public final Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        @Transient
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getDestinationOutpostArn() {
            return destinationOutpostArn;
        }

        public final void setDestinationOutpostArn(String destinationOutpostArn) {
            this.destinationOutpostArn = destinationOutpostArn;
        }

        @Override
        @Transient
        public final Builder destinationOutpostArn(String destinationOutpostArn) {
            this.destinationOutpostArn = destinationOutpostArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyImageRequest build() {
            return new CopyImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
