/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<TerminateInstancesResponse.Builder, TerminateInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> TERMINATING_INSTANCES_FIELD = SdkField
            .<List<InstanceStateChange>> builder(MarshallingType.LIST)
            .memberName("TerminatingInstances")
            .getter(getter(TerminateInstancesResponse::terminatingInstances))
            .setter(setter(Builder::terminatingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATING_INSTANCES_FIELD));

    private final List<InstanceStateChange> terminatingInstances;

    private TerminateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.terminatingInstances = builder.terminatingInstances;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminatingInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminatingInstances() {
        return terminatingInstances != null && !(terminatingInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the terminated instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminatingInstances} method.
     * </p>
     * 
     * @return Information about the terminated instances.
     */
    public final List<InstanceStateChange> terminatingInstances() {
        return terminatingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminatingInstances() ? terminatingInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstancesResponse)) {
            return false;
        }
        TerminateInstancesResponse other = (TerminateInstancesResponse) obj;
        return hasTerminatingInstances() == other.hasTerminatingInstances()
                && Objects.equals(terminatingInstances(), other.terminatingInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateInstancesResponse")
                .add("TerminatingInstances", hasTerminatingInstances() ? terminatingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminatingInstances":
            return Optional.ofNullable(clazz.cast(terminatingInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateInstancesResponse, T> g) {
        return obj -> g.apply((TerminateInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, TerminateInstancesResponse> {
        /**
         * <p>
         * Information about the terminated instances.
         * </p>
         * 
         * @param terminatingInstances
         *        Information about the terminated instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances);

        /**
         * <p>
         * Information about the terminated instances.
         * </p>
         * 
         * @param terminatingInstances
         *        Information about the terminated instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminatingInstances(InstanceStateChange... terminatingInstances);

        /**
         * <p>
         * Information about the terminated instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #terminatingInstances(List<InstanceStateChange>)}.
         * 
         * @param terminatingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminatingInstances(List<InstanceStateChange>)
         */
        Builder terminatingInstances(Consumer<InstanceStateChange.Builder>... terminatingInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> terminatingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstancesResponse model) {
            super(model);
            terminatingInstances(model.terminatingInstances);
        }

        public final List<InstanceStateChange.Builder> getTerminatingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.terminatingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerminatingInstances(Collection<InstanceStateChange.BuilderImpl> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copyFromBuilder(terminatingInstances);
        }

        @Override
        @Transient
        public final Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copy(terminatingInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terminatingInstances(InstanceStateChange... terminatingInstances) {
            terminatingInstances(Arrays.asList(terminatingInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terminatingInstances(Consumer<InstanceStateChange.Builder>... terminatingInstances) {
            terminatingInstances(Stream.of(terminatingInstances).map(c -> InstanceStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TerminateInstancesResponse build() {
            return new TerminateInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
