/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTransitGatewayMulticastDomainResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateTransitGatewayMulticastDomainResponse.Builder, AssociateTransitGatewayMulticastDomainResponse> {
    private static final SdkField<TransitGatewayMulticastDomainAssociations> ASSOCIATIONS_FIELD = SdkField
            .<TransitGatewayMulticastDomainAssociations> builder(MarshallingType.SDK_POJO)
            .memberName("Associations")
            .getter(getter(AssociateTransitGatewayMulticastDomainResponse::associations))
            .setter(setter(Builder::associations))
            .constructor(TransitGatewayMulticastDomainAssociations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations")
                    .unmarshallLocationName("associations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD));

    private final TransitGatewayMulticastDomainAssociations associations;

    private AssociateTransitGatewayMulticastDomainResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
    }

    /**
     * <p>
     * Information about the transit gateway multicast domain associations.
     * </p>
     * 
     * @return Information about the transit gateway multicast domain associations.
     */
    public final TransitGatewayMulticastDomainAssociations associations() {
        return associations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTransitGatewayMulticastDomainResponse)) {
            return false;
        }
        AssociateTransitGatewayMulticastDomainResponse other = (AssociateTransitGatewayMulticastDomainResponse) obj;
        return Objects.equals(associations(), other.associations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateTransitGatewayMulticastDomainResponse").add("Associations", associations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTransitGatewayMulticastDomainResponse, T> g) {
        return obj -> g.apply((AssociateTransitGatewayMulticastDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateTransitGatewayMulticastDomainResponse> {
        /**
         * <p>
         * Information about the transit gateway multicast domain associations.
         * </p>
         * 
         * @param associations
         *        Information about the transit gateway multicast domain associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(TransitGatewayMulticastDomainAssociations associations);

        /**
         * <p>
         * Information about the transit gateway multicast domain associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayMulticastDomainAssociations.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayMulticastDomainAssociations#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastDomainAssociations.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #associations(TransitGatewayMulticastDomainAssociations)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link TransitGatewayMulticastDomainAssociations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(TransitGatewayMulticastDomainAssociations)
         */
        default Builder associations(Consumer<TransitGatewayMulticastDomainAssociations.Builder> associations) {
            return associations(TransitGatewayMulticastDomainAssociations.builder().applyMutation(associations).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastDomainAssociations associations;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTransitGatewayMulticastDomainResponse model) {
            super(model);
            associations(model.associations);
        }

        public final TransitGatewayMulticastDomainAssociations.Builder getAssociations() {
            return associations != null ? associations.toBuilder() : null;
        }

        public final void setAssociations(TransitGatewayMulticastDomainAssociations.BuilderImpl associations) {
            this.associations = associations != null ? associations.build() : null;
        }

        @Override
        public final Builder associations(TransitGatewayMulticastDomainAssociations associations) {
            this.associations = associations;
            return this;
        }

        @Override
        public AssociateTransitGatewayMulticastDomainResponse build() {
            return new AssociateTransitGatewayMulticastDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
