/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplaceRootVolumeTaskResponse extends Ec2Response implements
        ToCopyableBuilder<CreateReplaceRootVolumeTaskResponse.Builder, CreateReplaceRootVolumeTaskResponse> {
    private static final SdkField<ReplaceRootVolumeTask> REPLACE_ROOT_VOLUME_TASK_FIELD = SdkField
            .<ReplaceRootVolumeTask> builder(MarshallingType.SDK_POJO)
            .memberName("ReplaceRootVolumeTask")
            .getter(getter(CreateReplaceRootVolumeTaskResponse::replaceRootVolumeTask))
            .setter(setter(Builder::replaceRootVolumeTask))
            .constructor(ReplaceRootVolumeTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRootVolumeTask")
                    .unmarshallLocationName("replaceRootVolumeTask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REPLACE_ROOT_VOLUME_TASK_FIELD));

    private final ReplaceRootVolumeTask replaceRootVolumeTask;

    private CreateReplaceRootVolumeTaskResponse(BuilderImpl builder) {
        super(builder);
        this.replaceRootVolumeTask = builder.replaceRootVolumeTask;
    }

    /**
     * <p>
     * Information about the root volume replacement task.
     * </p>
     * 
     * @return Information about the root volume replacement task.
     */
    public final ReplaceRootVolumeTask replaceRootVolumeTask() {
        return replaceRootVolumeTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replaceRootVolumeTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplaceRootVolumeTaskResponse)) {
            return false;
        }
        CreateReplaceRootVolumeTaskResponse other = (CreateReplaceRootVolumeTaskResponse) obj;
        return Objects.equals(replaceRootVolumeTask(), other.replaceRootVolumeTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplaceRootVolumeTaskResponse").add("ReplaceRootVolumeTask", replaceRootVolumeTask())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplaceRootVolumeTask":
            return Optional.ofNullable(clazz.cast(replaceRootVolumeTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplaceRootVolumeTaskResponse, T> g) {
        return obj -> g.apply((CreateReplaceRootVolumeTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplaceRootVolumeTaskResponse> {
        /**
         * <p>
         * Information about the root volume replacement task.
         * </p>
         * 
         * @param replaceRootVolumeTask
         *        Information about the root volume replacement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceRootVolumeTask(ReplaceRootVolumeTask replaceRootVolumeTask);

        /**
         * <p>
         * Information about the root volume replacement task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplaceRootVolumeTask.Builder} avoiding
         * the need to create one manually via {@link ReplaceRootVolumeTask#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplaceRootVolumeTask.Builder#build()} is called immediately and
         * its result is passed to {@link #replaceRootVolumeTask(ReplaceRootVolumeTask)}.
         * 
         * @param replaceRootVolumeTask
         *        a consumer that will call methods on {@link ReplaceRootVolumeTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replaceRootVolumeTask(ReplaceRootVolumeTask)
         */
        default Builder replaceRootVolumeTask(Consumer<ReplaceRootVolumeTask.Builder> replaceRootVolumeTask) {
            return replaceRootVolumeTask(ReplaceRootVolumeTask.builder().applyMutation(replaceRootVolumeTask).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ReplaceRootVolumeTask replaceRootVolumeTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplaceRootVolumeTaskResponse model) {
            super(model);
            replaceRootVolumeTask(model.replaceRootVolumeTask);
        }

        public final ReplaceRootVolumeTask.Builder getReplaceRootVolumeTask() {
            return replaceRootVolumeTask != null ? replaceRootVolumeTask.toBuilder() : null;
        }

        public final void setReplaceRootVolumeTask(ReplaceRootVolumeTask.BuilderImpl replaceRootVolumeTask) {
            this.replaceRootVolumeTask = replaceRootVolumeTask != null ? replaceRootVolumeTask.build() : null;
        }

        @Override
        public final Builder replaceRootVolumeTask(ReplaceRootVolumeTask replaceRootVolumeTask) {
            this.replaceRootVolumeTask = replaceRootVolumeTask;
            return this;
        }

        @Override
        public CreateReplaceRootVolumeTaskResponse build() {
            return new CreateReplaceRootVolumeTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
